/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.Keycol;
import kd.macc.cad.common.helper.CalcDimenHelper;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.opplugin.CommonOp;
import kd.macc.cad.opplugin.PurPriceSaveOpValidate;

public class PurPriceSaveOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("currency");
        fieldKeys.add("id");
        fieldKeys.add("matversion");
        fieldKeys.add("auxpty");
        fieldKeys.add("element");
        fieldKeys.add("rate");
        fieldKeys.add("istoupdate");
        fieldKeys.add("subelement");
        fieldKeys.add("rate");
        fieldKeys.add("amount");
        fieldKeys.add("price");
        fieldKeys.add("costtype");
        fieldKeys.add("material");
        fieldKeys.add("auxpty");
        fieldKeys.add("configuredcode");
        fieldKeys.add("tracknumber");
        fieldKeys.add("project");
        fieldKeys.add("lot");
        fieldKeys.add("keycol");
        fieldKeys.add("keycolid");
        fieldKeys.add("pricerule");
        fieldKeys.add("effectdate");
        fieldKeys.add("expdate");
        fieldKeys.add("datasrc");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PurPriceSaveOpValidate());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        this.updateData(e);
    }

    private void updateData(EndOperationTransactionArgs e) {
        DynamicObject[] updateData;
        DynamicObject[] datas = e.getDataEntities();
        HashSet<Object> ids = new HashSet<Object>();
        HashSet<Long> subElementId = new HashSet<Long>();
        for (DynamicObject data : datas) {
            data.set("istoupdate", (Object)true);
            if (data.get("currency") == null) {
                ids.add(data.getPkValue());
            }
            int priceprecision = data.getInt("costtype.currency.priceprecision");
            DynamicObjectCollection entity = data.getDynamicObjectCollection("entryentity");
            for (DynamicObject en : entity) {
                if (en.get("element") == null) {
                    ids.add(data.getPkValue());
                    subElementId.add(en.getLong("subelement.id"));
                }
                if (!CadEmptyUtils.isEmpty((Integer)priceprecision)) {
                    en.set("price", (Object)en.getBigDecimal("price").setScale(priceprecision, 4));
                }
                if ("002".equals(en.getString("subelement.type"))) continue;
                en.set("rate", (Object)BigDecimal.ZERO);
            }
            data.set("auxpty", (Object)CalcDimenHelper.getAffectAuxpty((Object)data.get("material"), (Object)data.get("auxpty")));
            HashMap<String, Object> keycolMap = new HashMap<String, Object>(16);
            keycolMap.put("material", data.get("material.masterid"));
            keycolMap.put("auxproperty", data.get("auxpty"));
            keycolMap.put("configuredcode", data.get("configuredcode.id"));
            keycolMap.put("tracknumber", data.get("tracknumber.id"));
            keycolMap.put("project", data.get("project.id"));
            keycolMap.put("lot", data.get("lot"));
            Keycol calcKey = CalcKeyHelper.getCalcKey(keycolMap, new ArrayList(), (boolean)true);
            data.set("keycol", (Object)calcKey.getKeycol());
            data.set("keycolid", (Object)calcKey.getId());
            data.set("keycolid_id", (Object)calcKey.getId());
        }
        SaveServiceHelper.update((DynamicObject[])datas);
        if (ids.size() == 0) {
            return;
        }
        Map<Long, Long> mapElement = CommonOp.getElementRelation(subElementId.toArray(new Long[0]));
        for (DynamicObject data : updateData = BusinessDataServiceHelper.load((String)"cad_purprices", (String)"costtype,matversion,currency,amount,entryentity.element,entryentity.subelement,entryentity.price", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids.toArray())})) {
            if (!CostTypeHelper.isUseMatVersion((Long)data.getLong("costtype.id"))) {
                data.set("matversion", (Object)0L);
            }
            int priceprecision = data.getInt("costtype.currency.priceprecision");
            if (data.get("currency") == null) {
                DynamicObject costType = (DynamicObject)data.get("costtype");
                data.set("currency", (Object)costType.getLong("currency.id"));
            }
            BigDecimal subAmount = BigDecimal.ZERO;
            DynamicObjectCollection entity = data.getDynamicObjectCollection("entryentity");
            for (DynamicObject en : entity) {
                if (en.get("element") == null) {
                    en.set("element", (Object)mapElement.get(en.get("subelement.id")));
                }
                if (!CadEmptyUtils.isEmpty((Integer)priceprecision)) {
                    en.set("price", (Object)en.getBigDecimal("price").setScale(priceprecision, 4));
                }
                subAmount = subAmount.add(en.getBigDecimal("price"));
            }
            data.set("amount", (Object)subAmount);
        }
        SaveServiceHelper.update((DynamicObject[])updateData);
    }
}

