/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.enums.CostTypePtyEnum;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.opplugin.ImportSaveOpValidate;

public class PurPriceSaveOpValidate
extends ImportSaveOpValidate {
    private static final String MATTYPE = "001";
    private static final String MATCOST = "002";

    @Override
    protected void validateSave(ExtendedDataEntity dataEntity, List<String> repeatKeyList) {
        DynamicObjectCollection entry;
        BigDecimal amount;
        String amountStr;
        String[] amountInfos;
        DynamicObject mat;
        QFilter qfBillNo;
        DynamicObject item = dataEntity.getDataEntity();
        String dataSrc = item.getString("datasrc");
        if (CadEmptyUtils.isEmpty((String)dataSrc) || "manual".equals(dataSrc)) {
            item.set("pricerule", (Object)PriceRuleConstants.PUR_MANUALLY_ID);
            item.set("pricerule_id", (Object)PriceRuleConstants.PUR_MANUALLY_ID);
        }
        item.set("effectdate", (Object)DateUtils.getDayStartTime((Date)item.getDate("effectdate")));
        QFilter qfId = new QFilter("id", "!=", item.getPkValue());
        String billNo = item.getString("billno");
        if (StringUtils.isEmpty((String)billNo)) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5355\u636e\u7f16\u53f7\u201d\u3002", (String)"PurPriceSaveOpValidate_0", (String)"macc-cad-opplugin", (Object[])new Object[0]));
        }
        if (QueryServiceHelper.exists((String)"cad_purprices", (QFilter[])new QFilter[]{qfId, qfBillNo = new QFilter("billno", "=", (Object)billNo)})) {
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5355\u636e\u7f16\u53f7%s\u3002", (String)"PurPriceSaveOpValidate_26", (String)"macc-cad-opplugin", (Object[])new Object[0]), item.getString("billno")));
        }
        DynamicObject costType = item.getDynamicObject("costtype");
        if (CostTypePtyEnum.CALCULATING.getValue().equals(costType.getString("type"))) {
            String tips = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6210\u672c\u7c7b\u578b\u4e3a\u201c\u6838\u7b97\u6210\u672c\u201d\u7684\u5f15\u5165\u3002", (String)"PurPriceSaveOpValidate_2", (String)"macc-cad-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, tips);
        }
        if ((mat = item.getDynamicObject("material")) == null) {
            return;
        }
        HashSet<Long> auxptyId = new HashSet<Long>();
        Boolean isUseAuxpty = mat.getBoolean("isuseauxpty");
        Boolean isAuxprop = false;
        if (isUseAuxpty.booleanValue()) {
            DynamicObjectCollection isaffectprice = mat.getDynamicObjectCollection("auxptyentry");
            for (DynamicObject isPrice : isaffectprice) {
                if (!isPrice.getBoolean("isaffectprice")) continue;
                auxptyId.add(isPrice.getLong("auxpty.id"));
                isAuxprop = true;
            }
        }
        DynamicObject auxpty = item.getDynamicObject("auxpty");
        if (isAuxprop.booleanValue()) {
            if (auxpty == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027\u672a\u586b\u5199\u3002", (String)"PurPriceSaveOpValidate_7", (String)"macc-cad-opplugin", (Object[])new Object[0]));
            } else {
                Boolean notAuxpty = this.checkAuxptyExist(auxptyId, (String)auxpty.get(1));
                if (notAuxpty.booleanValue()) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027\u672a\u586b\u5199\u3002", (String)"PurPriceSaveOpValidate_7", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                }
            }
        }
        if ((amountInfos = (amountStr = item.getString("amount")).split("\\.")).length > 0 && amountInfos[0].length() > 13) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u6807\u51c6\u91d1\u989d\u201d\u5df2\u8d85\u8fc7\u53ef\u5b58\u50a8\u7684\u6570\u636e\u8303\u56f4\uff0c\u8bf7\u8c03\u6574\u8d39\u7387\u3002", (String)"PurPriceSaveOpValidate_10", (String)"macc-cad-opplugin", (Object[])new Object[0]));
        }
        if ((amount = item.getBigDecimal("amount")) != null && amount.compareTo(BigDecimal.ZERO) < 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u6807\u51c6\u91d1\u989d\u201d\u4e0d\u80fd\u5c0f\u4e8e0\uff0c\u8bf7\u8c03\u6574\u6210\u672c\u5b50\u8981\u7d20\u7684\u6807\u51c6\u5355\u4ef7\u3002", (String)"PurPriceSaveOpValidate_25", (String)"macc-cad-opplugin", (Object[])new Object[0]));
        }
        if ((entry = item.getDynamicObjectCollection("entryentity")).size() == 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7269\u6599\u5bf9\u5e94\u6210\u672c\u5b50\u8981\u7d20\u4fe1\u606f\u7684\u5206\u5f55\u4e3a\u7a7a\uff0c\u8bf7\u5b8c\u5584\u8be5\u5206\u5f55\u7684\u6570\u636e\u540e\u518d\u8bd5\u3002", (String)"PurPriceSaveOpValidate_11", (String)"macc-cad-opplugin", (Object[])new Object[0]));
        }
        BigDecimal sum = BigDecimal.ZERO;
        for (DynamicObject en : entry) {
            if (!MATTYPE.equals(en.getString("subelement.type"))) continue;
            sum = sum.add(en.getBigDecimal("price"));
        }
        int index = 1;
        HashSet<Long> innerSubElement = new HashSet<Long>();
        for (DynamicObject en : entry) {
            long subElement = en.getLong("subelement.id");
            if (innerSubElement.contains(subElement)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\u6210\u672c\u8981\u7d20\u4e0e\u6210\u672c\u5b50\u8981\u7d20\u91cd\u590d\u3002", (String)"PurPriceSaveOpValidate_15", (String)"macc-cad-opplugin", (Object[])new Object[0]), index));
            } else {
                innerSubElement.add(subElement);
            }
            ++index;
            if (!MATCOST.equals(en.getString("subelement.type"))) continue;
            int priceprecision = costType.getInt("currency.priceprecision");
            BigDecimal priceCalc = sum.multiply(en.getBigDecimal("rate").divide(new BigDecimal(100), 10, 4)).setScale(priceprecision, 4);
            priceCalc = priceCalc.setScale(en.getBigDecimal("price").scale(), 4);
            if (!en.getBoolean("subelement.supmaterielcount") || en.getBigDecimal("price").compareTo(priceCalc) == 0) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\u4e0d\u7b49\u4e8e\u7269\u6599\u5b50\u8981\u7d20*\u6bd4\u7387\u3002", (String)"PurPriceSaveOpValidate_16", (String)"macc-cad-opplugin", (Object[])new Object[0]), index - 1));
        }
    }

    private Boolean checkAuxptyExist(Set<Long> auxptyId, String flex) {
        DynamicObject[] auxpty;
        Boolean isNotExist = false;
        for (DynamicObject aux : auxpty = BusinessDataServiceHelper.load((Object[])auxptyId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_auxproperty"))) {
            if (flex.contains(aux.getString("flexfield"))) continue;
            isNotExist = true;
            break;
        }
        return isNotExist;
    }
}

