/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.opplugin.ImportSaveOpValidate;

public class ResourceOutSaveOpValidate
extends ImportSaveOpValidate {
    @Override
    protected void validateSave(ExtendedDataEntity dataEntity, List<String> repeatKeyList) {
        String operationNoStr;
        String processSeqStr;
        DynamicObject mat;
        long unitId;
        DynamicObject entity = dataEntity.getDataEntity();
        String dataSrc = entity.getString("datasrc");
        if (CadEmptyUtils.isEmpty((String)dataSrc) || "manual".equals(dataSrc)) {
            entity.set("pricerule_id", (Object)PriceRuleConstants.OUTRES_MANUALLY_ID);
        }
        entity.set("effectdate", (Object)DateUtils.getDayStartTime((Date)entity.getDate("effectdate")));
        DynamicObject costtype = (DynamicObject)dataEntity.getValue("costtype");
        DynamicObject resource = (DynamicObject)dataEntity.getValue("resource");
        String calcbasis = (String)dataEntity.getValue("calcbasis");
        DynamicObject resourceUnit = (DynamicObject)dataEntity.getValue("resourceunit");
        long l = unitId = resourceUnit == null ? 0L : resourceUnit.getLong("id");
        if ("0".equals(costtype.getString("type"))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u624b\u5de5\u65b0\u589e\u3002", (String)"ResourceOutSaveOpValidate_0", (String)"macc-cad-opplugin", (Object[])new Object[0]));
        }
        boolean hasNull = false;
        if (resource == null) {
            hasNull = true;
        }
        BigDecimal amount = (BigDecimal)dataEntity.getValue("amount");
        BigDecimal zeroDy = new BigDecimal(0);
        if ("001".equals(calcbasis)) {
            entity.set("amount", (Object)BigDecimal.ZERO);
            if (unitId != 8L && unitId != 9L && unitId != 10L) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u7b97\u4f9d\u636e\u4e3a\u8d44\u6e90\u5de5\u65f6\uff0c\u8d44\u6e90\u5355\u4f4d\u5fc5\u987b\u4e3a\u201c\u65f6/\u5206/\u79d2\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ResourceOutSaveOpValidate_1", (String)"macc-cad-opplugin", (Object[])new Object[0]));
            }
        }
        if ("002".equals(calcbasis) || "003".equals(calcbasis)) {
            entity.set("qty", (Object)BigDecimal.ZERO);
            if (zeroDy.setScale(amount.scale()).equals(amount)) {
                hasNull = true;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5355\u636e\u5934\u7684 \u201c\u91d1\u989d\u201d\u3002", (String)"ResourceOutSaveOpValidate_2", (String)"macc-cad-opplugin", (Object[])new Object[0]));
            }
            if (unitId != 11L) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u7b97\u4f9d\u636e\u4e3a\u7269\u6599\u6216\u6279\u6b21\uff0c\u8d44\u6e90\u5355\u4f4d\u5fc5\u987b\u4e3a\u201c\u4e2a\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ResourceOutSaveOpValidate_3", (String)"macc-cad-opplugin", (Object[])new Object[0]));
            }
        }
        if ((mat = entity.getDynamicObject("material")) != null) {
            HashSet<Long> auxptyId = new HashSet<Long>();
            HashSet<Long> allAuxptyId = new HashSet<Long>();
            Boolean isUseAuxpty = mat.getBoolean("isuseauxpty");
            Boolean isAuxprop = false;
            if (isUseAuxpty.booleanValue()) {
                DynamicObjectCollection isaffectprice = mat.getDynamicObjectCollection("auxptyentry");
                for (DynamicObject isPrice : isaffectprice) {
                    if (isPrice.getBoolean("isaffectprice")) {
                        auxptyId.add(isPrice.getLong("auxpty.id"));
                        isAuxprop = true;
                    }
                    allAuxptyId.add(isPrice.getLong("auxpty.id"));
                }
            }
            DynamicObject auxpty = entity.getDynamicObject("auxpty");
            if (isAuxprop.booleanValue()) {
                if (auxpty == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027\u672a\u586b\u5199\u3002", (String)"ResourceOutSaveOpValidate_10", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                } else {
                    Boolean notAuxpty = this.checkAuxptyExist(auxptyId, (String)auxpty.get(1));
                    if (notAuxpty.booleanValue()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027\u672a\u586b\u5199\u3002", (String)"ResourceOutSaveOpValidate_10", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    }
                }
            }
        }
        if (!(processSeqStr = entity.getString("processseq")).matches("^(?!0+$)\\d{1,4}$")) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u3010%s\u3011\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8f93\u51654\u4f4d\u62164\u4f4d\u4ee5\u5185\u7684\u6b63\u6574\u6570\u3002", (String)"ResourceOutSaveOpValidate_11", (String)"macc-cad-opplugin", (Object[])new Object[0]), processSeqStr));
        }
        if (!(operationNoStr = entity.getString("operationno")).matches("^(?!0+$)\\d{1,4}$")) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u53f7\u3010%s\u3011\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8f93\u51654\u4f4d\u62164\u4f4d\u4ee5\u5185\u7684\u6b63\u6574\u6570\u3002", (String)"ResourceOutSaveOpValidate_12", (String)"macc-cad-opplugin", (Object[])new Object[0]), operationNoStr));
        }
        if (processSeqStr.matches("^(?!0+$)\\d{1,4}$") && operationNoStr.matches("^(?!0+$)\\d{1,4}$")) {
            String routeInfo = this.getRouteInfo(entity.getString("srcroute"), entity.getLong("route.id"), entity.getString("processseq"), entity.getString("operationno"));
            if (routeInfo == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u80fd\u6309\u7167\u5de5\u827a\u8def\u7ebf\u7f16\u7801+\u5e8f\u5217\u53f7+\u5de5\u5e8f\u53f7\u7ef4\u5ea6\u83b7\u53d6\u5230\u5de5\u5e8f\u7f16\u7801/\u5de5\u5e8f\u8bf4\u660e/\u5de5\u4f4d\u76f8\u5173\u4fe1\u606f\u3002\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"ResourceOutSaveOpValidate_13", (String)"macc-cad-opplugin", (Object[])new Object[0]));
            } else {
                String[] split = routeInfo.split("@");
                if (!CadEmptyUtils.isEmpty((Long)Long.parseLong(split[0]))) {
                    entity.set("operation", (Object)BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(split[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"mpdm_workprocedure")));
                }
                entity.set("operationdesc", (Object)split[1]);
                if (!CadEmptyUtils.isEmpty((Long)Long.parseLong(split[2]))) {
                    entity.set("workstation", (Object)BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(split[2]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"mpdm_workstation")));
                }
                entity.set("pdmrouteid", (Object)Long.parseLong(split[3]));
            }
        }
        DynamicObjectCollection entryEntity = entity.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryEntity) {
            BigDecimal attaAmt = entry.getBigDecimal("attaamt");
            if ("001".equals(calcbasis)) {
                entry.set("attaamt", (Object)BigDecimal.ZERO);
            }
            if (!"002".equals(calcbasis) && !"003".equals(calcbasis)) continue;
            entry.set("attaqty", (Object)BigDecimal.ZERO);
            if (BigDecimal.ZERO.compareTo(attaAmt) != 0) continue;
            hasNull = true;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199 \u201c\u9644\u52a0\u5236\u9020\u8d39\u7528.\u91d1\u989d\u201d \u7b2c%s\u884c\u3002", (String)"ResourceOutSaveOpValidate_4", (String)"macc-cad-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
        }
        if (hasNull) {
            return;
        }
        DynamicObject resourceunit = (DynamicObject)dataEntity.getValue("resourceunit");
        String resourceunit1 = "";
        if (resourceunit != null) {
            resourceunit1 = resourceunit.getString("number");
        }
        if ("001".equals(calcbasis) && "".equals(resourceunit1)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u8ba1\u7b97\u4f9d\u636e\u9009\u62e9\u8d44\u6e90\u5de5\u65f6\u60c5\u51b5\u4e0b\uff0c\u8d44\u6e90\u5355\u4f4d\u4e3a\u5fc5\u5f55\u9879\u3002", (String)"ResourceOutSaveOpValidate_9", (String)"macc-cad-opplugin", (Object[])new Object[0]));
        }
    }

    private Boolean checkAuxptyExist(Set<Long> auxptyId, String flex) {
        DynamicObject[] auxpty;
        Boolean isNotExist = false;
        for (DynamicObject aux : auxpty = BusinessDataServiceHelper.load((Object[])auxptyId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_auxproperty"))) {
            if (flex.contains(aux.getString("flexfield"))) continue;
            isNotExist = true;
            break;
        }
        return isNotExist;
    }

    private String getRouteInfo(String srcRoute, Long routeId, String processSeq, String operationNo) {
        DynamicObject routeObject;
        if (CadEmptyUtils.isEmpty((Long)routeId) || CadEmptyUtils.isEmpty((String)processSeq)) {
            return null;
        }
        QFilter filter = new QFilter("id", "=", (Object)routeId);
        filter.and(new QFilter("processentry.parent", "=", (Object)processSeq));
        filter.and(new QFilter("processentry.operationno", "=", (Object)operationNo));
        String selectFields = ",id as sourceid";
        if ("cad_router".equals(srcRoute)) {
            selectFields = ",sourceid";
        }
        if ((routeObject = QueryServiceHelper.queryOne((String)srcRoute, (String)("id,processentry.parent parent,processentry.operationno operationno,processentry.operation operation,processentry.operationdesc operationdesc,processentry.workstation workstation" + selectFields), (QFilter[])new QFilter[]{filter})) == null) {
            return null;
        }
        long operation = routeObject.getLong("operation");
        String operationDesc = routeObject.getString("operationdesc");
        long workStation = routeObject.getLong("workstation");
        long srcrouteId = routeObject.getLong("sourceid");
        if (CadEmptyUtils.isEmpty((Long)operation) && CadEmptyUtils.isEmpty((String)operationDesc) && CadEmptyUtils.isEmpty((Long)workStation)) {
            return null;
        }
        return operation + "@" + operationDesc + "@" + workStation + "@" + srcrouteId;
    }
}

