/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.opplugin.ImportSaveOpValidate;

public class ResourceRateSaveOpValidate
extends ImportSaveOpValidate {
    @Override
    protected void validateSave(ExtendedDataEntity dataEntity, List<String> repeatKeyList) {
        long unitId;
        DynamicObject entity = dataEntity.getDataEntity();
        String dataSrc = entity.getString("datasrc");
        if (CadEmptyUtils.isEmpty((String)dataSrc) || "manual".equals(dataSrc)) {
            entity.set("pricerule_id", (Object)PriceRuleConstants.SELFRES_MANUALLY_ID);
        }
        entity.set("effectdate", (Object)DateUtils.getDayStartTime((Date)entity.getDate("effectdate")));
        DynamicObject costtype = (DynamicObject)dataEntity.getValue("costtype");
        DynamicObject resource = (DynamicObject)dataEntity.getValue("resource");
        String calcbasis = (String)dataEntity.getValue("calcbasis");
        DynamicObject resourceUnit = (DynamicObject)dataEntity.getValue("resourceunit");
        long l = unitId = resourceUnit == null ? 0L : resourceUnit.getLong("id");
        if ("0".equals(costtype.getString("type"))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u624b\u5de5\u65b0\u589e\u3002", (String)"ResourceRateSaveOpValidate_0", (String)"macc-cad-opplugin", (Object[])new Object[0]));
        }
        boolean hasNull = false;
        if (resource == null) {
            hasNull = true;
        }
        BigDecimal amount = (BigDecimal)dataEntity.getValue("amount");
        BigDecimal zeroDy = new BigDecimal(0);
        if ("001".equals(calcbasis)) {
            entity.set("amount", (Object)BigDecimal.ZERO);
            if (unitId != 8L && unitId != 9L && unitId != 10L) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u7b97\u4f9d\u636e\u4e3a\u8d44\u6e90\u5de5\u65f6\uff0c\u8d44\u6e90\u5355\u4f4d\u5fc5\u987b\u4e3a\u201c\u65f6/\u5206/\u79d2\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ResourceRateSaveOpValidate_10", (String)"macc-cad-opplugin", (Object[])new Object[0]));
            }
        }
        if ("002".equals(calcbasis) || "003".equals(calcbasis)) {
            entity.set("qty", (Object)BigDecimal.ZERO);
            if (zeroDy.setScale(amount.scale()).equals(amount)) {
                hasNull = true;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5355\u636e\u5934\u7684 \u201c\u91d1\u989d\u201d\u3002", (String)"ResourceRateSaveOpValidate_1", (String)"macc-cad-opplugin", (Object[])new Object[0]));
            }
            if (unitId != 11L) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u7b97\u4f9d\u636e\u4e3a\u7269\u6599\u6216\u6279\u6b21\uff0c\u8d44\u6e90\u5355\u4f4d\u5fc5\u987b\u4e3a\u201c\u4e2a\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ResourceRateSaveOpValidate_11", (String)"macc-cad-opplugin", (Object[])new Object[0]));
            }
        }
        DynamicObjectCollection entryEntity = entity.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryEntity) {
            BigDecimal attaAmt = entry.getBigDecimal("attaamt");
            if ("001".equals(calcbasis)) {
                entry.set("attaamt", (Object)BigDecimal.ZERO);
            }
            if (!"002".equals(calcbasis) && !"003".equals(calcbasis)) continue;
            entry.set("attaqty", (Object)BigDecimal.ZERO);
            if (BigDecimal.ZERO.compareTo(attaAmt) != 0) continue;
            hasNull = true;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199 \u201c\u9644\u52a0\u5236\u9020\u8d39\u7528.\u91d1\u989d\u201d \u7b2c%s\u884c\u3002", (String)"ResourceRateSaveOpValidate_7", (String)"macc-cad-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
        }
        if (hasNull) {
            return;
        }
        DynamicObject resourceunit = (DynamicObject)dataEntity.getValue("resourceunit");
        String resourceunit1 = "";
        if (resourceunit != null) {
            resourceunit1 = resourceunit.getString("number");
        }
        if ("001".equals(calcbasis) && "".equals(resourceunit1)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u8ba1\u7b97\u4f9d\u636e\u9009\u62e9\u8d44\u6e90\u5de5\u65f6\u60c5\u51b5\u4e0b\uff0c\u8d44\u6e90\u5355\u4f4d\u4e3a\u5fc5\u5f55\u9879\u3002", (String)"ResourceRateSaveOpValidate_6", (String)"macc-cad-opplugin", (Object[])new Object[0]));
        }
    }
}

