/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class RouteSettingRefreshOp
extends AbstractOperationServicePlugIn {
    private Map<String, Object> rs2rtIdMap = new HashMap<String, Object>();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("status");
        fieldKeys.add("enable");
        fieldKeys.add("router");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity routeSetting : dataEntities = this.dataEntities) {
                    DynamicObject router;
                    String processtype;
                    DynamicObject rs = routeSetting.getDataEntity();
                    String status = rs.getString("status");
                    String enable = rs.getString("enable");
                    if (!"C".equals(status) || "0".equals(enable)) {
                        this.addErrorMessage(routeSetting, ResManager.loadKDString((String)"\u672a\u5ba1\u6838\u6216\u8005\u7981\u7528\u7684\u5de5\u827a\u8def\u7ebf\u8bbe\u7f6e\u4e0d\u80fd\u5237\u65b0BOM\u7248\u672c\u3002", (String)"RouteSettingRefreshOp_0", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    }
                    if (!"A".equals(processtype = (router = rs.getDynamicObject("router")).getString("processtype"))) {
                        this.addErrorMessage(routeSetting, ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u7684\u5de5\u827a\u7c7b\u578b\u4e0d\u4e3a\u7269\u6599\uff0c\u4e0d\u80fd\u5237\u65b0BOM\u7248\u672c\u3002", (String)"RouteSettingRefreshOp_1", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    boolean isMulti = RouteSettingRefreshOp.this.isexistMultiRoute(rs, router);
                    if (isMulti) continue;
                    this.addErrorMessage(routeSetting, ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u65b0\u7684\u5de5\u827a\u8def\u7ebf\uff0c\u4e0d\u80fd\u5237\u65b0BOM\u7248\u672c\u3002", (String)"RouteSettingRefreshOp_2", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    private boolean isexistMultiRoute(DynamicObject routeSetting, DynamicObject router) {
        DynamicObject material = router.getDynamicObject("material");
        QFilter typeFilter = new QFilter("processtype", "=", (Object)Character.valueOf('A'));
        QFilter materialFilter = new QFilter("material", "=", material.getPkValue());
        QFilter statusFilter = new QFilter("status", "=", (Object)Character.valueOf('C'));
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        List list = QueryServiceHelper.queryPrimaryKeys((String)((Object)((Object)this)).getClass().getName(), (String)"cad_router", (QFilter[])new QFilter[]{typeFilter, materialFilter, statusFilter, enableFilter}, (String)"audittime desc", (int)9999);
        if (list != null && list.size() > 1 && list.get(0) != router.getPkValue()) {
            this.rs2rtIdMap.put(routeSetting.getString("id"), list.get(0));
            return true;
        }
        return false;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] routerSettings;
        for (DynamicObject routerSetting : routerSettings = e.getDataEntities()) {
            String rsKey = routerSetting.getString("id");
            if (!this.rs2rtIdMap.containsKey(rsKey)) continue;
            routerSetting.set("router", this.rs2rtIdMap.get(rsKey));
        }
        SaveServiceHelper.update((DynamicObject[])routerSettings);
    }
}

