/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.basedata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CenterManuOrgUniqueValidator
extends AbstractValidator {
    public void validate() {
        String operateKey = this.getOperateKey();
        String tip = "save".equals(operateKey) ? ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"CenterManuOrgUniqueValidator_0", (String)"macc-cad-opplugin", (Object[])new Object[0]) : ("audit".equals(operateKey) ? ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\u3002", (String)"CenterManuOrgUniqueValidator_1", (String)"macc-cad-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002", (String)"CenterManuOrgUniqueValidator_2", (String)"macc-cad-opplugin", (Object[])new Object[0]));
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if ("audit".equals(operateKey) || "submit".equals(operateKey) && dataEntities.length > 1) {
            HashMap<String, Set<Long>> centerMap = new HashMap<String, Set<Long>>();
            ExtendedDataEntity[] extendedDataEntityArray = dataEntities;
            int n = extendedDataEntityArray.length;
            for (int i = 0; i < n; ++i) {
                ExtendedDataEntity dataEntity = extendedDataEntityArray[i];
                if ("submit".equals(operateKey) && dataEntity.getDataEntity().getString("billstatus").equals("A")) {
                    this.checkAudit(tip, centerMap, dataEntity);
                }
                if (!"audit".equals(operateKey) || !dataEntity.getDataEntity().getString("billstatus").equals("B")) continue;
                this.checkAudit(tip, centerMap, dataEntity);
            }
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.checkOrgAndManuAndCenterUnique(dataEntity, tip);
        }
    }

    private void checkAudit(String tips, Map<String, Set<Long>> centerMap, ExtendedDataEntity dataEntity) {
        HashSet<Long> centerIds = new HashSet<Long>(16);
        String billNo = dataEntity.getDataEntity().getString("billno");
        DynamicObjectCollection dynamicObjects = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : dynamicObjects) {
            centerIds.add(dynamicObject.getLong("costcenter.id"));
        }
        if (!centerMap.isEmpty()) {
            for (Map.Entry<String, Set<Long>> entry : centerMap.entrySet()) {
                boolean disjoint = Collections.disjoint((Collection)entry.getValue(), centerIds);
                if (disjoint) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s,\u5f53\u524d\u5355\u636e\u4e2d\u7684\u6210\u672c\u4e2d\u5fc3\u5728%2$s\u4e2d\u5df2\u5b58\u5728\u3002", (String)"CenterManuOrgUniqueValidator_8", (String)"macc-cad-opplugin", (Object[])new Object[0]), tips, entry.getKey()));
            }
        }
        centerMap.put(billNo, centerIds);
    }

    private void checkOrgAndManuAndCenterUnique(ExtendedDataEntity dataEntity, String tip) {
        DynamicObject entity;
        DynamicObjectCollection entry;
        Long billPkId = (Long)dataEntity.getBillPkId();
        Date nowTime = new Date();
        Long org = dataEntity.getDataEntity().getLong("org.id");
        Long manuorg = dataEntity.getDataEntity().getLong("manuorg.id");
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        QFilter filter = new QFilter("org", "=", (Object)org);
        filter.and("manuorg", "=", (Object)manuorg);
        QFilter expFilter = new QFilter("expdate", ">=", (Object)nowTime);
        expFilter.or("expdate", "is null", null);
        qfList.add(filter);
        qfList.add(expFilter);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_centermanuorg", (String)"id", (QFilter[])qfList.toArray(qfList.toArray(new QFilter[0])));
        if (!dynamicObjects.isEmpty() && billPkId.longValue() != ((DynamicObject)dynamicObjects.get(0)).getLong("id")) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5f53\u524d\u751f\u4ea7\u7ec4\u7ec7\u5df2\u7ecf\u8bbe\u7f6e\u4e86\u6210\u672c\u4e2d\u5fc3\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u5bf9\u5e94\u5173\u7cfb\u3002", (String)"CenterManuOrgUniqueValidator_9", (String)"macc-cad-opplugin", (Object[])new Object[0]), tip));
        }
        if ((entry = (entity = dataEntity.getDataEntity()).getDynamicObjectCollection("entryentity")).isEmpty()) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CenterManuOrgUniqueValidator_10", (String)"macc-cad-opplugin", (Object[])new Object[0]), tip));
        } else {
            HashSet<Long> centerIds = new HashSet<Long>(16);
            for (DynamicObject dynamicObject : entry) {
                centerIds.add(dynamicObject.getLong("costcenter.id"));
            }
            ArrayList<QFilter> listFilter = new ArrayList<QFilter>();
            QFilter centerFilter = new QFilter("entryentity.costcenter", "in", centerIds);
            QFilter timeFilter = new QFilter("expdate", ">=", (Object)nowTime);
            timeFilter.or("expdate", "is null", null);
            listFilter.add(centerFilter);
            listFilter.add(timeFilter);
            DynamicObjectCollection dynamics = QueryServiceHelper.query((String)"cad_centermanuorg", (String)"id,entryentity.costcenter.number number,entryentity.costcenter.name name,billno", (QFilter[])listFilter.toArray(new QFilter[0]));
            if (!dynamics.isEmpty()) {
                for (DynamicObject dynamic : dynamics) {
                    if (billPkId.longValue() == dynamic.getLong("id")) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s/%3$s\u201d\u5728\u201c%4$s\u201d\u4e2d\u5df2\u7ecf\u5b58\u5728\u3002", (String)"CenterManuOrgUniqueValidator_11", (String)"macc-cad-opplugin", (Object[])new Object[0]), tip, dynamic.getString("number"), dynamic.getString("name"), dynamic.getString("billno")));
                }
            }
        }
    }
}

