/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.basedata;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.ConfigLogDto;
import kd.macc.cad.opplugin.basedata.CostCollectConfigSaveOpValidate;
import org.apache.commons.lang3.StringUtils;

public class CostCollectConfigSaveOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(EntityMetadataCache.getDataEntityType((String)"cad_costcollectconfig").getFields().keySet());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new CostCollectConfigSaveOpValidate());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            long id = dataEntity.getLong("id");
            boolean exists = QueryServiceHelper.exists((String)"cad_costcollectconfig", (Object)id);
            if (!exists) continue;
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cad_costcollectconfig");
            this.addConfigChangeLog(dynamicObject, dataEntity);
        }
    }

    private void addConfigChangeLog(DynamicObject oldDynamicObj, DynamicObject newDynamicObj) {
        DynamicObject configLog = BusinessDataServiceHelper.newDynamicObject((String)"cad_configbilllog");
        String billNo = newDynamicObj.getString("number");
        String costBill = newDynamicObj.getString("costbill.id");
        String sourceBill = newDynamicObj.getString("sourcebill.id");
        configLog.set("billno", (Object)billNo);
        configLog.set("org", (Object)newDynamicObj.getLong("org.id"));
        configLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        configLog.set("createtime", (Object)new Date());
        configLog.set("costbill", (Object)costBill);
        configLog.set("sourcebill", (Object)sourceBill);
        configLog.set("appnum", (Object)newDynamicObj.getString("appnum"));
        String oldDataRange = oldDynamicObj.getString("filter_tag");
        String newDataRange = newDynamicObj.getString("filter_tag");
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)sourceBill);
        FilterCondition before = (FilterCondition)SerializationUtils.fromJsonString((String)oldDataRange, FilterCondition.class);
        FilterCondition after = (FilterCondition)SerializationUtils.fromJsonString((String)newDataRange, FilterCondition.class);
        FilterBuilder beforeBuilder = new FilterBuilder(mainType, before);
        beforeBuilder.buildFilter();
        FilterBuilder filterBuilder = new FilterBuilder(mainType, after);
        filterBuilder.buildFilter();
        if (!beforeBuilder.getQFilters().toString().equals(filterBuilder.getQFilters().toString())) {
            configLog.set("beforefilter_tag", (Object)oldDataRange);
            configLog.set("afterfilter_tag", (Object)newDataRange);
        }
        DynamicObjectCollection oldFieldObj = oldDynamicObj.getDynamicObjectCollection("fieldmapentity");
        DynamicObjectCollection newFieldObj = newDynamicObj.getDynamicObjectCollection("fieldmapentity");
        this.addFieldMapLog(configLog, oldFieldObj, newFieldObj);
        DynamicObjectCollection oldCostRule = oldDynamicObj.getDynamicObjectCollection("costruleinfoentity");
        DynamicObjectCollection newCostRule = newDynamicObj.getDynamicObjectCollection("costruleinfoentity");
        this.addRuleInfoLog(configLog, oldCostRule, newCostRule);
        DynamicObjectCollection mapEntry = configLog.getDynamicObjectCollection("mapentry");
        DynamicObjectCollection ruleEntry = configLog.getDynamicObjectCollection("ruleentry");
        if (StringUtils.isNotBlank((CharSequence)configLog.getString("beforefilter_tag")) || !mapEntry.isEmpty() || !ruleEntry.isEmpty()) {
            QFilter filter = new QFilter("billno", "=", (Object)billNo);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_configbilllog", (String)"count", (QFilter[])new QFilter[]{filter}, (String)"count desc");
            int count = dynamicObjects.isEmpty() ? 1 : ((DynamicObject)dynamicObjects.get(0)).getInt("count") + 1;
            configLog.set("count", (Object)count);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{configLog});
        }
    }

    private void addFieldMapLog(DynamicObject configLog, DynamicObjectCollection oldFieldObj, DynamicObjectCollection newFieldObj) {
        ConfigLogDto configLogDto;
        DynamicObjectCollection mapEntry = configLog.getDynamicObjectCollection("mapentry");
        Map<String, ConfigLogDto> oldFieldMap = this.getGroupCostFieldMap(oldFieldObj);
        Map<String, ConfigLogDto> newFieldMap = this.getGroupCostFieldMap(newFieldObj);
        ArrayList<String> delListKey = new ArrayList<String>(10);
        for (Map.Entry<String, ConfigLogDto> entry : oldFieldMap.entrySet()) {
            String key = entry.getKey();
            ConfigLogDto oldVal = entry.getValue();
            ConfigLogDto newVal = newFieldMap.get(key);
            if (newVal == null) continue;
            if (!oldVal.toString().equals(newVal.toString())) {
                String oldSel = oldVal.getSelectValue();
                String newSel = newVal.getSelectValue();
                DynamicObject dynamicObject = mapEntry.addNew();
                dynamicObject.set("changetype", (Object)"1");
                dynamicObject.set("costfield", (Object)entry.getKey());
                if (oldSel.equals(newSel)) {
                    dynamicObject.set("valuetype", (Object)this.getSelectValue(oldSel));
                } else {
                    dynamicObject.set("valuetype", (Object)(this.getSelectValue(oldSel) + "-->" + this.getSelectValue(newSel)));
                }
                dynamicObject.set("changedvalue", (Object)(this.getSourceValue(oldSel, oldVal) + "-->" + this.getSourceValue(newSel, newVal)));
            }
            delListKey.add(entry.getKey());
        }
        for (String string : delListKey) {
            oldFieldMap.remove(string);
            newFieldMap.remove(string);
        }
        for (Map.Entry<String, Object> entry : newFieldMap.entrySet()) {
            configLogDto = oldFieldMap.get(entry.getKey());
            ConfigLogDto value = (ConfigLogDto)entry.getValue();
            if (configLogDto != null) continue;
            DynamicObject dynamicObject = mapEntry.addNew();
            dynamicObject.set("changetype", (Object)"0");
            dynamicObject.set("costfield", (Object)entry.getKey());
            dynamicObject.set("valuetype", (Object)this.getSelectValue(value.getSelectValue()));
            dynamicObject.set("changedvalue", (Object)this.getSourceValue(value.getSelectValue(), value));
        }
        for (Map.Entry<String, Object> entry : oldFieldMap.entrySet()) {
            configLogDto = newFieldMap.get(entry.getKey());
            if (configLogDto != null) continue;
            DynamicObject dynamicObject = mapEntry.addNew();
            dynamicObject.set("changetype", (Object)"2");
            dynamicObject.set("costfield", (Object)entry.getKey());
        }
    }

    private String getSelectValue(String selectType) {
        if ("0".equals(selectType)) {
            return ResManager.loadKDString((String)"\u6e90\u5355\u5b57\u6bb5", (String)"CostCollectConfigSaveOpPlugin_0", (String)"macc-cad-opplugin", (Object[])new Object[0]);
        }
        if ("1".equals(selectType)) {
            return ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f", (String)"CostCollectConfigSaveOpPlugin_1", (String)"macc-cad-opplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u56fa\u5b9a\u503c", (String)"CostCollectConfigSaveOpPlugin_2", (String)"macc-cad-opplugin", (Object[])new Object[0]);
    }

    private String getSourceValue(String selType, ConfigLogDto configLogDto) {
        String selectValue = selType.equals("0") ? configLogDto.getSourceFieldName() + "(" + configLogDto.getSourceField() + ")" : (selType.equals("1") ? configLogDto.getFormulaDesc() : configLogDto.getSourceData());
        return selectValue;
    }

    private void addRuleInfoLog(DynamicObject configLog, DynamicObjectCollection oldCostRule, DynamicObjectCollection newCostRule) {
        DynamicObjectCollection ruleEntry = configLog.getDynamicObjectCollection("ruleentry");
        Map<String, String> oldRuleMap = this.getGroupCostRuleMap(oldCostRule);
        Map<String, String> newRuleMap = this.getGroupCostRuleMap(newCostRule);
        for (Map.Entry<String, String> ruleEntryMap : oldRuleMap.entrySet()) {
            String newVal;
            String oldVal = ruleEntryMap.getValue();
            if (oldVal.equals(newVal = newRuleMap.get(ruleEntryMap.getKey()))) continue;
            DynamicObject dynamicObject = ruleEntry.addNew();
            dynamicObject.set("costbojectfield", (Object)ruleEntryMap.getKey());
            dynamicObject.set("objchangefield", (Object)(oldVal + "-->" + newVal));
        }
    }

    private Map<String, ConfigLogDto> getGroupCostFieldMap(DynamicObjectCollection dynamicObjects) {
        HashMap<String, ConfigLogDto> map = new HashMap<String, ConfigLogDto>(15);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String key = dynamicObject.getString("costfieldname") + "(" + dynamicObject.getString("costfield") + ")";
            ConfigLogDto configLogDto = new ConfigLogDto();
            configLogDto.setSelectValue(dynamicObject.getString("selectvalue"));
            configLogDto.setSourceFieldName(dynamicObject.getString("sourcefieldname"));
            configLogDto.setSourceField(dynamicObject.getString("sourcefield"));
            configLogDto.setFormulaDesc(dynamicObject.getString("formuladesc"));
            if (dynamicObject.getDynamicObject("sourcedata") != null) {
                long id = dynamicObject.getDynamicObject("sourcedata").getLong("id");
                String entity = dynamicObject.getDynamicObject("sourcedata").getDataEntityType().getName();
                QFilter filter = new QFilter("id", "=", (Object)id);
                DynamicObject object = QueryServiceHelper.queryOne((String)entity, (String)"name", (QFilter[])new QFilter[]{filter});
                if (object != null) {
                    configLogDto.setSourceData(object.getString("name"));
                }
            }
            map.put(key, configLogDto);
        }
        return map;
    }

    private Map<String, String> getGroupCostRuleMap(DynamicObjectCollection dynamicObjects) {
        HashMap<String, String> map = new HashMap<String, String>(20);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String key = dynamicObject.getString("costobjname") + "(" + dynamicObject.getString("costobjfield") + ")";
            String value = dynamicObject.getString("srcbillname") + "(" + dynamicObject.getString("srcbillfield") + ")";
            map.put(key, value);
        }
        return map;
    }
}

