/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.basedata;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class CostCollectConfigSaveOpValidate
extends AbstractValidator {
    private static final List<String> unMustInputCostObjectRule = Lists.newArrayList((Object[])new String[]{"cad_mfgfeebill", "sca_diycostdriver", "sca_workqtycollec", "cad_planfeebill", "cad_plancostdriver"});

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            this.checkFieldMap(dataEntity);
            this.checkCostRuleInfo(dataEntity);
            this.checkRepeatData(dataEntity);
        }
    }

    private void checkRepeatData(ExtendedDataEntity dataEntity) {
        String resNumber;
        DynamicObject result;
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        String appNum = dynamicObject.getString("appnum");
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        String costBill = dynamicObject.getString("costbill.id");
        if (dynamicObject.getLong("org.id") == rootOrgId) {
            return;
        }
        if (!("eca".equals(appNum) || "cad_planfeebill".equals(costBill) || "cad_plancostdriver".equals(costBill) || "cad_planwork".equals(costBill))) {
            return;
        }
        if ("cad_mfgfeebill".equals(costBill)) {
            return;
        }
        boolean isDiyCostDriver = "sca_diycostdriver".equals(costBill) || "cad_plancostdriver".equals(costBill);
        boolean isWorkQty = "sca_workqtycollec".equals(costBill) || "cad_planwork".equals(costBill);
        String number = dynamicObject.getString("number");
        QFilter filter = new QFilter("appnum", "=", (Object)appNum);
        filter.and("org", "=", (Object)dynamicObject.getLong("org.id"));
        filter.and("sourcebill", "=", (Object)dynamicObject.getString("sourcebill.id"));
        filter.and("costbill", "=", (Object)costBill);
        filter.and("costcalcdimension", "=", (Object)dynamicObject.getLong("costcalcdimension.id"));
        if (isDiyCostDriver) {
            DynamicObject costDriver = dynamicObject.getDynamicObject("costdriver");
            long costDriverId = costDriver == null ? 0L : costDriver.getLong("id");
            filter.and("costdriver", "=", (Object)costDriverId);
        }
        if (isWorkQty) {
            DynamicObject workActivity = dynamicObject.getDynamicObject("workactivity");
            long workActivityId = workActivity == null ? 0L : workActivity.getLong("id");
            filter.and("workactivity", "=", (Object)workActivityId);
        }
        boolean isCostAccount = false;
        if ("cad_planfeebill".equals(costBill) || isDiyCostDriver || "eca".equals(appNum) && "aca_matalloc".equals(costBill)) {
            filter.and("costaccount", "=", (Object)dynamicObject.getLong("costaccount.id"));
            isCostAccount = true;
        }
        if ((result = QueryServiceHelper.queryOne((String)"cad_costcollectconfig", (String)"number", (QFilter[])new QFilter[]{filter})) != null && !number.equals(resNumber = result.getString("number"))) {
            String errorMsg = isCostAccount ? String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u914d\u7f6e\u5355\u5df2\u5b58\u5728\u5f53\u524d\u201c\u6838\u7b97\u7ec4\u7ec7+\u6210\u672c\u8d26\u7c3f+\u6e90\u5355+\u6210\u672c\u5355\u636e+\u6210\u672c\u6838\u7b97\u7ef4\u5ea6\u201d\u3002", (String)"CostCollectConfigSaveOpValidate_12", (String)"macc-cad-opplugin", (Object[])new Object[0]), resNumber) : String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u914d\u7f6e\u5355\u5df2\u5b58\u5728\u5f53\u524d\u201c\u6838\u7b97\u7ec4\u7ec7+\u6e90\u5355+\u6210\u672c\u5355\u636e+\u6210\u672c\u6838\u7b97\u7ef4\u5ea6\u201d\u3002", (String)"CostCollectConfigSaveOpValidate_13", (String)"macc-cad-opplugin", (Object[])new Object[0]), resNumber);
            if (isDiyCostDriver) {
                errorMsg = String.format(ResManager.loadKDString((String)"%s+\u6210\u672c\u52a8\u56e0", (String)"CostCollectConfigSaveOpValidate_14", (String)"macc-cad-opplugin", (Object[])new Object[0]), errorMsg);
            }
            if (isWorkQty) {
                errorMsg = String.format(ResManager.loadKDString((String)"%s+\u4f5c\u4e1a\u6d3b\u52a8", (String)"CostCollectConfigSaveOpValidate_15", (String)"macc-cad-opplugin", (Object[])new Object[0]), errorMsg);
            }
            errorMsg = String.format(ResManager.loadKDString((String)"%s\u7684\u53ef\u7528\u7ec4\u5408\uff0c\u8bf7\u8fdb\u884c\u4fee\u6539\u3002", (String)"CostCollectConfigSaveOpValidate_16", (String)"macc-cad-opplugin", (Object[])new Object[0]), errorMsg);
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }

    private void checkFieldMap(ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        String number = dynamicObject.getString("number");
        DynamicObjectCollection fieldMap = dynamicObject.getDynamicObjectCollection("fieldmapentity");
        if (fieldMap.isEmpty()) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u3010%s\u3011\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostCollectConfigSaveOpValidate_1", (String)"macc-cad-opplugin", (Object[])new Object[0]), number));
        }
        HashSet<String> enTrys = new HashSet<String>(5);
        for (DynamicObject dynObj : fieldMap) {
            String[] split;
            String seq = dynObj.getString("seq");
            String costFieldName = dynObj.getString("costfieldname");
            String sourceFieldName = dynObj.getString("sourcefieldname");
            String sourceField = dynObj.getString("sourcefield");
            String selectValue = dynObj.getString("selectvalue");
            String sourceData = dynObj.getString("sourcedata");
            String calcFormula = dynObj.getString("formuladesc");
            if (StringUtils.isNotBlank((CharSequence)sourceField) && (split = sourceField.split("\\.")).length > 1) {
                enTrys.add(split[0]);
            }
            if (StringUtils.isBlank((CharSequence)costFieldName) || StringUtils.isBlank((CharSequence)sourceFieldName) && "0".equals(selectValue)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u5b57\u6bb5\u6620\u5c04\u4e2d\u7b2c%2$s\u884c\u6210\u672c\u5355\u636e\u5b57\u6bb5\u540d\u79f0\u6216\u6e90\u5355\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CostCollectConfigSaveOpValidate_7", (String)"macc-cad-opplugin", (Object[])new Object[0]), number, seq));
            }
            if (StringUtils.isBlank((CharSequence)calcFormula) && "1".equals(selectValue)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u5b57\u6bb5\u6620\u5c04\u4e2d\u7b2c%2$s\u884c\u8ba1\u7b97\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CostCollectConfigSaveOpValidate_8", (String)"macc-cad-opplugin", (Object[])new Object[0]), number, seq));
            }
            if (!StringUtils.isBlank((CharSequence)sourceData) || !"2".equals(selectValue)) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u5b57\u6bb5\u6620\u5c04\u4e2d\u7b2c%2$s\u884c\u6765\u6e90\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CostCollectConfigSaveOpValidate_9", (String)"macc-cad-opplugin", (Object[])new Object[0]), number, seq));
        }
        if (enTrys.size() > 1) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5b57\u6bb5\u6620\u5c04\u4e2d\u6e90\u5355\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u9009\u591a\u4e2a\u5206\u5f55\u7684\u6765\u6e90\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CostCollectConfigSaveOpValidate_5", (String)"macc-cad-opplugin", (Object[])new Object[0]), number));
        }
    }

    private void checkCostRuleInfo(ExtendedDataEntity dataEntity) {
        boolean costObjectRuleMustInput;
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        String number = dynamicObject.getString("number");
        DynamicObjectCollection ruleInfo = dynamicObject.getDynamicObjectCollection("costruleinfoentity");
        String appNum = dynamicObject.getString("appnum");
        String costBill = dynamicObject.getString("costbill.id");
        if ("eca".equals(appNum) && !costBill.equals("cad_mfgfeebill")) {
            return;
        }
        boolean bl = costObjectRuleMustInput = !unMustInputCostObjectRule.contains(costBill);
        if (costBill.equals("cad_mfgfeebill") && !ruleInfo.isEmpty()) {
            for (DynamicObject dynObj : ruleInfo) {
                String srcBillName = dynObj.getString("srcbillname");
                if (!StringUtils.isNotBlank((CharSequence)srcBillName)) continue;
                costObjectRuleMustInput = true;
                break;
            }
        }
        String sourceBill = dynamicObject.getString("sourcebill.id");
        if ("aca_matusecollect".equals(costBill) && "cal_costadjust_subentity".equals(sourceBill)) {
            costObjectRuleMustInput = false;
        }
        if (!ruleInfo.isEmpty()) {
            for (DynamicObject dynObj : ruleInfo) {
                String seq = dynObj.getString("seq");
                String costObjName = dynObj.getString("costobjname");
                String srcBillName = dynObj.getString("srcbillname");
                String costObjField = dynObj.getString("costobjfield");
                if ("bomversion".equals(costObjField) || "auxpty".equals(costObjField)) {
                    return;
                }
                if ("sfc_reportresource_adjust".equals(sourceBill) && "material".equals(costObjField)) {
                    return;
                }
                if (!StringUtils.isBlank((CharSequence)costObjName) && !StringUtils.isBlank((CharSequence)srcBillName) || !costObjectRuleMustInput) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u643a\u5e26\u4fe1\u606f\u7b2c%2$s\u884c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5b57\u6bb5\u6216\u6e90\u5355\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CostCollectConfigSaveOpValidate_10", (String)"macc-cad-opplugin", (Object[])new Object[0]), number, seq));
            }
        }
    }
}

