/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.basedata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.utils.DateUtils;

public class MatCostAuditOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("costtype");
        fieldKeys.add("status");
        fieldKeys.add("enable");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                HashSet<Long> ids = new HashSet<Long>(16);
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject matInfo = dataEntity.getDataEntity();
                    String type = matInfo.getString("costtype.type");
                    if ("1".equals(type) || !"B".equals(matInfo.getString("status")) || !"1".equals(matInfo.getString("enable"))) continue;
                    ids.add(matInfo.getLong("id"));
                }
                if (ids.size() == 0) {
                    return;
                }
                DynamicObject[] materialCost = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_matcostinfo"));
                MatCostAuditOpPlugin.this.updateCalcEffectiveResult(materialCost);
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] materialCost;
        DynamicObject[] datas = e.getDataEntities();
        Long auditorId = Long.valueOf(RequestContext.get().getUserId());
        Date dTime = TimeServiceHelper.now();
        HashSet<Long> ids = new HashSet<Long>();
        for (DynamicObject data : datas) {
            if (!"C".equals(data.getString("status"))) continue;
            ids.add(data.getLong("id"));
        }
        if (ids.size() == 0) {
            return;
        }
        for (DynamicObject mat : materialCost = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_matcostinfo"))) {
            mat.set("auditor", (Object)auditorId);
            mat.set("audittime", (Object)dTime);
            mat.set("effectdate", (Object)DateUtils.getDefaultEffectDate());
            mat.set("expdate", (Object)DateUtils.getDeFaultExpDate());
        }
        SaveServiceHelper.save((DynamicObject[])materialCost);
    }

    private void updateCalcEffectiveResult(DynamicObject[] matCost) {
        ArrayList<DynamicObject> calcResult = new ArrayList<DynamicObject>(16);
        for (DynamicObject mat : matCost) {
            DynamicObject calcEffectiveResult = BusinessDataServiceHelper.newDynamicObject((String)"cad_calceffectiveresult");
            calcEffectiveResult.set("id", mat.getPkValue());
            calcEffectiveResult.set("effectdate", (Object)DateUtils.getDefaultEffectDate());
            calcEffectiveResult.set("expdate", (Object)DateUtils.getDeFaultExpDate());
            calcEffectiveResult.set("costtype", (Object)mat.getLong("costtype.id"));
            calcEffectiveResult.set("material", (Object)mat.getLong("material.masterid"));
            calcEffectiveResult.set("auxproperty", (Object)mat.getLong("auxpty.id"));
            calcEffectiveResult.set("matvers", (Object)mat.getLong("matversion.id"));
            calcEffectiveResult.set("bom", (Object)mat.getLong("bom.id"));
            calcEffectiveResult.set("processroute", (Object)mat.getLong("processroute.id"));
            calcEffectiveResult.set("ismaindata", (Object)1);
            calcEffectiveResult.set("isleaf", (Object)"1");
            calcEffectiveResult.set("processroute", (Object)mat.getLong("processroute.id"));
            DynamicObjectCollection calEntry = calcEffectiveResult.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection matEntry = mat.getDynamicObjectCollection("entryentity");
            for (DynamicObject matEn : matEntry) {
                DynamicObject entry = calEntry.addNew();
                entry.set("element", (Object)matEn.getLong("element.id"));
                entry.set("subelement", (Object)matEn.getLong("subelement.id"));
                entry.set("qty", (Object)BigDecimal.ONE);
                entry.set("price", (Object)matEn.getBigDecimal("standardcost"));
                entry.set("stdprice", (Object)matEn.getBigDecimal("standardcost"));
                entry.set("datatype", (Object)"2");
            }
            calcResult.add(calcEffectiveResult);
        }
        if (calcResult.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])calcResult.toArray(new DynamicObject[0]));
        }
    }
}

