/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.basedata;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.Keycol;
import kd.macc.cad.common.helper.CalcDimenHelper;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.opplugin.CommonOp;
import kd.macc.cad.opplugin.basedata.MatCostSaveOpValidate;

public class MatCostSaveOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("currency");
        fieldKeys.add("element");
        fieldKeys.add("auxpty");
        fieldKeys.add("source");
        fieldKeys.add("costtype");
        fieldKeys.add("matversion");
        fieldKeys.add("material");
        fieldKeys.add("configuredcode");
        fieldKeys.add("tracknumber");
        fieldKeys.add("project");
        fieldKeys.add("lot");
        fieldKeys.add("keycol");
        fieldKeys.add("keycolid");
        fieldKeys.addAll(CalcKeyHelper.getExtColList());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new MatCostSaveOpValidate());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        List extColList = CalcKeyHelper.getExtColList();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"cad_matcostinfo");
        extColList.removeIf(extCol -> mainEntityType.findProperty(extCol) == null);
        if ("save".equals(e.getOperationKey())) {
            for (DynamicObject data : dataEntities) {
                if (!CostTypeHelper.isUseMatVersion((Long)data.getLong("costtype.id"))) {
                    data.set("matversion", null);
                }
                data.set("auxpty", (Object)CalcDimenHelper.getAffectAuxpty((Object)data.get("material"), (Object)data.get("auxpty")));
                HashMap<String, Object> keycolMap = new HashMap<String, Object>(16);
                keycolMap.put("material", data.get("material.masterid"));
                keycolMap.put("auxproperty", data.get("auxpty"));
                keycolMap.put("configuredcode", data.get("configuredcode.id"));
                keycolMap.put("tracknumber", data.get("tracknumber.id"));
                keycolMap.put("project", data.get("project.id"));
                keycolMap.put("lot", data.get("lot"));
                for (String key : extColList) {
                    keycolMap.put(key, CalcKeyHelper.getAttrValue((DynamicObject)data, (String)key));
                }
                Keycol calcKey = CalcKeyHelper.getCalcKey(keycolMap, (List)extColList, (boolean)true);
                data.set("keycol", (Object)calcKey.getKeycol());
                data.set("keycolid", (Object)calcKey.getId());
                data.set("keycolid_id", (Object)calcKey.getId());
            }
            SaveServiceHelper.update((DynamicObject[])dataEntities);
        }
        MatCostSaveOpPlugin.updateData(e, "cad_matcostinfo", true, true);
    }

    private static void updateData(EndOperationTransactionArgs e, String entityName, Boolean isHaveCurrency, Boolean isEntity) {
        DynamicObject[] updateData;
        DynamicObject[] datas = e.getDataEntities();
        HashSet<Object> ids = new HashSet<Object>();
        HashSet<Long> subElementId = new HashSet<Long>();
        for (DynamicObject data : datas) {
            if (isHaveCurrency.booleanValue() && data.get("currency") == null) {
                ids.add(data.getPkValue());
            }
            if (isEntity.booleanValue()) {
                DynamicObjectCollection entity = data.getDynamicObjectCollection("entryentity");
                for (DynamicObject en : entity) {
                    if (en.get("element") != null) continue;
                    ids.add(data.getPkValue());
                    subElementId.add(en.getLong("subelement.id"));
                }
                continue;
            }
            if (data.get("element") != null) continue;
            ids.add(data.getPkValue());
            subElementId.add(data.getLong("subelement.id"));
        }
        if (ids.size() == 0) {
            return;
        }
        Map<Long, Long> mapElement = CommonOp.getElementRelation(subElementId.toArray(new Long[0]));
        for (DynamicObject data : updateData = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName))) {
            if (isHaveCurrency.booleanValue() && data.get("currency") == null) {
                DynamicObject costType = (DynamicObject)data.get("costtype");
                data.set("currency", (Object)costType.getLong("currency.id"));
            }
            if (isEntity.booleanValue()) {
                DynamicObjectCollection entity = data.getDynamicObjectCollection("entryentity");
                for (DynamicObject en : entity) {
                    if (en.get("element") != null) continue;
                    en.set("element", (Object)mapElement.get(en.get("subelement.id")));
                }
                continue;
            }
            if (data.get("element") != null) continue;
            DynamicObject subElement = (DynamicObject)data.get("subelement");
            data.set("element", (Object)mapElement.get(subElement.getLong("id")));
        }
        SaveServiceHelper.update((DynamicObject[])updateData);
    }
}

