/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.basedata;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.opplugin.ImportSaveOpValidate;

public class MatCostSaveOpValidate
extends ImportSaveOpValidate {
    @Override
    protected void validateSave(ExtendedDataEntity dataEntity, List<String> repeatKeyList) {
        DynamicObject material = (DynamicObject)dataEntity.getValue("material");
        HashSet<Long> auxptyId = new HashSet<Long>();
        boolean isAuxprop = false;
        boolean isUseauxpty = material.getBoolean("isuseauxpty");
        if (isUseauxpty) {
            DynamicObjectCollection isaffectprice = material.getDynamicObjectCollection("auxptyentry");
            for (DynamicObject isPrice : isaffectprice) {
                if (!isPrice.getBoolean("isaffectprice")) continue;
                auxptyId.add(isPrice.getLong("auxpty.id"));
                isAuxprop = true;
            }
            DynamicObject auxpty = (DynamicObject)dataEntity.getValue("auxpty");
            if (isAuxprop) {
                if (auxpty == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027\u672a\u586b\u5199\u3002", (String)"MatCostSaveOpValidate_0", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                } else {
                    Boolean notAuxpty = this.checkAuxptyExist(auxptyId, (String)auxpty.get(1));
                    if (notAuxpty.booleanValue()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027\u672a\u586b\u5199\u3002", (String)"MatCostSaveOpValidate_0", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    }
                }
            }
        }
        HashSet<Long> element = new HashSet<Long>();
        DynamicObjectCollection entry = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
        int i = 1;
        for (DynamicObject en : entry) {
            if (element.contains(en.getLong("subelement.id"))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s", (String)"MatCostSaveOpValidate_1", (String)"macc-cad-opplugin", (Object[])new Object[0]), i));
            } else {
                element.add(en.getLong("subelement.id"));
            }
            if (en.getBigDecimal("standardcost").compareTo(BigDecimal.ZERO) < 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s", (String)"MatCostSaveOpValidate_1", (String)"macc-cad-opplugin", (Object[])new Object[0]), i));
            }
            ++i;
        }
        String source = (String)dataEntity.getValue("source");
        if (CadEmptyUtils.isEmpty((String)source)) {
            DynamicObject costType = (DynamicObject)dataEntity.getValue("costtype");
            if (CadEmptyUtils.isEmpty((DynamicObject)costType)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u8bf7\u586b\u5199\u6210\u672c\u7c7b\u578b\u3002", (String)"MatCostSaveOpValidate_2", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                return;
            }
            QFilter filter = new QFilter("costtype", "=", (Object)costType.getLong("id"));
            filter.and(new QFilter("source", "=", (Object)"1"));
            DynamicObject[] selectMatcostinfo = BusinessDataServiceHelper.load((String)"cad_matcostinfo", (String)"material", (QFilter[])new QFilter[]{filter});
            if (selectMatcostinfo.length > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u7269\u6599\u6210\u672c\u4fe1\u606f\u5728\u8fdb\u884c\u5377\u7b97\u66f4\u65b0\u540e\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u7f16\u8f91,\u8bf7\u901a\u8fc7\u6210\u672c\u66f4\u65b0\u64cd\u4f5c\u66f4\u65b0\u3002", (String)"MatCostSaveOpValidate_3", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private Boolean checkAuxptyExist(Set<Long> auxptyId, String flex) {
        DynamicObject[] auxpty;
        Boolean isNotExist = false;
        for (DynamicObject aux : auxpty = BusinessDataServiceHelper.load((Object[])auxptyId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_auxproperty"))) {
            if (flex.contains(aux.getString("flexfield"))) continue;
            isNotExist = true;
            break;
        }
        return isNotExist;
    }
}

