/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.basedata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class MatCostUnAuditOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("costtype");
        fieldKeys.add("effectdate");
        fieldKeys.add("expdate");
        fieldKeys.add("material");
        fieldKeys.add("matversion");
        fieldKeys.add("auxpty");
        fieldKeys.add("status");
        fieldKeys.add("enable");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                HashSet<Long> ids = new HashSet<Long>(16);
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject matInfo = dataEntity.getDataEntity();
                    if (this.isBeUsed(matInfo).booleanValue()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u6570\u636e\u5df2\u88ab\u5f15\u7528\u3002", (String)"MatCostUnAuditOpPlugin_0", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    String type = matInfo.getString("costtype.type");
                    if ("1".equals(type) || !"C".equals(matInfo.getString("status")) || !"1".equals(matInfo.getString("enable"))) continue;
                    ids.add(Long.valueOf(String.valueOf(matInfo.getPkValue())));
                }
                if (ids.size() > 0) {
                    DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cad_calceffectiveresult"), (Object[])ids.toArray());
                }
            }

            private Boolean isBeUsed(DynamicObject matInfo) {
                ArrayList<Object> qfList = new ArrayList<Object>(10);
                ArrayList<QFilter> baseList = new ArrayList<QFilter>(10);
                baseList.add(new QFilter("costaccount.costtype", "=", (Object)matInfo.getLong("costtype.id")));
                baseList.add(new QFilter("bizdate", ">=", (Object)matInfo.getDate("effectdate")));
                baseList.add(new QFilter("bizdate", "<=", (Object)matInfo.getDate("expdate")));
                baseList.add(new QFilter("billstatus", "=", (Object)"C"));
                qfList.add(new QFilter("entry.material", "=", (Object)matInfo.getLong("material.id")));
                qfList.add(new QFilter("entry.mversion", "=", (Object)matInfo.getLong("matversion.id")));
                qfList.add(new QFilter("entry.assist", "=", (Object)matInfo.getLong("auxpty.id")));
                qfList.add(new QFilter("entry.accounttype", "=", (Object)"D"));
                qfList.addAll(baseList);
                boolean exists = QueryServiceHelper.exists((String)"cal_costrecord", (QFilter[])qfList.toArray(new QFilter[0]));
                if (exists) {
                    return Boolean.TRUE;
                }
                qfList.clear();
                qfList.add(new QFilter("entryentity.material", "=", (Object)matInfo.getLong("material.id")));
                qfList.add(new QFilter("entryentity.mversion", "=", (Object)matInfo.getLong("matversion.id")));
                qfList.add(new QFilter("entryentity.assist", "=", (Object)matInfo.getLong("auxpty.id")));
                qfList.add(new QFilter("entryentity.accounttype", "=", (Object)"D"));
                qfList.addAll(baseList);
                exists = QueryServiceHelper.exists((String)"cal_initbill", (QFilter[])qfList.toArray(new QFilter[0]));
                if (exists) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
    }
}

