/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.basedata;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class ProductGroupExistValidator
extends AbstractValidator {
    public void validate() {
        HashMap matGroupMap = Maps.newHashMapWithExpectedSize((int)32);
        HashMap typeMatMap = Maps.newHashMapWithExpectedSize((int)2);
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String errorOpName = String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25%2$s", (String)"ProductGroupExistValidator_9", (String)"macc-cad-opplugin", (Object[])new Object[0]), this.getOperationName(), "\uff0c");
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String productName;
            String productNumber;
            DynamicObject productDy;
            String existProductGroupName;
            DynamicObject productGroup = dataEntity.getDataEntity();
            String groupType = productGroup.getString("grouptype");
            boolean isManual = "MANUAL".equals(productGroup.getString("source"));
            DynamicObjectCollection entries = productGroup.getDynamicObjectCollection("entryentity");
            DynamicObject mainProductEntry = null;
            for (int i = 0; i < entries.size(); ++i) {
                String existCoProductToMulGroup;
                DynamicObject entry = (DynamicObject)entries.get(i);
                if (!"1".equals(groupType)) continue;
                String productType = entry.getString("producttype");
                String existDiffProductTypeGroup = "";
                DynamicObject material = entry.getDynamicObject("material");
                if (isManual && !StringUtils.isEmpty((Object)(existCoProductToMulGroup = this.verifyProductTypeUnique(entry, productGroup, null)))) {
                    DynamicObject productDy2 = entry.getDynamicObject("material");
                    String productNumber2 = productDy2.getString("number");
                    String productName2 = productDy2.getString("name");
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u624b\u5de5\u65b0\u589e\u4ea7\u54c1\u7ec4\u7684\u5206\u7ec4\u4f9d\u636e\u4e3a\u201c\u4e3b\u8054\u526f\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u540c\u4e00\u4ea7\u54c1\u5173\u8054\u591a\u4e2a\u4ea7\u54c1\u7ec4\uff0c\u8bf7\u68c0\u67e5\u4ea7\u54c1\u201c%2$s/%3$s\u201d\u5728\u4ea7\u54c1\u7ec4\u201c%4$s\u201d\u7684\u8bbe\u7f6e", (String)"ProductGroupExistValidator_5", (String)"macc-cad-opplugin", (Object[])new Object[0]), errorOpName, productNumber2, productName2, existCoProductToMulGroup));
                }
                if ("C".equals(productType)) {
                    Set fitMatSet = (Set)typeMatMap.get("B");
                    long mainMat = material.getLong("id");
                    if (fitMatSet != null && fitMatSet.contains(mainMat)) {
                        existDiffProductTypeGroup = (String)matGroupMap.get(mainMat);
                    } else {
                        mainProductEntry = entry;
                        existDiffProductTypeGroup = this.verifyProductTypeUnique(entry, productGroup, "B");
                    }
                } else if ("B".equals(productType)) {
                    Set mainMatSet = (Set)typeMatMap.get("C");
                    long fitMat = material.getLong("id");
                    existDiffProductTypeGroup = mainMatSet != null && mainMatSet.contains(fitMat) ? (String)matGroupMap.get(fitMat) : this.verifyProductTypeUnique(entry, productGroup, "C");
                }
                if (!StringUtils.isEmpty((Object)existDiffProductTypeGroup) && isManual) {
                    DynamicObject productDy3 = entry.getDynamicObject("material");
                    String productNumber3 = productDy3.getString("number");
                    String productName3 = productDy3.getString("name");
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u652f\u6301\u540c\u4e00\u7269\u6599\u5373\u662f\u4e3b\u4ea7\u54c1\u53c8\u662f\u526f\u4ea7\u54c1\uff0c\u8bf7\u68c0\u67e5\u4ea7\u54c1\u201c%2$s/%3$s\u201d\u5728\u4ea7\u54c1\u7ec4\u201c%4$s\u201d\u7684\u8bbe\u7f6e", (String)"ProductGroupExistValidator_6", (String)"macc-cad-opplugin", (Object[])new Object[0]), errorOpName, productNumber3, productName3, existDiffProductTypeGroup));
                    continue;
                }
                matGroupMap.put(material.getLong("id"), productGroup.getString("number"));
                typeMatMap.computeIfAbsent(productType, mat -> new HashSet()).add(entry.getDynamicObject("material").getLong("id"));
            }
            if (!isManual || !"1".equals(groupType) && !"2".equals(groupType) || (existProductGroupName = this.verifyCurrProductUnique(mainProductEntry, productGroup)) == null) continue;
            if ("1".equals(groupType)) {
                if (mainProductEntry == null) {
                    return;
                }
                productDy = mainProductEntry.getDynamicObject("material");
                productNumber = productDy.getString("number");
                productName = productDy.getString("name");
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u4ea7\u54c1\u201c%2$s/%3$s\u201d\u5728\u4ea7\u54c1\u7ec4\u201c%4$s\u201d\u4e2d\u5df2\u8bbe\u7f6e\u4e3a\u4e3b\u4ea7\u54c1\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"ProductGroupExistValidator_7", (String)"macc-cad-opplugin", (Object[])new Object[0]), errorOpName, productNumber, productName, existProductGroupName));
                continue;
            }
            if (!"2".equals(groupType)) continue;
            productDy = ((DynamicObject)productGroup.getDynamicObjectCollection("entryentity").get(0)).getDynamicObject("material");
            productNumber = productDy.getString("number");
            productName = productDy.getString("name");
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u4ea7\u54c1\u201c%2$s/%3$s\u201d\u5728\u4ea7\u54c1\u7ec4\u201c%4$s\u201d\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u591a\u4e2a\u201c\u7b49\u7ea7\u201d\u7c7b\u578b\u7684\u4ea7\u54c1\u7ec4\u3002", (String)"ProductGroupExistValidator_8", (String)"macc-cad-opplugin", (Object[])new Object[0]), errorOpName, productNumber, productName, existProductGroupName));
        }
    }

    private String verifyProductTypeUnique(DynamicObject entry, DynamicObject productGroup, String productType) {
        DynamicObject auxpty;
        String groupType = productGroup.getString("grouptype");
        DynamicObject org = productGroup.getDynamicObject("calorg");
        QFilter orgFilter = new QFilter("calorg", "=", org.getPkValue());
        orgFilter.and(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        orgFilter.and(new QFilter("probill", "=", (Object)productGroup.getLong("probill")));
        if (productGroup.getPkValue() != null) {
            orgFilter.and(new QFilter("id", "!=", productGroup.getPkValue()));
        }
        orgFilter.and(new QFilter("grouptype", "=", (Object)groupType));
        if (!StringUtils.isEmpty((Object)productType)) {
            orgFilter.and(new QFilter("entryentity.producttype", "=", (Object)productType));
        }
        Object materialId = entry.getDynamicObject("material").getPkValue();
        orgFilter.and(new QFilter("entryentity.material", "=", materialId));
        DynamicObject matVerison = entry.getDynamicObject("matversion");
        if (matVerison != null) {
            orgFilter.and(new QFilter("entryentity.matversion", "=", matVerison.getPkValue()));
        }
        if ((auxpty = entry.getDynamicObject("auxpty")) != null) {
            orgFilter.and(new QFilter("entryentity.auxpty", "=", auxpty.getPkValue()));
        }
        Date now = new Date();
        orgFilter.and(new QFilter("effectdate", "<=", (Object)now));
        orgFilter.and(new QFilter("expdate", ">", (Object)now));
        DynamicObjectCollection productGroupName = QueryServiceHelper.query((String)"cad_productintogroup", (String)"name", (QFilter[])new QFilter[]{orgFilter});
        String existDiffProductTypeGroup = "";
        StringBuilder sb = new StringBuilder();
        if (!CollectionUtils.isEmpty((Collection)productGroupName)) {
            productGroupName.forEach(s -> sb.append(s.get("name")).append("\uff1b"));
            existDiffProductTypeGroup = sb.substring(0, sb.length() - 1);
        }
        return existDiffProductTypeGroup;
    }

    private String verifyCurrProductUnique(DynamicObject entry, DynamicObject productGroup) {
        String groupType = productGroup.getString("grouptype");
        if (entry == null && "1".equals(groupType)) {
            return null;
        }
        DynamicObject org = productGroup.getDynamicObject("calorg");
        QFilter orgFilter = new QFilter("calorg", "=", org.getPkValue());
        orgFilter.and(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        if (productGroup.getPkValue() != null) {
            orgFilter.and(new QFilter("id", "!=", productGroup.getPkValue()));
        }
        orgFilter.and(new QFilter("grouptype", "=", (Object)groupType));
        if ("2".equals(groupType)) {
            DynamicObjectCollection dynamicObjectCollection = productGroup.getDynamicObjectCollection("entryentity");
            if (dynamicObjectCollection.isEmpty()) {
                return null;
            }
            DynamicObject targetEntry = (DynamicObject)dynamicObjectCollection.get(0);
            DynamicObject dynamicObject = targetEntry.getDynamicObject("material");
            if (dynamicObject == null) {
                return null;
            }
            Object materialId = dynamicObject.getPkValue();
            orgFilter.and(new QFilter("entryentity.material", "=", materialId));
            DynamicObjectCollection query = QueryServiceHelper.query((String)"cad_productintogroup", (String)"name", (QFilter[])new QFilter[]{orgFilter});
            if (!CollectionUtils.isEmpty((Collection)query)) {
                return ((DynamicObject)query.get(0)).getString("name");
            }
        } else if (entry != null && "1".equals(groupType)) {
            DynamicObjectCollection query;
            DynamicObject auxpty;
            orgFilter.and(new QFilter("probill", "=", (Object)productGroup.getLong("probill")));
            orgFilter.and(new QFilter("entryentity.producttype", "=", (Object)"C"));
            Object materialId = entry.getDynamicObject("material").getPkValue();
            orgFilter.and(new QFilter("entryentity.material", "=", materialId));
            DynamicObject matVerison = entry.getDynamicObject("matversion");
            if (matVerison != null) {
                orgFilter.and(new QFilter("entryentity.matversion", "=", matVerison.getPkValue()));
            }
            if ((auxpty = entry.getDynamicObject("auxpty")) != null) {
                orgFilter.and(new QFilter("entryentity.auxpty", "=", auxpty.getPkValue()));
            }
            Date effectiveDate = productGroup.getDate("effectdate");
            Date invalidDate = productGroup.getDate("expdate");
            if (effectiveDate != null && invalidDate != null) {
                orgFilter.and(new QFilter("effectdate", "<", (Object)effectiveDate)).and(new QFilter("expdate", ">", (Object)invalidDate));
            }
            if (!CollectionUtils.isEmpty((Collection)(query = QueryServiceHelper.query((String)"cad_productintogroup", (String)"name", (QFilter[])new QFilter[]{orgFilter})))) {
                return ((DynamicObject)query.get(0)).getString("name");
            }
        }
        return null;
    }
}

