/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.basedata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.macc.cad.common.helper.EntityPropertyHelper;
import kd.macc.cad.opplugin.basedata.ProductGroupExistValidator;
import kd.macc.cad.opplugin.basedata.ProductGroupUniqueValidator;
import kd.macc.cad.opplugin.basedata.ProductGroupWeightValidator;

public class ProductGroupSaveOp
extends AbstractOperationServicePlugIn {
    private static Set<String> entryFileName = EntityPropertyHelper.getEntryPropertys((String)"cad_productintogroup", (String)"entryentity", (String)"weightentry");
    private static Set<String> weightFileName = EntityPropertyHelper.getSonEntryPropertys((String)"cad_productintogroup", (String)"entryentity", (String)"weightentry");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("calorg");
        fieldKeys.add("grouptype");
        fieldKeys.add("status");
        fieldKeys.add("effectdate");
        fieldKeys.add("expdate");
        fieldKeys.add("entryentity");
        fieldKeys.addAll(entryFileName);
        fieldKeys.addAll(weightFileName);
        fieldKeys.add("weight");
        fieldKeys.add("alloctype");
        fieldKeys.add("element");
        fieldKeys.add("subelement");
        fieldKeys.add("weightentry");
        fieldKeys.add("allocweight");
        fieldKeys.add("groupcategory");
        fieldKeys.add("groupfield");
        fieldKeys.add("source");
        fieldKeys.add("srcbillnumber");
        fieldKeys.add("srcbillrow");
        fieldKeys.add("probill");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        Map variables = this.getOption().getVariables();
        String importtype = (String)variables.get("importtype");
        if (importtype != null) {
            for (DynamicObject dataEntity : e.getDataEntities()) {
                String number = dataEntity.getString("number");
                if (number == null) {
                    try {
                        dataEntity.set("number", (Object)CodeRuleServiceHelper.getNumber((String)"cad_productintogroup", (DynamicObject)dataEntity, (String)RequestContext.get().getLoginOrg()));
                    }
                    catch (Exception ex) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4ea7\u54c1\u7ec4\u7f16\u7801\u89c4\u5219\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ProductGroupSaveOp_0", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    }
                }
                if (!"override".equals(importtype) && !"overridenew".equals(importtype)) continue;
                LinkedHashMap<String, DynamicObject> adjustMap = new LinkedHashMap<String, DynamicObject>(16);
                this.adjustData(dataEntity, adjustMap);
            }
        }
        e.getValidators().add(new ProductGroupUniqueValidator());
        e.getValidators().add(new ProductGroupExistValidator());
        e.getValidators().add(new ProductGroupWeightValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length < 1) {
            return;
        }
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
            dynamicObjectCollection.forEach(o -> o.set("importtype", null));
            Map variables = this.getOption().getVariables();
            String importtype = (String)variables.get("importtype");
            if (importtype == null) continue;
            dataEntity.set("status", (Object)"A");
        }
    }

    private void adjustData(DynamicObject dataEntity, Map<String, DynamicObject> adjustMap) {
        StringBuilder keyBuilder = new StringBuilder();
        ArrayList<DynamicObject> importWightList = new ArrayList<DynamicObject>(16);
        HashSet<DynamicObject> removeEntrySet = new HashSet<DynamicObject>(16);
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
        List isImportData = dynamicObjectCollection.stream().filter(o -> {
            String importtype = o.getString("importtype");
            return "p".equals(importtype) || "w".equals(importtype);
        }).collect(Collectors.toList());
        StringBuilder importKeyBuild = new StringBuilder();
        StringBuilder keyBuild = new StringBuilder();
        for (DynamicObject entryEntity : dynamicObjectCollection) {
            String importtype = entryEntity.getString("importtype");
            if ("w".equals(importtype)) {
                removeEntrySet.add(entryEntity);
                continue;
            }
            if ("p".equals(importtype)) continue;
            Long materialId = entryEntity.getDynamicObject("material").getLong("id");
            Long matversionId = entryEntity.getLong("matversion.id");
            Long auxptyId = entryEntity.getLong("auxpty.id");
            String keyBuildStr = keyBuild.append(materialId).append(matversionId).append(auxptyId).toString();
            keyBuild.setLength(0);
            for (DynamicObject isImportDatum : isImportData) {
                String key;
                Long subElementId;
                Long elementId;
                Long isImportDatumId = isImportDatum.getDynamicObject("material").getLong("id");
                Long isImportMatversionId = isImportDatum.getLong("matversion.id");
                Long isImportAuxptyId = isImportDatum.getLong("auxpty.id");
                String importKeyBuildStr = importKeyBuild.append(isImportDatumId).append(isImportMatversionId).append(isImportAuxptyId).toString();
                importKeyBuild.setLength(0);
                if (!keyBuildStr.equals(importKeyBuildStr)) continue;
                removeEntrySet.add(isImportDatum);
                if ("p".equals(isImportDatum.getString("importtype"))) {
                    for (String fileName : entryFileName) {
                        entryEntity.set(fileName, isImportDatum.get(fileName));
                    }
                }
                if (!"w".equals(isImportDatum.getString("importtype"))) continue;
                DynamicObjectCollection isImportweightEntry = isImportDatum.getDynamicObjectCollection("weightentry");
                DynamicObjectCollection weightEntry = entryEntity.getDynamicObjectCollection("weightentry");
                for (DynamicObject entry : isImportweightEntry) {
                    elementId = entry.getDynamicObject("element").getLong("id");
                    subElementId = entry.getDynamicObject("subelement").getLong("id");
                    key = keyBuilder.append(elementId).append(subElementId).toString();
                    adjustMap.put(key, entry);
                    keyBuilder.delete(0, key.length());
                }
                for (DynamicObject entry : weightEntry) {
                    elementId = entry.getDynamicObject("element").getLong("id");
                    subElementId = entry.getDynamicObject("subelement").getLong("id");
                    key = keyBuilder.append(elementId).append(subElementId).toString();
                    DynamicObject importData = adjustMap.get(key);
                    if (importData != null) {
                        for (String fileName : weightFileName) {
                            entry.set(fileName, importData.get(fileName));
                        }
                        importWightList.add(importData);
                    }
                    keyBuilder.delete(0, key.length());
                }
                Collection<DynamicObject> values = adjustMap.values();
                values.removeAll(importWightList);
                int size = weightEntry.size();
                for (DynamicObject value : values) {
                    DynamicObject newData = weightEntry.addNew();
                    newData.set("seq", (Object)(++size));
                    for (String fileName : weightFileName) {
                        newData.set(fileName, value.get(fileName));
                    }
                }
                adjustMap.clear();
            }
        }
        if (removeEntrySet.size() > 0) {
            dynamicObjectCollection.removeAll(removeEntrySet);
        }
    }
}

