/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.basedata;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.login.utils.DateUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.algox.function.TimeUtils;
import kd.macc.cad.common.helper.EntityPropertyHelper;
import kd.macc.cad.common.helper.SysParamHelper;

public class ProductGroupUnAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(EntityPropertyHelper.getPropertys((String)"cad_productintogroup"));
        fieldKeys.addAll(EntityPropertyHelper.getEntryPropertys((String)"cad_productintogroup", (String)"entryentity", (String)"weightentry"));
        fieldKeys.addAll(EntityPropertyHelper.getSonEntryPropertys((String)"cad_productintogroup", (String)"entryentity", (String)"weightentry"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    Date date;
                    DynamicObject checkData = dataEntity.getDataEntity();
                    if (!SysParamHelper.getEnableEffectByOrg((Long)checkData.getLong("calorg.id"), (String)"aca", (String)"cad_productintogroup").booleanValue() || (date = checkData.getDate("expdate")) == null || date.compareTo(new Date()) >= 0) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u6570\u636e\u5df2\u7ecf\u5931\u6548\uff0c\u65e0\u6cd5\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"ProductGroupUnAuditOp_0", (String)"macc-cad-opplugin", (Object[])new Object[0]), checkData.getString("number")));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        Date opDate = new Date();
        ArrayList<DynamicObject> saveDataLIst = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("unauditflag", (Object)1);
            if (!SysParamHelper.getEnableEffectByOrg((Long)dataEntity.getLong("calorg.id"), (String)"aca", (String)"cad_productintogroup").booleanValue()) continue;
            DynamicObject newProductData = (DynamicObject)OrmUtils.clone((Object)dataEntity, (IDataEntityType)dataEntity.getDataEntityType(), (boolean)true, (boolean)true);
            String newNumber = newProductData.getString("number");
            newProductData.set("number", (Object)(newNumber + DateUtils.formatDate((Date)new Date(), (Object[])new Object[]{"ddHHmmss"})));
            newProductData.set("expdate", (Object)opDate);
            newProductData.set("status", (Object)"C");
            saveDataLIst.add(newProductData);
            dataEntity.set("effectdate", (Object)opDate);
            Date invalidDate = dataEntity.getDate("expdate");
            if (invalidDate != null) continue;
            dataEntity.set("expdate", (Object)TimeUtils.getDeFaultExpDate());
        }
        if (saveDataLIst.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveDataLIst.toArray(new DynamicObject[0]));
        }
    }
}

