/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.basedata;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ProductGroupUniqueValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(ProductGroupUniqueValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject productGroup = dataEntity.getDataEntity();
            String groupType = productGroup.getString("grouptype");
            String groupField = productGroup.getString("groupfield");
            DynamicObjectCollection entries = productGroup.getDynamicObjectCollection("entryentity");
            int mainProductSum = 0;
            HashSet<String> verifyUniqueSet = new HashSet<String>(entries.size());
            HashSet<String> productNumbers = new HashSet<String>(entries.size());
            HashSet<String> groupCateSet = new HashSet<String>(entries.size());
            HashSet<String> auxStringSet = new HashSet<String>(entries.size());
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entries)) {
                Iterator entryIt = entries.iterator();
                int i = 0;
                while (entryIt.hasNext()) {
                    DynamicObject entry = (DynamicObject)entryIt.next();
                    DynamicObject product = entry.getDynamicObject("material");
                    if (product == null) continue;
                    switch (groupType) {
                        case "1": {
                            String productType;
                            if (BomRouterHelper.isEnableAuxprop((DynamicObject)product) && entry.getDynamicObject("auxpty") == null) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u4fe1\u606f\u7b2c%1$s\u884c\u201c%2$s\u201d\u5df2\u542f\u7528\u5f71\u54cd\u6210\u672c\u7684\u8f85\u52a9\u5c5e\u6027\uff0c\u8bf7\u586b\u5199\u8f85\u52a9\u5c5e\u6027\u3002", (String)"ProductGroupUniqueValidator_17", (String)"macc-cad-opplugin", (Object[])new Object[0]), i + 1, product.getString("name")));
                            }
                            if ("2".equals(entry.getString("alloctype")) && entry.getBigDecimal("weight").compareTo(BigDecimal.ZERO) == 0) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u5206\u914d\u7c7b\u578b\u201d\u4e3a\u624b\u5de5\u6307\u5b9a\u65f6\uff0c\u9700\u5f55\u5165\u201c\u5206\u914d\u6743\u91cd\u201d\u3002", (String)"ProductGroupUniqueValidator_2", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                            }
                            if (StringUtils.isBlank((CharSequence)(productType = entry.getString("producttype")))) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u4fe1\u606f\u7b2c%s\u884c\uff0c\u4ea7\u54c1\u7c7b\u578b\u672a\u586b\u5199\u3002", (String)"ProductGroupUniqueValidator_3", (String)"macc-cad-opplugin", (Object[])new Object[0]), i + 1));
                            }
                            if (StringUtils.isEmpty((CharSequence)entry.getString("alloctype"))) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u4fe1\u606f\u7b2c%s\u884c\uff0c\u5206\u914d\u7c7b\u578b\u672a\u586b\u5199\u3002", (String)"ProductGroupUniqueValidator_4", (String)"macc-cad-opplugin", (Object[])new Object[0]), i + 1));
                            }
                            if ("C".equals(productType)) {
                                ++mainProductSum;
                            }
                            StringBuilder sb = new StringBuilder();
                            sb.append(entry.getDynamicObject("material").getPkValue());
                            sb.append('_');
                            sb.append(StringUtils.isEmpty((CharSequence)entry.getString("producttype")) ? " " : entry.getString("producttype"));
                            sb.append('_');
                            sb.append(entry.getDynamicObject("matversion") == null ? "0" : entry.getDynamicObject("matversion").getPkValue());
                            sb.append('_');
                            sb.append(entry.getDynamicObject("auxpty") == null ? "0" : entry.getDynamicObject("auxpty").getPkValue());
                            verifyUniqueSet.add(sb.toString());
                            break;
                        }
                        case "2": {
                            if (groupField.equals("bd_invtype")) {
                                if (StringUtils.isEmpty((CharSequence)entry.getString("groupcategory"))) {
                                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u4fe1\u606f\u7b2c%s\u884c\uff0c\u5206\u7ec4\u7c7b\u578b\u672a\u586b\u5199\u3002", (String)"ProductGroupUniqueValidator_5", (String)"macc-cad-opplugin", (Object[])new Object[0]), i + 1));
                                }
                                if (entry.getDynamicObject("groupcategory") != null) {
                                    groupCateSet.add(entry.getDynamicObject("groupcategory").getString("number"));
                                }
                            }
                            if (groupField.equals("bd_auxproperty")) {
                                String auxString = entry.getString("auxpty");
                                if (BomRouterHelper.isEnableAuxprop((DynamicObject)product) && auxString == null) {
                                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u7ec4\u5b57\u6bb5=\u8f85\u52a9\u5c5e\u6027\uff0c\u4ea7\u54c1\u4fe1\u606f\u7b2c%1$s\u884c\u201c%2$s\u201d\u542f\u7528\u4e86\u8f85\u52a9\u5c5e\u6027\uff0c\u8bf7\u586b\u5199\u8f85\u52a9\u5c5e\u6027\u3002", (String)"ProductGroupUniqueValidator_19", (String)"macc-cad-opplugin", (Object[])new Object[0]), i + 1, product.getString("name")));
                                }
                                if (!BomRouterHelper.enableAuxNotEffCost((DynamicObject)product)) {
                                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u4fe1\u606f\u7b2c%1$s\u884c\u201c%2$s\u201d\u672a\u542f\u7528\u8f85\u52a9\u5c5e\u6027\uff0c\u8bf7\u5207\u6362\u5206\u7ec4\u5b57\u6bb5\u3002", (String)"ProductGroupUniqueValidator_16", (String)"macc-cad-opplugin", (Object[])new Object[0]), i + 1, product.getString("name")));
                                }
                                auxStringSet.add(auxString);
                            }
                            productNumbers.add(product.getString("number"));
                            entry.set("alloctype", (Object)"2");
                            break;
                        }
                        case "3": {
                            if (BomRouterHelper.isEnableAuxprop((DynamicObject)product) && entry.getDynamicObject("auxpty") == null) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u4fe1\u606f\u7b2c%1$s\u884c\u201c%2$s\u201d\u5df2\u542f\u7528\u5f71\u54cd\u6210\u672c\u7684\u8f85\u52a9\u5c5e\u6027\uff0c\u8bf7\u586b\u5199\u8f85\u52a9\u5c5e\u6027\u3002", (String)"ProductGroupUniqueValidator_17", (String)"macc-cad-opplugin", (Object[])new Object[0]), i + 1, product.getString("name")));
                            }
                            StringBuilder otherUnique = new StringBuilder();
                            otherUnique.append(entry.getDynamicObject("material").getPkValue());
                            otherUnique.append('_');
                            otherUnique.append(entry.getDynamicObject("auxpty") == null ? "0" : entry.getDynamicObject("auxpty").getPkValue());
                            verifyUniqueSet.add(otherUnique.toString());
                            break;
                        }
                    }
                    ++i;
                }
            }
            if (verifyUniqueSet.size() != entries.size() && !"2".equals(groupType)) {
                logger.info("\u751f\u6210\u4ea7\u54c1\u7ec4key{},{}", (Object)JSON.toJSONString(verifyUniqueSet), (Object)entries.size());
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ea7\u54c1\u3001\u4ea7\u54c1\u7c7b\u578b\u3001\u7269\u6599\u7248\u672c\u3001\u8f85\u52a9\u5c5e\u6027\u7ec4\u5408\u5b58\u5728\u91cd\u590d\u3002", (String)"ProductGroupUniqueValidator_8", (String)"macc-cad-opplugin", (Object[])new Object[0]));
            }
            if ("1".equals(groupType)) {
                if (mainProductSum == 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u7ec4\u4f9d\u636e\u4e3a\u201c\u4e3b\u8054\u526f\u201d\u7684\u4ea7\u54c1\u7ec4\uff0c\u9700\u8981\u8bbe\u7f6e\u4e3b\u4ea7\u54c1\u3002", (String)"ProductGroupUniqueValidator_9", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                } else if (mainProductSum > 1) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u5206\u7ec4\u4f9d\u636e=\u4e3b\u526f\u8054\u65f6\uff0c\u4ea7\u54c1\u7c7b\u578b\u53ea\u80fd\u6709\u4e00\u4e2a\u4e3b\u4ea7\u54c1\u3002", (String)"ProductGroupUniqueValidator_10", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                }
            }
            if (!"2".equals(groupType)) continue;
            if (productNumbers.size() > 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u7ec4\u4f9d\u636e\u4e3a\u201c\u7b49\u7ea7\u201d\u65f6\uff0c\u8868\u4f53\u4ea7\u54c1\u552f\u4e00\u3002", (String)"ProductGroupUniqueValidator_11", (String)"macc-cad-opplugin", (Object[])new Object[0]));
            }
            if (groupField.equals("bd_invtype") && groupCateSet.size() < entries.size()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u7ec4\u5b57\u6bb5\u4e3a\u5e93\u5b58\u7c7b\u578b\u65f6\uff0c\u8868\u4f53\u5206\u7ec4\u7c7b\u578b\u4e0d\u552f\u4e00\u3002", (String)"ProductGroupUniqueValidator_12", (String)"macc-cad-opplugin", (Object[])new Object[0]));
            }
            if (!groupField.equals("bd_auxproperty") || auxStringSet.size() >= entries.size()) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u7ec4\u5b57\u6bb5\u4e3a\u8f85\u52a9\u5c5e\u6027\u65f6\uff0c\u8f85\u52a9\u5c5e\u6027\u503c\u4e0d\u552f\u4e00\u3002", (String)"ProductGroupUniqueValidator_13", (String)"macc-cad-opplugin", (Object[])new Object[0]));
        }
    }
}

