/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.basedata;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.StringUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ProductGroupWeightValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject productGroup = dataEntity.getDataEntity();
            String source = productGroup.getString("source");
            String grouptype = productGroup.getString("grouptype");
            DynamicObjectCollection entrys = productGroup.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                String allocType;
                if (!StringUtils.isEmpty((Object)source) && "MANUAL".equals(source) && "2".equals(allocType = entry.getString("alloctype"))) {
                    BigDecimal weight = entry.getBigDecimal("weight");
                    if ("2".equals(grouptype)) {
                        if (weight.compareTo(BigDecimal.ZERO) < 0 || weight.compareTo(new BigDecimal(100)) >= 0) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u624b\u5de5\u65b0\u589e\u6743\u91cd\u8303\u56f4\uff1a0\u2264\u6743\u91cd<100)\u3002", (String)"ProductGroupWeightValidator_5", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                        }
                    } else if (weight.compareTo(BigDecimal.ZERO) <= 0 || weight.compareTo(new BigDecimal(100)) >= 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u624b\u5de5\u65b0\u589e\u6743\u91cd\u8303\u56f4:0<\u6743\u91cd<100\u3002", (String)"ProductGroupWeightValidator_1", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    }
                }
                DynamicObjectCollection allocEntry = entry.getDynamicObjectCollection("weightentry");
                String producttype = entry.getString("producttype");
                for (DynamicObject allocentry : allocEntry) {
                    String element = allocentry.getString("element");
                    String subElement = allocentry.getString("subelement");
                    String allocweight = allocentry.getString("allocweight");
                    String fixedAmt = allocentry.getString("fixedamt");
                    if (!CadEmptyUtils.isEmpty((DynamicObject)allocentry) && !"A".equals(producttype)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8054\u4ea7\u54c1\u5206\u914d\u6743\u91cd\u660e\u7ec6\u6709\u6570\u636e\uff0c\u4ea7\u54c1\u7c7b\u578b\u8981\u4e3a\u8054\u4ea7\u54c1\u3002", (String)"ProductGroupWeightValidator_2", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    }
                    if (!StringUtils.isEmpty((Object)subElement) && StringUtils.isEmpty((Object)allocweight) && StringUtils.isEmpty((Object)fixedAmt)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8054\u4ea7\u54c1\u5206\u914d\u6743\u91cd\u660e\u7ec6\u6709\u6570\u636e\uff0c\u5206\u914d\u6743\u91cd\u5fc5\u5f55\u3002", (String)"ProductGroupWeightValidator_3", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    }
                    if (allocweight != null && fixedAmt != null && allocentry.getBigDecimal("allocweight").compareTo(BigDecimal.ZERO) != 0 && allocentry.getBigDecimal("fixedamt").compareTo(BigDecimal.ZERO) != 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8054\u4ea7\u54c1\u5206\u914d\u6743\u91cd\u660e\u7ec6\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u201c\u5206\u914d\u6743\u91cd\u201d\u548c\u201c\u56fa\u5b9a\u91d1\u989d\u201d\u4e0d\u652f\u6301\u540c\u65f6\u5f55\u5165\u3002", (String)"ProductGroupWeightValidator_9", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    }
                    if (element == null || subElement != null) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u5b50\u8981\u7d20\u3002", (String)"ProductGroupWeightValidator_4", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }
}

