/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.basedata;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class SubElementExpenseSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("element");
        fieldKeys.add("subelement");
        fieldKeys.add("expenseitem");
        fieldKeys.add("appnum");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                Set leafExpenseItems;
                long orgId;
                DynamicObject subElement;
                DynamicObject subEleExpenseItem;
                boolean isAdd = Boolean.TRUE;
                ExtendedDataEntity[] dataEntities = this.dataEntities;
                HashMap<Long, Set> orgExpenseItemMap = new HashMap<Long, Set>(16);
                HashMap<Long, Set> orgLeafItemMap = new HashMap<Long, Set>(16);
                HashSet<Long> subElementIds = new HashSet<Long>(16);
                Set enableSubElementIds = SubElementExpenseSaveOp.this.getAllEnableSubElement();
                Map subEle2EleMap = new HashMap(16);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    subEleExpenseItem = dataEntity.getDataEntity();
                    long id = subEleExpenseItem.getLong("id");
                    if (!CadEmptyUtils.isEmpty((Long)id)) {
                        isAdd = false;
                    }
                    if (CadEmptyUtils.isEmpty((DynamicObject)(subElement = subEleExpenseItem.getDynamicObject("subelement")))) continue;
                    subElementIds.add(subElement.getLong("id"));
                }
                if (!subElementIds.isEmpty()) {
                    subEle2EleMap = SubElementExpenseSaveOp.this.getSubEle2EleMap(subElementIds);
                }
                if (isAdd) {
                    for (ExtendedDataEntity dataEntity : dataEntities) {
                        Set<Long> expenseItemIds;
                        String appNum;
                        Set leafExpenseItems2;
                        subEleExpenseItem = dataEntity.getDataEntity();
                        orgId = subEleExpenseItem.getLong("org.id");
                        if (!orgLeafItemMap.containsKey(orgId)) {
                            leafExpenseItems = SubElementExpenseSaveOp.this.getLeafExpenseItem(orgId);
                            orgLeafItemMap.put(orgId, leafExpenseItems);
                        }
                        if (CadEmptyUtils.isEmpty((DynamicObject)(subElement = subEleExpenseItem.getDynamicObject("subelement")))) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u672a\u586b\u5199\u3002", (String)"SubElementExpenseSaveOp_0", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                        } else {
                            if (!enableSubElementIds.contains(subElement.getLong("id"))) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u4f7f\u7528\u72b6\u6001\u4e3a\u7981\u7528\u3002", (String)"SubElementExpenseSaveOp_1", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                                continue;
                            }
                            DynamicObject element = subEleExpenseItem.getDynamicObject("element");
                            if (CadEmptyUtils.isEmpty((DynamicObject)element)) {
                                Long elementId = (Long)subEle2EleMap.get(subElement.getLong("id"));
                                if (CadEmptyUtils.isEmpty((Long)elementId)) {
                                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6839\u636e\u6210\u672c\u5b50\u8981\u7d20\u672a\u627e\u5230\u6210\u672c\u8981\u7d20\u3002", (String)"SubElementExpenseSaveOp_2", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                                }
                                subEleExpenseItem.set("element_id", (Object)elementId);
                            }
                        }
                        DynamicObject expenseItem = subEleExpenseItem.getDynamicObject("expenseitem");
                        long expenseId = expenseItem.getLong("id");
                        boolean enable = expenseItem.getBoolean("enable");
                        if (!enable) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u201c%s\u201d\u4f7f\u7528\u72b6\u6001\u4e3a\u7981\u7528\u3002", (String)"SubElementExpenseSaveOp_3", (String)"macc-cad-opplugin", (Object[])new Object[0]), expenseItem.getString("name")));
                        }
                        if (!(leafExpenseItems2 = (Set)orgLeafItemMap.get(orgId)).contains(expenseId)) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u201c%s\u201d\u4e0d\u53ef\u7ef4\u62a4\u3002", (String)"SubElementExpenseSaveOp_4", (String)"macc-cad-opplugin", (Object[])new Object[0]), expenseItem.getString("name")));
                        }
                        if (StringUtils.isEmpty((CharSequence)(appNum = subEleExpenseItem.getString("appnum")))) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6240\u5c5e\u5e94\u7528\u672a\u586b\u5199\u3002", (String)"SubElementExpenseSaveOp_5", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                        }
                        if (CadEmptyUtils.isEmpty((Long)orgId)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"SubElementExpenseSaveOp_6", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                        }
                        if (!orgExpenseItemMap.containsKey(orgId)) {
                            Set dbExpenseItems = SubElementExpenseSaveOp.this.getExpenseItem(orgId, appNum);
                            orgExpenseItemMap.put(orgId, dbExpenseItems);
                        }
                        Set set = expenseItemIds = orgExpenseItemMap.get(orgId) == null ? new HashSet(16) : (Set)orgExpenseItemMap.get(orgId);
                        if (expenseItemIds.contains(expenseId)) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u201c%s\u201d\u5df2\u914d\u7f6e\u5bf9\u5e94\u5173\u7cfb", (String)"SubElementExpenseSaveOp_7", (String)"macc-cad-opplugin", (Object[])new Object[0]), expenseItem.getString("name")));
                            continue;
                        }
                        expenseItemIds.add(expenseId);
                    }
                } else {
                    for (ExtendedDataEntity dataEntity : dataEntities) {
                        Set expenseItemIds;
                        String appNum;
                        Set leafExpenseItems3;
                        subEleExpenseItem = dataEntity.getDataEntity();
                        orgId = subEleExpenseItem.getLong("org.id");
                        if (!orgLeafItemMap.containsKey(orgId)) {
                            leafExpenseItems = SubElementExpenseSaveOp.this.getLeafExpenseItem(orgId);
                            orgLeafItemMap.put(orgId, leafExpenseItems);
                        }
                        if (CadEmptyUtils.isEmpty((DynamicObject)(subElement = subEleExpenseItem.getDynamicObject("subelement")))) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u672a\u586b\u5199\u3002", (String)"SubElementExpenseSaveOp_0", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                        } else {
                            if (!enableSubElementIds.contains(subElement.getLong("id"))) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u5b50\u8981\u7d20\u4f7f\u7528\u72b6\u6001\u4e3a\u7981\u7528\u3002", (String)"SubElementExpenseSaveOp_1", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                                continue;
                            }
                            Long elementId = (Long)subEle2EleMap.get(subElement.getLong("id"));
                            if (CadEmptyUtils.isEmpty((Long)elementId)) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6839\u636e\u6210\u672c\u5b50\u8981\u7d20\u672a\u627e\u5230\u6210\u672c\u8981\u7d20\u3002", (String)"SubElementExpenseSaveOp_2", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                            }
                            subEleExpenseItem.set("element_id", (Object)elementId);
                        }
                        DynamicObject expenseItem = subEleExpenseItem.getDynamicObject("expenseitem");
                        long expenseId = expenseItem.getLong("id");
                        boolean enable = expenseItem.getBoolean("enable");
                        if (!enable) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u201c%s\u201d\u4f7f\u7528\u72b6\u6001\u4e3a\u7981\u7528\u3002", (String)"SubElementExpenseSaveOp_3", (String)"macc-cad-opplugin", (Object[])new Object[0]), expenseItem.getString("name")));
                        }
                        if (!(leafExpenseItems3 = (Set)orgLeafItemMap.get(orgId)).contains(expenseId)) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u201c%s\u201d\u975e\u53f6\u5b50\u8282\u70b9\uff0c\u4e0d\u53ef\u7ef4\u62a4\u3002", (String)"SubElementExpenseSaveOp_8", (String)"macc-cad-opplugin", (Object[])new Object[0]), expenseItem.getString("name")));
                        }
                        if (StringUtils.isEmpty((CharSequence)(appNum = subEleExpenseItem.getString("appnum")))) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6240\u5c5e\u5e94\u7528\u672a\u586b\u5199\u3002", (String)"SubElementExpenseSaveOp_5", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                        }
                        if (CadEmptyUtils.isEmpty((Long)orgId)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"SubElementExpenseSaveOp_6", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                        }
                        if ((expenseItemIds = SubElementExpenseSaveOp.this.getExpenseItem(orgId, appNum, subEleExpenseItem.getLong("id"))).contains(expenseId)) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u201c%s\u201d\u5df2\u914d\u7f6e\u5bf9\u5e94\u5173\u7cfb", (String)"SubElementExpenseSaveOp_7", (String)"macc-cad-opplugin", (Object[])new Object[0]), expenseItem.getString("name")));
                            continue;
                        }
                        expenseItemIds.add(expenseId);
                    }
                }
            }
        });
    }

    private Set<Long> getExpenseItem(Long orgId, String appNum, long id) {
        HashSet<Long> expenseItemIds = new HashSet<Long>(8);
        if (CadEmptyUtils.isEmpty((Long)orgId) || CadEmptyUtils.isEmpty((String)appNum)) {
            return expenseItemIds;
        }
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter appNumQf = new QFilter("appnum", "=", (Object)appNum);
        if (!CadEmptyUtils.isEmpty((Long)id)) {
            appNumQf.and("id", "!=", (Object)id);
        }
        DynamicObjectCollection subElementExpense = QueryServiceHelper.query((String)"cad_subelementexpense", (String)"expenseitem.id", (QFilter[])new QFilter[]{orgQf, appNumQf});
        subElementExpense.forEach(p -> expenseItemIds.add(p.getLong("expenseitem.id")));
        return expenseItemIds;
    }

    private Set<Long> getExpenseItem(Long orgId, String appNum) {
        if (CadEmptyUtils.isEmpty((Long)orgId) || CadEmptyUtils.isEmpty((String)appNum)) {
            return new HashSet<Long>(0);
        }
        HashSet<Long> expenseItemIds = new HashSet<Long>(16);
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("appnum", "=", (Object)appNum)};
        DynamicObjectCollection subElementExpense = QueryServiceHelper.query((String)"cad_subelementexpense", (String)"expenseitem.id", (QFilter[])filters);
        subElementExpense.forEach(p -> expenseItemIds.add(p.getLong("expenseitem.id")));
        return expenseItemIds;
    }

    private Set<Long> getLeafExpenseItem(Long orgId) {
        DynamicObjectCollection expenseItemEdits;
        HashSet<Long> expenseItemIds = new HashSet<Long>(16);
        if (CadEmptyUtils.isEmpty((Long)orgId)) {
            return expenseItemIds;
        }
        QFilter filter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        filter.and("isleaf", "=", (Object)Boolean.TRUE);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataProFilter((String)"er_expenseitemedit", (Long)orgId, (String)"id");
        if (baseDataFilter != null) {
            filter.and(baseDataFilter);
        }
        if ((expenseItemEdits = QueryServiceHelper.query((String)"er_expenseitemedit", (String)"id", (QFilter[])new QFilter[]{filter})) != null) {
            for (DynamicObject expenseItemEdit : expenseItemEdits) {
                long expenseItemId = expenseItemEdit.getLong("id");
                expenseItemIds.add(expenseItemId);
            }
        }
        return expenseItemIds;
    }

    private Map<Long, Long> getSubEle2EleMap(Set<Long> subElementIds) {
        HashMap<Long, Long> subEle2EleMap = new HashMap<Long, Long>(16);
        QFilter subElementIdFilter = new QFilter("subelement", "in", subElementIds);
        DynamicObjectCollection elementRelations = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement,element", (QFilter[])new QFilter[]{subElementIdFilter});
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)elementRelations)) {
            for (DynamicObject elementRelation : elementRelations) {
                long subElementId = elementRelation.getLong("subelement");
                long elementId = elementRelation.getLong("element");
                subEle2EleMap.put(subElementId, elementId);
            }
        }
        return subEle2EleMap;
    }

    private Set<Long> getAllEnableSubElement() {
        HashSet<Long> subElementIds = new HashSet<Long>(16);
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection subElements = QueryServiceHelper.query((String)"cad_subelement", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)subElements)) {
            for (DynamicObject subElement : subElements) {
                subElementIds.add(subElement.getLong("id"));
            }
        }
        return subElementIds;
    }
}

