/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.basedata;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class WorkActivityEnableOpValidate
extends AbstractValidator {
    private String ENTITY = "cad_new_workactivity";

    public void validate() {
        String operateKey = this.getOperateKey();
        if ("disable".equals(operateKey)) {
            this.validateDisable(this.getEnabledData(this.dataEntities));
        } else if ("enable".equals(operateKey)) {
            // empty if block
        }
    }

    private void validateDisable(Map<Long, ExtendedDataEntity> needCheckMap) {
        if (needCheckMap == null || needCheckMap.isEmpty()) {
            return;
        }
        DynamicObjectCollection workActivitys = QueryServiceHelper.query((String)this.ENTITY, (String)"id, status", (QFilter[])new QFilter[]{new QFilter("id", "in", needCheckMap.keySet())});
        for (DynamicObject w : workActivitys) {
            String status = w.getString("status");
            if (!"B".equals(status)) continue;
            this.addErrorMessage(needCheckMap.get(w.getLong("id")), ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u5355\u636e\u624d\u80fd\u7981\u7528\u3002", (String)"WorkActivityEnableOpValidate_0", (String)"macc-cad-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateEnable(Map<Long, ExtendedDataEntity> needCheckMap) {
        if (needCheckMap == null || needCheckMap.isEmpty()) {
            return;
        }
        DynamicObjectCollection workActivitys = QueryServiceHelper.query((String)this.ENTITY, (String)"id, enable, resource", (QFilter[])new QFilter[]{new QFilter("id", "in", needCheckMap.keySet())});
        Iterator iterator = workActivitys.iterator();
        while (iterator.hasNext()) {
            QFilter enableQF = new QFilter("enable", "=", (Object)"1");
            QFilter statusQF = new QFilter("status", "=", (Object)"C");
            DynamicObject w = (DynamicObject)iterator.next();
            Long resource = w.getLong("resource");
            QFilter resourceQF = new QFilter("resource", "=", (Object)resource);
            boolean resourceIsUsed = QueryServiceHelper.exists((String)this.ENTITY, (QFilter[])new QFilter[]{enableQF, statusQF, resourceQF});
            if (!resourceIsUsed) continue;
            this.addErrorMessage(needCheckMap.get(w.getLong("id")), ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\u3002\u5f53\u524d\u8d44\u6e90\u5df2\u7ecf\u5339\u914d\u4e86\u4f5c\u4e1a\u6d3b\u52a8\u3002", (String)"WorkActivityEnableOpValidate_1", (String)"macc-cad-opplugin", (Object[])new Object[0]));
        }
    }

    private Map<Long, ExtendedDataEntity> getDisabledData(ExtendedDataEntity[] dataEntities) {
        HashMap<Long, ExtendedDataEntity> needCheckMap = new HashMap<Long, ExtendedDataEntity>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject selectedData = dataEntity.getDataEntity();
            if (selectedData.getBoolean("enable")) continue;
            Long id = (Long)selectedData.getPkValue();
            needCheckMap.put(id, dataEntity);
        }
        return needCheckMap;
    }

    private Map<Long, ExtendedDataEntity> getEnabledData(ExtendedDataEntity[] dataEntities) {
        HashMap<Long, ExtendedDataEntity> needCheckMap = new HashMap<Long, ExtendedDataEntity>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject selectedData = dataEntity.getDataEntity();
            if (!selectedData.getBoolean("enable")) continue;
            Long id = (Long)selectedData.getPkValue();
            needCheckMap.put(id, dataEntity);
        }
        return needCheckMap;
    }
}

