/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.costobject;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.cad.opplugin.costobject.CostObjectDeleteOpValidator;

public class CostObjectDeleteOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("biztype");
        fieldKeys.add("productgroup");
        fieldKeys.add("producttype");
        fieldKeys.add("mainproobj");
        fieldKeys.add("probill");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CostObjectDeleteOpValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        List datas = e.getValidExtDataEntities();
        ArrayList<ExtendedDataEntity> successList = new ArrayList<ExtendedDataEntity>(datas.size());
        ArrayList<ExtendedDataEntity> mainCostObjs = new ArrayList<ExtendedDataEntity>(10);
        ArrayList<Long> costObjIds = new ArrayList<Long>(10);
        ArrayList<Long> probillIds = new ArrayList<Long>(10);
        for (ExtendedDataEntity data : datas) {
            DynamicObject dyn = data.getDataEntity();
            String producttype = dyn.getString("producttype");
            String biztype = dyn.getString("biztype");
            DynamicObject productgroupDyn = dyn.getDynamicObject("productgroup");
            if ("C".equals(producttype) && "RO".equals(biztype) && productgroupDyn != null) {
                mainCostObjs.add(data);
                costObjIds.add(dyn.getLong("id"));
                probillIds.add(dyn.getLong("probill"));
                continue;
            }
            successList.add(data);
        }
        if (!costObjIds.isEmpty()) {
            QFilter filter = new QFilter("mainproobj", "in", costObjIds);
            DataSet resultDs = QueryServiceHelper.queryDataSet((String)"costobject", (String)"cad_costobject", (String)"id", (QFilter[])filter.toArray(), null);
            ArrayList<Long> fids = new ArrayList<Long>(10);
            for (Row row : resultDs) {
                fids.add(row.getLong("id"));
            }
            OperationServiceHelper.executeOperate((String)"unaudit", (String)"cad_costobject", (Object[])fids.toArray(), (OperateOption)OperateOption.create());
            OperationServiceHelper.executeOperate((String)"delete", (String)"cad_costobject", (Object[])fids.toArray(), (OperateOption)OperateOption.create());
            QFilter[] filters = new QFilter[]{new QFilter("probill", "in", probillIds)};
            DeleteServiceHelper.delete((String)"cad_productintogroup", (QFilter[])filters);
            resultDs = QueryServiceHelper.queryDataSet((String)"costobject", (String)"cad_costobject", (String)"id,mainproobj", (QFilter[])filter.toArray(), null);
            HashSet<Long> containJoinSideIds = new HashSet<Long>(10);
            for (Row row : resultDs) {
                containJoinSideIds.add(row.getLong("mainproobj"));
            }
            for (ExtendedDataEntity data : mainCostObjs) {
                DynamicObject dyn = data.getDataEntity();
                Long id = dyn.getLong("id");
                if (containJoinSideIds.contains(id)) {
                    OperateErrorInfo errInfo = new OperateErrorInfo();
                    errInfo.setPkValue((Object)id);
                    errInfo.setLevel(ErrorLevel.Error);
                    errInfo.setMessage(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5173\u8054\u7684\u8054\u526f\u4ea7\u54c1\u88ab\u5176\u4ed6\u5355\u636e\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"CostObjectDeleteOpPlugin_1", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    this.getOperationResult().addErrorInfo(errInfo);
                    continue;
                }
                successList.add(data);
            }
        }
        e.getValidExtDataEntities().clear();
        e.getValidExtDataEntities().addAll(successList);
    }
}

