/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.costobject;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.opplugin.costobject.CostObjectOpValidator;

public class CostObjectOpPlugin
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CostObjectOpValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("material");
        fieldKeys.add("bomversion");
        fieldKeys.add("auxpty");
        fieldKeys.add("bizstatus");
        fieldKeys.add("biztype");
        fieldKeys.add("productgroup");
        fieldKeys.add("producttype");
        fieldKeys.add("srcbillnumber");
        fieldKeys.add("org");
        fieldKeys.add("costcenter");
        fieldKeys.add("srcbillrow");
        fieldKeys.add("isoutsource");
        fieldKeys.add("producenum");
        fieldKeys.add("projectnumber");
        fieldKeys.add("tracknumber");
        fieldKeys.add("configuredcode");
        fieldKeys.add("lot");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if ("save".equals(e.getOperationKey()) || "submit".equals(e.getOperationKey())) {
            HashSet<Long> materialIds = new HashSet<Long>(10);
            Long orgId = 0L;
            for (DynamicObject data : dataEntities) {
                orgId = data.getLong("org.id");
                materialIds.add(data.getLong("material.id"));
            }
            Map materialMap = CostObjectHelper.getAssistMap(materialIds, (Long)orgId);
            for (DynamicObject data : dataEntities) {
                String biztype = data.getString("biztype");
                DynamicObject material = data.getDynamicObject("material");
                if (CadEmptyUtils.isEmpty((DynamicObject)material)) continue;
                this.resetAuxpty(material, data, materialMap, biztype);
            }
            SaveServiceHelper.update((DynamicObject[])dataEntities);
        }
    }

    private void resetAuxpty(DynamicObject mat, DynamicObject data, Map<Long, Boolean> materialMap, String calmethod) {
        HashSet<Long> auxptyIdSet = new HashSet<Long>(16);
        long id = mat.getLong("id");
        DynamicObjectCollection isaffectprices = mat.getDynamicObjectCollection("auxptyentry");
        Boolean isAffectPriceFlag = Boolean.FALSE;
        Boolean isAffectPrice = Boolean.FALSE;
        for (DynamicObject price : isaffectprices) {
            Long auxptyId = price.getLong("auxpty.id");
            boolean isaffectprice = price.getBoolean("isaffectprice");
            if (!isaffectprice) {
                auxptyIdSet.add(auxptyId);
                continue;
            }
            isAffectPriceFlag = isaffectprice;
            isAffectPrice = isaffectprice;
        }
        if (!CostObjectEnum.BIZTYPE_RO.getValue().equals(calmethod) && !CadEmptyUtils.isEmpty(materialMap) && materialMap.containsKey(id)) {
            isAffectPriceFlag = materialMap.get(id);
        }
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)isaffectprices) || !CostObjectEnum.BIZTYPE_RO.getValue().equals(calmethod) && !isAffectPriceFlag.booleanValue()) {
            data.set("auxpty", null);
            return;
        }
        if (isAffectPrice.booleanValue()) {
            DynamicObject[] auxproperty;
            DynamicObject auxpty = (DynamicObject)data.get("auxpty");
            if (CadEmptyUtils.isEmpty((DynamicObject)auxpty)) {
                return;
            }
            String auxStr = (String)auxpty.get(1);
            if (CadEmptyUtils.isEmpty((String)auxStr)) {
                return;
            }
            JSONObject auxptyJsonObject = (JSONObject)JSON.parse((String)auxStr);
            for (DynamicObject aux : auxproperty = BusinessDataServiceHelper.load((String)"bd_auxproperty", (String)"flexfield", (QFilter[])new QFilter[]{new QFilter("id", "in", auxptyIdSet)})) {
                auxptyJsonObject.remove((Object)aux.getString("flexfield"));
            }
            String jsonString = auxptyJsonObject.toJSONString();
            auxpty.set("value", (Object)jsonString);
            data.set("auxpty", (Object)auxpty);
        }
    }
}

