/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.costobject;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang3.StringUtils;

public class CostObjectOpValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(CostObjectOpValidator.class);

    public void validate() {
        ExtendedDataEntity[] datas = this.dataEntities;
        switch (this.getOperateKey()) {
            case "unaudit": {
                this.isRelated(datas);
                break;
            }
            case "save": {
                this.check(datas, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"CostObjectOpValidator_13", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                break;
            }
            case "submit": {
                this.check(datas, ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\u3002", (String)"CostObjectOpValidator_14", (String)"macc-cad-opplugin", (Object[])new Object[0]));
            }
        }
    }

    protected void isRelated(ExtendedDataEntity[] dataEntitys) {
        String aTips;
        HashMap<Long, ExtendedDataEntity> settledMap = new HashMap<Long, ExtendedDataEntity>(16);
        HashMap<Long, ExtendedDataEntity> noSettledMap = new HashMap<Long, ExtendedDataEntity>(16);
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject item = dataEntity.getDataEntity();
            if (item.getString("bizstatus").equals("A")) {
                noSettledMap.put(Long.parseLong(item.getPkValue().toString()), dataEntity);
                continue;
            }
            settledMap.put(Long.parseLong(item.getPkValue().toString()), dataEntity);
        }
        Map infoMap = CostObjectHelper.getCostObjectRelatedInfo(noSettledMap);
        logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u53cd\u5ba1\u6838\u64cd\u4f5c-\u5f15\u7528\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7684\u96c6\u5408\uff1a" + infoMap.values());
        if (CadEmptyUtils.isEmpty((Map)infoMap) && CadEmptyUtils.isEmpty(settledMap)) {
            return;
        }
        for (Map.Entry settled : settledMap.entrySet()) {
            aTips = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u5f53\u524d\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5df2\u7ed3\u7b97\u3002", (String)"CostObjectOpValidator_0", (String)"macc-cad-opplugin", (Object[])new Object[0]);
            this.addErrorMessage((ExtendedDataEntity)settled.getValue(), aTips);
        }
        for (Map.Entry info : infoMap.entrySet()) {
            aTips = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u5f53\u524d\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5df2\u7ecf\u88ab%s\u5f15\u7528\u3002", (String)"CostObjectOpValidator_1", (String)"macc-cad-opplugin", (Object[])new Object[0]);
            this.addErrorMessage((ExtendedDataEntity)info.getKey(), String.format(aTips, info.getValue()));
        }
    }

    protected void check(ExtendedDataEntity[] dataEntitys, String opSaveErr) {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            BigDecimal weight;
            String error;
            DynamicObject item = dataEntity.getDataEntity();
            DynamicObject mat = item.getDynamicObject("material");
            DynamicObject auxpty = item.getDynamicObject("auxpty");
            String calMethod = item.getString("biztype");
            if (!CostObjectEnum.BIZTYPE_RO.getValue().equals(calMethod) && BomRouterHelper.isEnableAuxprop((DynamicObject)mat) && StringUtils.isNotEmpty((CharSequence)(error = BomRouterHelper.validateAuxptyMustInput((DynamicObject)mat, (DynamicObject)auxpty)))) {
                this.addErrorMessage(dataEntity, opSaveErr + error);
            }
            if ((weight = item.getBigDecimal("weight")) == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5206\u914d\u6743\u91cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostObjectOpValidator_9", (String)"macc-cad-opplugin", (Object[])new Object[0]), opSaveErr));
            } else if (BigDecimal.ZERO.compareTo(weight) == 0) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5206\u914d\u6743\u91cd\u4e0d\u80fd\u4e3a0\u3002", (String)"CostObjectOpValidator_10", (String)"macc-cad-opplugin", (Object[])new Object[0]), opSaveErr));
            }
            if (CostObjectEnum.BIZTYPE_FL.getValue().equals(calMethod)) {
                DynamicObject productGroup = item.getDynamicObject("productgroup");
                String productType = item.getString("producttype");
                if (productGroup == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u4ea7\u54c1\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostObjectOpValidator_11", (String)"macc-cad-opplugin", (Object[])new Object[0]), opSaveErr));
                }
                if (productType == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u4ea7\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostObjectOpValidator_12", (String)"macc-cad-opplugin", (Object[])new Object[0]), opSaveErr));
                }
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            if (CostObjectEnum.BIZTYPE_SO.getValue().equals(calMethod)) {
                filters.add(new QFilter("id", "!=", item.getPkValue()));
                filters.add(new QFilter("costcenter", "=", (Object)item.getLong("costcenter.id")));
                filters.add(new QFilter("org", "=", (Object)item.getLong("org.id")));
                filters.add(new QFilter("material", "=", (Object)item.getLong("material.id")));
                filters.add(new QFilter("producenum", "=", (Object)item.getString("producenum")));
                filters.add(new QFilter("bomversion", "=", (Object)item.getLong("bomversion.id")));
                filters.add(new QFilter("auxpty", "=", (Object)item.getLong("auxpty.id")));
                if (QueryServiceHelper.exists((String)"cad_costobject", (QFilter[])filters.toArray(new QFilter[0]))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5728\u8be5\u6838\u7b97\u7ec4\u7ec7\u548c\u6210\u672c\u4e2d\u5fc3\u4e0b\uff0c\u8be5\u201c\u4ea7\u54c1+\u751f\u4ea7\u7f16\u53f7\u201d\u5df2\u5b58\u5728\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"CostObjectOpValidator_15", (String)"macc-cad-opplugin", (Object[])new Object[0]), opSaveErr));
                }
            }
            if (CostObjectEnum.BIZTYPE_PZ.getValue().equals(calMethod) || CostObjectEnum.BIZTYPE_FL.getValue().equals(calMethod)) {
                filters.clear();
                filters.add(new QFilter("id", "!=", item.getPkValue()));
                filters.add(new QFilter("costcenter", "=", (Object)item.getLong("costcenter.id")));
                filters.add(new QFilter("org", "=", (Object)item.getLong("org.id")));
                filters.add(new QFilter("material", "=", (Object)item.getLong("material.id")));
                filters.add(new QFilter("bomversion", "=", (Object)item.getLong("bomversion.id")));
                filters.add(new QFilter("auxpty", "=", (Object)item.getLong("auxpty.id")));
                if (QueryServiceHelper.exists((String)"cad_costobject", (QFilter[])filters.toArray(new QFilter[0]))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5728\u8be5\u6838\u7b97\u7ec4\u7ec7\u548c\u6210\u672c\u4e2d\u5fc3\u4e0b\uff0c\u8be5\u7269\u6599\u5df2\u5b58\u5728\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"CostObjectOpValidator_16", (String)"macc-cad-opplugin", (Object[])new Object[0]), opSaveErr));
                }
            }
            if (!CostObjectEnum.BIZTYPE_RO.getValue().equals(calMethod)) continue;
            String producttype = item.getString("producttype");
            Boolean isoutsource = item.getBoolean("isoutsource");
            String srcBillNumber = item.getString("srcbillnumber");
            String srcBillrow = item.getString("srcbillrow");
            QFilter filter = new QFilter("billno", "=", (Object)srcBillNumber);
            filter.and(new QFilter("treeentryentity.seq", "=", (Object)Long.parseLong(srcBillrow)));
            DynamicObject mftOrder = null;
            mftOrder = isoutsource != false ? QueryServiceHelper.queryOne((String)"om_mftorder", (String)"treeentryentity.producttype producttype", (QFilter[])new QFilter[]{filter}) : QueryServiceHelper.queryOne((String)"pom_mftorder", (String)"treeentryentity.producttype producttype", (QFilter[])new QFilter[]{filter});
            if (mftOrder != null && mftOrder.getString("producttype").equals(producttype)) {
                return;
            }
            String tips = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4e0e\u6e90\u5355\u5bf9\u5e94\u884c\u7684\u4ea7\u54c1\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"CostObjectOpValidator_7", (String)"macc-cad-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, tips);
        }
    }
}

