/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.costobject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.enums.CostObjectEnum;

public class CostObjectRuleSaveOpValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.dataEntities;
        HashMap<String, ExtendedDataEntity> dataMap = new HashMap<String, ExtendedDataEntity>();
        block15: for (int i = 0; i < datas.length; ++i) {
            ExtendedDataEntity dataEntity = datas[i];
            switch (this.getOperateKey()) {
                case "save": 
                case "submit": {
                    this.validateSave(dataEntity);
                    continue block15;
                }
                case "enable": {
                    this.validateEnable(dataEntity, dataMap);
                    continue block15;
                }
                case "audit": {
                    this.validateAudit(dataEntity, dataMap);
                    continue block15;
                }
                case "unaudit": {
                    this.validateRefCostObjects(dataEntity, "unaudit");
                    continue block15;
                }
                case "disable": {
                    this.validateDisable(dataEntity);
                }
            }
        }
    }

    private void validateRefCostObjects(ExtendedDataEntity dataEntity, String operateKey) {
        DynamicObject item = dataEntity.getDataEntity();
        if (QueryServiceHelper.exists((String)"cad_costobject", (QFilter[])new QFilter[]{new QFilter("costobjectrule", "=", (Object)item.getLong("id"))})) {
            String message = "";
            message = "unaudit".equals(operateKey) ? ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u5f53\u524d\u89c4\u5219\u5df2\u751f\u6210\u4e86\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"CostObjectRuleSaveOpValidator_16", (String)"macc-cad-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff0c\u5f53\u524d\u89c4\u5219\u5df2\u751f\u6210\u4e86\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"CostObjectRuleSaveOpValidator_14", (String)"macc-cad-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, message);
        }
    }

    protected void validateSave(ExtendedDataEntity dataEntity) {
        DynamicObject item = dataEntity.getDataEntity();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("id", "!=", item.getPkValue()));
        filters.add(new QFilter("number", "=", (Object)item.getString("number")));
        if (QueryServiceHelper.exists((String)"cad_costobjectrule", (QFilter[])filters.toArray(new QFilter[0]))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\u3002", (String)"CostObjectRuleSaveOpValidator_15", (String)"macc-cad-opplugin", (Object[])new Object[0]));
        }
        String bizType = item.getString("biztype");
        String rule = item.getString("rule");
        if (StringUtils.isNotBlank((CharSequence)bizType)) {
            switch (bizType) {
                case "RO": {
                    this.validateRule(rule, CostObjectEnum.RULE_SN.getValue(), dataEntity);
                    break;
                }
                case "SO": {
                    this.validateRule(rule, CostObjectEnum.RULE_PN.getValue(), dataEntity);
                    break;
                }
                case "PZ": {
                    this.validateRule(rule, CostObjectEnum.RULE_CP.getValue(), dataEntity);
                    break;
                }
                case "FL": {
                    this.validateRule(rule, CostObjectEnum.RULE_CP.getValue(), dataEntity);
                    break;
                }
            }
        }
        this.validateRepeat(dataEntity);
        filters.clear();
        filters.add(new QFilter("costcenter", "=", (Object)item.getLong("costcenter.id")));
        filters.add(new QFilter("org", "=", (Object)item.getLong("accountorg.id")));
        if (QueryServiceHelper.exists((String)"cad_costobject", (QFilter[])filters.toArray(new QFilter[0]))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u201c\u6838\u7b97\u7ec4\u7ec7+\u6210\u672c\u4e2d\u5fc3\u201d\u5df2\u6709\u89c4\u5219\u5173\u8054\u4e86\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u3002", (String)"CostObjectRuleSaveOpValidator_6", (String)"macc-cad-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateRule(String rule, String value, ExtendedDataEntity dataEntity) {
        if (!StringUtils.equals((CharSequence)rule, (CharSequence)value)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6210\u672c\u6838\u7b97\u7ef4\u5ea6\u4e0e\u6210\u672c\u8ba1\u7b97\u65b9\u6cd5\u4e0d\u5339\u914d\u3002", (String)"CostObjectRuleSaveOpValidator_2", (String)"macc-cad-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateEnable(ExtendedDataEntity dataEntity, Map<String, ExtendedDataEntity> dataMap) {
        DynamicObject item = dataEntity.getDataEntity();
        if ((item = BusinessDataServiceHelper.loadSingle((Object)item.getPkValue(), (String)"cad_costobjectrule")).getBoolean("enable")) {
            return;
        }
        String errInfo = ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\u3002\u5f53\u524d\u201c\u6838\u7b97\u7ec4\u7ec7+\u6210\u672c\u4e2d\u5fc3+\u6210\u672c\u6838\u7b97\u7ef4\u5ea6\u201d\u5df2\u7ecf\u6709\u53ef\u7528\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"CostObjectRuleSaveOpValidator_3", (String)"macc-cad-opplugin", (Object[])new Object[0]);
        this.validateAuditAndEnable(dataEntity, item, dataMap, errInfo);
    }

    private void validateAudit(ExtendedDataEntity dataEntity, Map<String, ExtendedDataEntity> dataMap) {
        DynamicObject item = dataEntity.getDataEntity();
        if (!"B".equals((item = BusinessDataServiceHelper.loadSingle((Object)item.getPkValue(), (String)"cad_costobjectrule")).getString("status"))) {
            return;
        }
        String errInfo = ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25\uff0c\u5f53\u524d\u201c\u6838\u7b97\u7ec4\u7ec7+\u6210\u672c\u4e2d\u5fc3+\u6210\u672c\u6838\u7b97\u7ef4\u5ea6\u201d\u5df2\u7ecf\u6709\u5df2\u5ba1\u6838\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u3002", (String)"CostObjectRuleSaveOpValidator_4", (String)"macc-cad-opplugin", (Object[])new Object[0]);
        this.validateAuditAndEnable(dataEntity, item, dataMap, errInfo);
    }

    protected void validateAuditAndEnable(ExtendedDataEntity dataEntity, DynamicObject item, Map<String, ExtendedDataEntity> dataMap, String errInfo) {
        ExtendedDataEntity enabeDataEntity;
        DynamicObject costCenter = item.getDynamicObject("costcenter");
        DynamicObject acctOrg = item.getDynamicObject("accountorg");
        String key = acctOrg.getString("id");
        if (costCenter != null) {
            key = costCenter.getString("id") + acctOrg.getString("id");
        }
        if ((enabeDataEntity = dataMap.get(key)) != null) {
            this.addErrorMessage(dataEntity, errInfo);
            return;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("id", "!=", item.getPkValue()));
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)true));
        filters.add(new QFilter("accountorg", "=", acctOrg.getPkValue()));
        filters.add(new QFilter("costcenter", "=", costCenter == null ? Long.valueOf(0L) : costCenter.getPkValue()));
        filters.add(new QFilter("costcalcdimension", "=", (Object)item.getLong("costcalcdimension.id")));
        if (QueryServiceHelper.exists((String)"cad_costobjectrule", (QFilter[])filters.toArray(new QFilter[0]))) {
            this.addErrorMessage(dataEntity, errInfo);
        } else {
            dataMap.putIfAbsent(key, dataEntity);
        }
    }

    private void validateDisable(ExtendedDataEntity dataEntity) {
        DynamicObject item = dataEntity.getDataEntity();
        String status = (item = BusinessDataServiceHelper.loadSingle((Object)item.getPkValue(), (String)"cad_costobjectrule")).getString("status");
        if ("B".equals(status)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5ba1\u6838\u6570\u636e\u624d\u80fd\u7981\u7528\u3002", (String)"CostObjectRuleSaveOpValidator_7", (String)"macc-cad-opplugin", (Object[])new Object[0]));
        }
        this.validateRefCostObjects(dataEntity, "disable");
    }

    private void validateRepeat(ExtendedDataEntity dataEntity) {
        String number;
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        long org = dynamicObject.getLong("accountorg.id");
        long costCenter = dynamicObject.getLong("costcenter.id");
        long costDimenSion = dynamicObject.getLong("costcalcdimension.id");
        String ruleNumberExt = dynamicObject.getString("rulenumberext");
        QFilter filter = new QFilter("accountorg", "=", (Object)org);
        filter.and("costcalcdimension", "=", (Object)costDimenSion);
        if (ruleNumberExt == null) {
            filter.and("rulenumberext", "=", (Object)Character.valueOf(' '));
        } else {
            filter.and("rulenumberext", "=", (Object)ruleNumberExt);
        }
        filter.and("costcenter", "=", (Object)costCenter);
        DynamicObject result = QueryServiceHelper.queryOne((String)"cad_costobjectrule", (String)"number", (QFilter[])new QFilter[]{filter});
        if (result != null && !(number = result.getString("number")).equals(dynamicObject.getString("number"))) {
            String tips = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u89c4\u5219\u5df2\u5b58\u5728\u5f53\u524d\u201c\u6838\u7b97\u7ec4\u7ec7+\u6210\u672c\u4e2d\u5fc3+\u6210\u672c\u6838\u7b97\u7ef4\u5ea6\u201d\u7684\u76f8\u540c\u7ec4\u5408\uff0c\u8bf7\u8fdb\u884c\u4fee\u6539\u3002", (String)"CostObjectRuleSaveOpValidator_5", (String)"macc-cad-opplugin", (Object[])new Object[0]), number);
            this.addErrorMessage(dataEntity, tips);
        }
    }
}

