/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.costupdate;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CostUpdateOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("storagecostentry.stormaterial");
        fieldKeys.add("storagecostentry.oldcost");
        fieldKeys.add("storagecostentry.newcost");
        fieldKeys.add("acctentry.acctmaterial");
        fieldKeys.add("acctentry.acctoldcost");
        fieldKeys.add("acctentry.acctnewcost");
        fieldKeys.add("productentry.costobject");
        fieldKeys.add("productentry.productcost");
        fieldKeys.add("productentry.updatedcost");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                BigDecimal maxData = new BigDecimal("9999999999999.9999999999");
                String tip1 = ResManager.loadKDString((String)"\u201c\u5e93\u5b58\u6210\u672c\u4fe1\u606f\u201d\u9875\u7b7e\u7684\u7269\u6599\u7f16\u7801\u3010%1$s\u3011\u91d1\u989d%2$s\u5f02\u5e38\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8fdb\u884c\u6210\u672c\u66f4\u65b0\u3002", (String)"CostUpdateOpPlugin_18", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                String tip2 = ResManager.loadKDString((String)"\u201c\u751f\u4ea7\u6210\u672c\u4fe1\u606f\u201d\u9875\u7b7e\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7f16\u7801\u3010%1$s\u3011\u91d1\u989d%2$s\u5f02\u5e38\uff0c\u8bf7\u6838\u5b9e\u540e\u518d\u8fdb\u884c\u6210\u672c\u66f4\u65b0\u3002", (String)"CostUpdateOpPlugin_19", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    Object entry3;
                    DynamicObject dynamicObject = dataEntity.getDataEntity();
                    this.checkHeadData(dataEntity);
                    Boolean existDiff = Boolean.FALSE;
                    HashSet<Long> matIds = new HashSet<Long>(16);
                    DynamicObjectCollection costEntry = dynamicObject.getDynamicObjectCollection("costupdateentry");
                    for (DynamicObject entry2 : costEntry) {
                        matIds.add(entry2.getLong("material.id"));
                        if (!Boolean.FALSE.equals(existDiff) || BigDecimal.ZERO.compareTo(entry2.getBigDecimal("diffprice")) == 0) continue;
                        existDiff = Boolean.TRUE;
                    }
                    if (Boolean.FALSE.equals(existDiff)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u76f8\u5173\u7269\u6599\u6ca1\u6709\u53d1\u751f\u6807\u51c6\u6210\u672c\u7684\u53d8\u66f4\uff0c\u4e0d\u9700\u8981\u8fdb\u884c\u6807\u51c6\u6210\u672c\u66f4\u65b0\u3002", (String)"CostUpdateOpPlugin_2", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    Long targetCostTypeId = dynamicObject.getLong("targetcosttype.id");
                    Boolean isUpdateByPeriod = CostUpdateHelper.isUpdateByPeriod((Long)targetCostTypeId) && dynamicObject.getDynamicObject("effectperiod") != null;
                    if (Boolean.TRUE.equals(isUpdateByPeriod)) {
                        List periodIds;
                        DynamicObject period = dynamicObject.getDynamicObject("effectperiod");
                        String tip = this.enableUpdateTip(targetCostTypeId, period, costEntry);
                        if (!StringUtils.isEmpty((String)tip)) {
                            this.addErrorMessage(dataEntity, tip);
                            return;
                        }
                        Long srcCostTypeId = dynamicObject.getLong("srccosttype.id");
                        if (Boolean.FALSE.equals(CostUpdateHelper.isUpdateCurLevel((Long)srcCostTypeId, (Long)targetCostTypeId)) && !(periodIds = CostUpdateHelper.getPeriodIds((Long)targetCostTypeId)).isEmpty() && period != null && period.getLong("id") < (Long)periodIds.get(0)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\u3002\u4e0d\u80fd\u5bf9\u5f80\u671f\u7684\u6807\u51c6\u6210\u672c\u8fdb\u884c\u66f4\u65b0\u3002", (String)"CostUpdateOpPlugin_3", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                            return;
                        }
                        DynamicObjectCollection notUpdates = this.getNotUpdateByCalCostRecord(targetCostTypeId, period, matIds);
                        if (notUpdates != null) {
                            DynamicObject costType = dynamicObject.getDynamicObject("targetcosttype");
                            String costTypeMsg = String.format(ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\u3010%1$s/%2$s\u3011", (String)"CostUpdateOpPlugin_16", (String)"macc-cad-opplugin", (Object[])new Object[0]), costType.getString("number"), costType.getString("name"));
                            String materialMsg = ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s/%2$s\u201d\u672c\u671f\u5df2\u540c\u6b65\u4e86\u201c%3$s\u201d\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6210\u672c\u66f4\u65b0\u3002", (String)"CostUpdateOpPlugin_17", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                            for (DynamicObject notUpdate : notUpdates) {
                                StringBuilder sg = new StringBuilder(costTypeMsg);
                                sg.append(String.format(materialMsg, notUpdate.getString("number"), notUpdate.getString("name"), notUpdate.getString("billno")));
                                this.addErrorMessage(dataEntity, sg.toString());
                            }
                        }
                    }
                    DynamicObjectCollection storagecostentry = dynamicObject.getDynamicObjectCollection("storagecostentry");
                    for (Object entry3 : storagecostentry) {
                        BigDecimal newCost;
                        BigDecimal oldCost = entry3.getBigDecimal("oldcost");
                        if (oldCost.compareTo(maxData) > 0) {
                            this.addErrorMessage(dataEntity, String.format(tip1, entry3.getString("stormaterial.number"), oldCost));
                        }
                        if ((newCost = entry3.getBigDecimal("newcost")).compareTo(maxData) <= 0) continue;
                        this.addErrorMessage(dataEntity, String.format(tip1, entry3.getString("stormaterial.number"), newCost));
                    }
                    DynamicObjectCollection acctentry = dynamicObject.getDynamicObjectCollection("acctentry");
                    entry3 = acctentry.iterator();
                    while (entry3.hasNext()) {
                        BigDecimal acctnewcost;
                        DynamicObject entry4 = (DynamicObject)entry3.next();
                        BigDecimal acctoldcost = entry4.getBigDecimal("acctoldcost");
                        if (acctoldcost.compareTo(maxData) > 0) {
                            this.addErrorMessage(dataEntity, String.format(tip1, entry4.getString("acctmaterial.number"), acctoldcost));
                        }
                        if ((acctnewcost = entry4.getBigDecimal("acctnewcost")).compareTo(maxData) <= 0) continue;
                        this.addErrorMessage(dataEntity, String.format(tip1, entry4.getString("acctmaterial.number"), acctnewcost));
                    }
                    DynamicObjectCollection productentry = dynamicObject.getDynamicObjectCollection("productentry");
                    for (DynamicObject entry5 : productentry) {
                        BigDecimal updatedcost;
                        BigDecimal productcost = entry5.getBigDecimal("productcost");
                        if (productcost.compareTo(maxData) > 0) {
                            this.addErrorMessage(dataEntity, String.format(tip2, entry5.getString("costobject.billno"), productcost));
                        }
                        if ((updatedcost = entry5.getBigDecimal("updatedcost")).compareTo(maxData) <= 0) continue;
                        this.addErrorMessage(dataEntity, String.format(tip2, entry5.getString("costobject.billno"), updatedcost));
                    }
                }
            }

            private void checkHeadData(ExtendedDataEntity dataEntity) {
                DynamicObject costUpdateEstablishedBill = dataEntity.getDataEntity();
                Long targetCostTypeId = costUpdateEstablishedBill.getLong("targetcosttype.id");
                Date date = TimeServiceHelper.now();
                QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)targetCostTypeId), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
                DynamicObjectCollection costTypeOrg = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"costaccount.id id,costaccount.number number,costaccount.name name", (QFilter[])filters);
                if (costTypeOrg.isEmpty()) {
                    return;
                }
                HashMap<Long, String> accountInfos = new HashMap<Long, String>(10);
                for (DynamicObject cost : costTypeOrg) {
                    accountInfos.put(cost.getLong("id"), "[" + cost.getString("number") + "/" + cost.getString("name") + "]");
                }
                QFilter costaccountFilter = new QFilter("entryentity.costaccount", "in", accountInfos.keySet());
                QFilter isEnableFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
                DynamicObjectCollection startstdcosts = QueryServiceHelper.query((String)"sca_startstdcost", (String)"org.masterid orgid,entryentity.costaccount.id costaccountid", (QFilter[])new QFilter[]{costaccountFilter, isEnableFilter});
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)startstdcosts)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u5bf9\u5e94\u7684\u6210\u672c\u8d26\u7c3f\u672a\u542f\u7528\u6807\u51c6\u6210\u672c\u6838\u7b97\u3002", (String)"CostUpdateOpPlugin_6", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    return;
                }
                HashSet<Long> costAccountIds = new HashSet<Long>(10);
                QFilter mainFilter = null;
                for (DynamicObject startstdcost : startstdcosts) {
                    Long costAccountId = startstdcost.getLong("costaccountid");
                    costAccountIds.add(costAccountId);
                    QFilter itemFilter = new QFilter("org", "=", startstdcost.get("orgid"));
                    itemFilter.and(new QFilter("entry.costaccount", "=", (Object)costAccountId));
                    if (mainFilter == null) {
                        mainFilter = itemFilter;
                        continue;
                    }
                    mainFilter.or(itemFilter);
                }
                HashSet sysCtrlCostAccount = new HashSet(10);
                DynamicObjectCollection sysCtrlInfos = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"entry.costaccount.id costaccountid", (QFilter[])new QFilter[]{mainFilter});
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)sysCtrlInfos)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5728\u201c\u6838\u7b97\u671f\u95f4\u8bbe\u7f6e\u201d\u672a\u8bbe\u7f6e\u6216\u672a\u542f\u7528\u3002", (String)"CostUpdateOpPlugin_7", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    return;
                }
                sysCtrlInfos.forEach(p -> sysCtrlCostAccount.add(p.getLong("costaccountid")));
                String tip3 = ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6210\u672c\u8d26\u7c3f%s\u672a\u542f\u7528\u6807\u51c6\u6210\u672c\u6838\u7b97\u3002", (String)"CostUpdateOpPlugin_8", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                String tip4 = ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\u3002\u6210\u672c\u8d26\u7c3f%s\u5728\u201c\u6838\u7b97\u671f\u95f4\u8bbe\u7f6e\u201d\u672a\u8bbe\u7f6e\u6216\u672a\u542f\u7528\u3002", (String)"CostUpdateOpPlugin_9", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                for (Map.Entry entry : accountInfos.entrySet()) {
                    if (!costAccountIds.contains(entry.getKey())) {
                        this.addErrorMessage(dataEntity, String.format(tip3, entry.getValue()));
                    }
                    if (sysCtrlCostAccount.contains(entry.getKey())) continue;
                    this.addErrorMessage(dataEntity, String.format(tip4, entry.getValue()));
                }
            }

            private String enableUpdateTip(Long costTypeId, DynamicObject period, DynamicObjectCollection costEntrys) {
                HashSet matIds = new HashSet(16);
                costEntrys.forEach(p -> matIds.add(p.getLong("material.id")));
                if (matIds.isEmpty()) {
                    return ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\u3002\u6ca1\u6709\u5f85\u66f4\u65b0\u7269\u6599\uff0c\u4e0d\u53ef\u4ee5\u66f4\u65b0\u3002", (String)"CostUpdateOpPlugin_10", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                }
                if (period == null) {
                    return ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\u3002\u6309\u671f\u66f4\u65b0\uff0c\u65e0\u751f\u6548\u671f\u95f4\uff0c\u4e0d\u53ef\u4ee5\u66f4\u65b0\u3002", (String)"CostUpdateOpPlugin_11", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                }
                QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)costTypeId), new QFilter("material", "in", matIds), new QFilter("effectdate", ">", (Object)period.getDate("begindate"))};
                DynamicObjectCollection matCostInfos = QueryServiceHelper.query((String)"cad_matcostinfo", (String)"material.number,material.name", (QFilter[])filters);
                if (matCostInfos.isEmpty()) {
                    return null;
                }
                StringBuilder sg = new StringBuilder(ResManager.loadKDString((String)"\u66f4\u65b0\u5931\u8d25\u3002\u5f85\u66f4\u65b0\u7269\u6599\u4e2d\u7684", (String)"CostUpdateOpPlugin_12", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                for (DynamicObject matCostInfo : matCostInfos) {
                    sg.append(String.format("\u3010%s/%s\u3011", matCostInfo.getString("material.number"), matCostInfo.getString("material.name")));
                }
                sg.append(ResManager.loadKDString((String)"\u5b58\u5728\u5927\u4e8e\u751f\u6548\u671f\u95f4\u7684\u6807\u51c6\u6210\u672c\uff0c\u4e0d\u5141\u8bb8\u6309\u671f\u8fdb\u884c\u6807\u51c6\u6210\u672c\u66f4\u65b0\u3002", (String)"CostUpdateOpPlugin_13", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                return sg.toString();
            }

            private DynamicObjectCollection getNotUpdateByCalCostRecord(Long costTypeId, DynamicObject period, Set<Long> matIds) {
                if (period == null) {
                    return null;
                }
                Date[] dates = PeriodHelper.getPeriodStartAndEndTime((Long)Long.parseLong(period.getPkValue().toString()));
                if (dates == null || dates.length != 2) {
                    return null;
                }
                Date date = dates[0];
                QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)costTypeId), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
                DynamicObjectCollection costTypeOrgs = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg,costaccount,storageorgunit", (QFilter[])filters);
                QFilter filter = null;
                for (DynamicObject costTypeOrg : costTypeOrgs) {
                    QFilter f = new QFilter("calorg", "=", (Object)costTypeOrg.getLong("calorg"));
                    f.and("costaccount", "=", (Object)costTypeOrg.getLong("costaccount"));
                    if (costTypeOrg.get("storageorgunit") != null && costTypeOrg.getLong("storageorgunit") > 0L) {
                        f.and("storageorgunit", "=", (Object)costTypeOrg.getLong("storageorgunit"));
                    }
                    if (filter == null) {
                        filter = f;
                        continue;
                    }
                    filter.or(f);
                }
                if (filter == null) {
                    return null;
                }
                filters = new QFilter[]{filter, new QFilter("period", ">=", period.getPkValue()), new QFilter("entry.material", "in", matIds), new QFilter("billstatus", "=", (Object)"C"), new QFilter("entry.accounttype", "=", (Object)"D")};
                return QueryServiceHelper.query((String)"cal_costrecord", (String)"billno,entry.material.number number,entry.material.name name", (QFilter[])filters);
            }
        });
    }
}

