/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.costupdate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CostUpdateSaveOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CostUpdateSaveOpPlugin.class);
    private String[] fields = new String[]{"auxprop", "configuredcode", "tracknumber", "lot", "project"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("isspecifymaterial");
        fieldKeys.add("iscalccurlevel");
        fieldKeys.add("entryentity");
        fieldKeys.add("entryentity.material");
        fieldKeys.add("entryentity.matversion");
        fieldKeys.add("entryentity.auxprop");
        fieldKeys.add("entryentity.configuredcode");
        fieldKeys.add("entryentity.tracknumber");
        fieldKeys.add("entryentity.lot");
        fieldKeys.add("entryentity.project");
        fieldKeys.add("entryentity.matgrp");
        fieldKeys.add("srccosttype");
        fieldKeys.add("targetcosttype");
        fieldKeys.add("updatestatus");
        fieldKeys.add("effectperiod");
        fieldKeys.add("isallupdate");
        fieldKeys.add("period");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    List periodIds;
                    Long tarCostTypeId;
                    boolean isNotAllTrack;
                    boolean isDuplicate;
                    HashSet notUpdateBills;
                    boolean isBillDupli;
                    DynamicObject dynamicObject = dataEntity.getDataEntity();
                    DynamicObjectCollection materials = dynamicObject.getDynamicObjectCollection("entryentity");
                    if (dynamicObject.getBoolean("isspecifymaterial") && materials.isEmpty()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u6307\u5b9a\u7269\u6599\u66f4\u65b0\u201d\u5f00\u5173\u5df2\u6253\u5f00\uff0c\u8bf7\u81f3\u5c11\u5f55\u5165\u4e00\u884c\u7269\u6599\uff0c\u6216\u5173\u95ed\u5f00\u5173\u3002", (String)"CostUpdateSaveOpPlugin_0", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    }
                    if (isBillDupli = CostUpdateSaveOpPlugin.this.validateApplyBillDuplicate(dynamicObject, notUpdateBills = new HashSet(10))) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8be5\u76ee\u6807\u6210\u672c\u7c7b\u578b\u5df2\u5b58\u5728\u66f4\u65b0\u7533\u8bf7\u5355%s\u672a\u5b8c\u6210\u66f4\u65b0\uff0c\u4e0d\u80fd\u91cd\u590d\u7533\u8bf7\u3002", (String)"CostUpdateSaveOpPlugin_8", (String)"macc-cad-opplugin", (Object[])new Object[0]), SerializationUtils.toJsonString(notUpdateBills)));
                    }
                    if (isDuplicate = CostUpdateSaveOpPlugin.this.validateMatDuplicate(materials)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u6307\u5b9a\u7269\u6599\u201d\u5206\u5f55\u4e2d\uff0c\u201c\u7269\u6599\u201d\u3001\u201c\u8f85\u52a9\u5c5e\u6027\u201d\u3001\u201c\u914d\u7f6e\u53f7\u201d\u3001\u201c\u8ddf\u8e2a\u53f7\u201d\u7ec4\u5408\u5b58\u5728\u91cd\u590d\uff0c\u9700\u5220\u9664\u91cd\u590d\u884c\u518d\u4fdd\u5b58\u3002", (String)"CostUpdateSaveOpPlugin_6", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    }
                    if (isNotAllTrack = CostUpdateSaveOpPlugin.this.isNotAllTrack(materials)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u65e2\u5305\u542b\u6709\u8ddf\u8e2a\u53f7\u7684\u7269\u6599\uff0c\u53c8\u5305\u542b\u65e0\u8ddf\u8e2a\u53f7\u7684\u7269\u6599\u8fdb\u884c\u66f4\u65b0\u3002", (String)"CostUpdateSaveOpPlugin_7", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    }
                    boolean isTrackUpdate = CostUpdateSaveOpPlugin.this.isTrackUpdate(materials);
                    ArrayList<Long> costTypeIds = new ArrayList<Long>(1);
                    costTypeIds.add(dynamicObject.getLong("targetcosttype.id"));
                    Boolean isCostAccountMult = CostTypeHelper.costAccountIsExistMult(costTypeIds);
                    if (Boolean.TRUE.equals(isCostAccountMult)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u76ee\u6807\u6210\u672c\u7c7b\u578b\u5bf9\u5e94\u7684\u6210\u672c\u8d26\u7c3f\u5b58\u5728\u542f\u7528\u591a\u5de5\u5382\u548c\u672a\u542f\u7528\u591a\u5de5\u5382\u540c\u65f6\u5b58\u5728\u7684\u573a\u666f\u3002", (String)"CostUpdateSaveOpPlugin_3", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    }
                    for (int i = 0; i < materials.size(); ++i) {
                        if (((DynamicObject)materials.get(i)).getDynamicObject("material") != null || ((DynamicObject)materials.get(i)).getDynamicObject("matgrp") != null) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u7b2c%s\u884c\u8bf7\u9009\u62e9\u5177\u4f53\u7684\u7269\u6599\u6216\u7269\u6599\u5206\u7c7b\u3002", (String)"CostUpdateSaveOpPlugin_4", (String)"macc-cad-opplugin", (Object[])new Object[0]), i));
                    }
                    if (dynamicObject.getBoolean("isspecifymaterial") == dynamicObject.getBoolean("isallupdate")) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u201c\u6307\u5b9a\u7269\u6599\u66f4\u65b0\u201d\u4e0e\u201c\u5168\u91cf\u66f4\u65b0\u201d\u9700\u8981\u4e00\u4e2a\u5f00\u542f\uff0c\u8bf7\u68c0\u67e5\u6210\u672c\u53c2\u6570\u8bbe\u7f6e\u3002", (String)"CostUpdateSaveOpPlugin_5", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    }
                    if (CadEmptyUtils.isEmpty((Long)(tarCostTypeId = Long.valueOf(dynamicObject.getLong("targetcosttype.id"))))) continue;
                    String status = CostUpdateHelper.getIsUpdateByPeriod((Long)tarCostTypeId);
                    if (!Boolean.TRUE.toString().equals(status) || isTrackUpdate || CadEmptyUtils.isEmpty((List)(periodIds = CostUpdateHelper.getPeriodIds((Long)tarCostTypeId))) || periodIds.contains(dynamicObject.getLong("period.id"))) continue;
                    logger.info(String.format("\u539f\u671f\u95f4%s periodIds\uff1a%s ", dynamicObject.getLong("period.id"), periodIds));
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u201c\u751f\u6548\u671f\u95f4\u201d\u4e0e\u76ee\u6807\u6210\u672c\u7c7b\u578b\u5bf9\u5e94\u7684\u6210\u672c\u8d26\u7c3f\u671f\u95f4\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u201c\u751f\u6548\u671f\u95f4\u201d\u3002", (String)"CostUpdateSaveOpPlugin_9", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    private boolean isTrackUpdate(DynamicObjectCollection materials) {
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)materials)) {
            return false;
        }
        for (DynamicObject material : materials) {
            Long trackNumber = material.getLong("tracknumber.id");
            if (CadEmptyUtils.isEmpty((Long)trackNumber)) continue;
            return true;
        }
        return false;
    }

    private boolean isNotAllTrack(DynamicObjectCollection materials) {
        int size = materials.size();
        if (size == 0) {
            return false;
        }
        ArrayList<Long> trackIds = new ArrayList<Long>(size);
        for (DynamicObject material : materials) {
            Long trackNumber = material.getLong("tracknumber.id");
            if (CadEmptyUtils.isEmpty((Long)trackNumber)) continue;
            trackIds.add(trackNumber);
        }
        return !CadEmptyUtils.isEmpty(trackIds) && trackIds.size() != size;
    }

    private boolean validateMatDuplicate(DynamicObjectCollection materials) {
        if (!materials.isEmpty()) {
            HashSet<String> combineIds = new HashSet<String>();
            for (DynamicObject material : materials) {
                DynamicObject mat = material.getDynamicObject("material");
                DynamicObject dynamicObject = mat = mat != null ? mat : material.getDynamicObject("matgrp");
                if (CadEmptyUtils.isEmpty((DynamicObject)mat)) {
                    return false;
                }
                StringBuilder sg = new StringBuilder();
                sg.append(mat.getPkValue().toString());
                String[] stringArray = this.fields;
                int n = stringArray.length;
                block12: for (int i = 0; i < n; ++i) {
                    String field;
                    switch (field = stringArray[i]) {
                        case "auxprop": 
                        case "configuredcode": 
                        case "tracknumber": 
                        case "project": {
                            DynamicObject dy = material.getDynamicObject(field);
                            if (dy == null) continue block12;
                            sg.append(dy.getPkValue().toString());
                            continue block12;
                        }
                        case "lot": {
                            sg.append(material.getString(field));
                            continue block12;
                        }
                    }
                }
                combineIds.add(sg.toString());
            }
            return materials.size() != combineIds.size();
        }
        return false;
    }

    private boolean validateApplyBillDuplicate(DynamicObject updateApplyBill, Set<String> notUpdateBills) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "!=", updateApplyBill.get("id")), new QFilter("targetcosttype", "=", (Object)updateApplyBill.getLong("targetcosttype.id")), new QFilter("iscalccurlevel", "=", (Object)Boolean.FALSE), new QFilter("updatestatus", "=", (Object)Character.valueOf('N'))};
        if (QueryServiceHelper.exists((String)"cad_costupdatenew", (QFilter[])filters)) {
            if (notUpdateBills != null) {
                notUpdateBills.addAll(this.getNotUpdateBills(filters));
            }
            return true;
        }
        if (updateApplyBill.getBoolean("iscalccurlevel")) {
            DynamicObjectCollection entrys = updateApplyBill.getDynamicObjectCollection("entryentity");
            ArrayList<Object> keyColIds = new ArrayList<Object>(entrys.size());
            ArrayList matIds = new ArrayList(16);
            HashSet<Long> matGrpIds = new HashSet<Long>(16);
            HashMap<String, Object> values = new HashMap<String, Object>(7);
            for (DynamicObject entry : entrys) {
                Long matId = entry.getLong("material.id");
                Long matGrpId = entry.getLong("matgrp.id");
                if (!CadEmptyUtils.isEmpty((Long)matId)) {
                    values.clear();
                    values.put("material", entry.getLong("material.id"));
                    values.put("matvers", entry.getLong("matversion.id"));
                    values.put("auxproperty", entry.getLong("auxprop.id"));
                    values.put("project", entry.getLong("project.id"));
                    values.put("tracknumber", entry.getLong("tracknumber.id"));
                    values.put("configuredcode", entry.getLong("configuredcode.id"));
                    values.put("lot", entry.getString("lot"));
                    Long keyColId = CalcKeyHelper.getCalcKey(values, new ArrayList(), (boolean)Boolean.FALSE).getId();
                    if (CadEmptyUtils.isEmpty((Long)keyColId)) continue;
                    keyColIds.add(keyColId);
                    continue;
                }
                if (CadEmptyUtils.isEmpty((Long)matGrpId)) continue;
                matGrpIds.add(matGrpId);
            }
            if (!CadEmptyUtils.isEmpty(matGrpIds)) {
                filters = new QFilter[]{new QFilter("group.masterid", "in", matGrpIds)};
                DynamicObjectCollection matGroups = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"material", (QFilter[])filters);
                matGroups.forEach(p -> matIds.add(p.getLong("material")));
            }
            ArrayList<Long> existsKeyColIds = new ArrayList<Long>(16);
            ArrayList<Long> existsMatIds = new ArrayList<Long>(16);
            matGrpIds.clear();
            filters = new QFilter[]{new QFilter("id", "!=", updateApplyBill.get("id")), new QFilter("targetcosttype", "=", (Object)updateApplyBill.getLong("targetcosttype.id")), new QFilter("updatestatus", "=", (Object)Character.valueOf('N')), new QFilter("iscalccurlevel", "=", (Object)"1")};
            String selectFields = "entryentity.material material,entryentity.matversion matversion,entryentity.matgrp matgrp,entryentity.auxprop auxprop,entryentity.configuredcode configuredcode,entryentity.tracknumber tracknumber,entryentity.lot lot,entryentity.project project";
            DynamicObjectCollection datas = QueryServiceHelper.query((String)"cad_costupdatenew", (String)selectFields, (QFilter[])filters);
            for (DynamicObject dynamicObject : datas) {
                Long matId = dynamicObject.getLong("material");
                Long matGrpId = dynamicObject.getLong("matgrp");
                if (!CadEmptyUtils.isEmpty((Long)matId)) {
                    values.clear();
                    values.put("material", dynamicObject.getLong("material"));
                    values.put("matvers", dynamicObject.getLong("matversion"));
                    values.put("auxproperty", dynamicObject.getLong("auxprop"));
                    values.put("project", dynamicObject.getLong("project"));
                    values.put("tracknumber", dynamicObject.getLong("tracknumber"));
                    values.put("configuredcode", dynamicObject.getLong("configuredcode"));
                    values.put("lot", dynamicObject.getString("lot"));
                    Long keyColId = CalcKeyHelper.getCalcKey(values, new ArrayList(), (boolean)Boolean.FALSE).getId();
                    if (CadEmptyUtils.isEmpty((Long)keyColId)) continue;
                    existsKeyColIds.add(keyColId);
                    continue;
                }
                if (CadEmptyUtils.isEmpty((Long)matGrpId)) continue;
                matGrpIds.add(matGrpId);
            }
            if (!CadEmptyUtils.isEmpty(matGrpIds)) {
                filters = new QFilter[]{new QFilter("group.masterid", "in", matGrpIds)};
                DynamicObjectCollection matGroups = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"material", (QFilter[])filters);
                matGroups.forEach(p -> existsMatIds.add(p.getLong("material")));
            }
            for (Long l : keyColIds) {
                if (!existsKeyColIds.contains(l)) continue;
                if (notUpdateBills != null) {
                    notUpdateBills.addAll(this.getNotUpdateBills(updateApplyBill.getLong("id"), updateApplyBill.getLong("targetcosttype.id"), existsKeyColIds, existsMatIds));
                }
                return true;
            }
            for (Long l : matIds) {
                if (!existsMatIds.contains(l)) continue;
                if (notUpdateBills != null) {
                    QFilter filter = new QFilter("entryentity.material", "in", existsMatIds);
                    QFilter targetFilter = new QFilter("targetcosttype", "=", (Object)updateApplyBill.getLong("targetcosttype.id"));
                    QFilter statusFilter = new QFilter("updatestatus", "=", (Object)Character.valueOf('N'));
                    QFilter idFilter = new QFilter("id", "!=", updateApplyBill.get("id"));
                    notUpdateBills.addAll(this.getNotUpdateBills(new QFilter[]{filter, targetFilter, statusFilter, idFilter}));
                }
                return true;
            }
            return false;
        }
        QFilter targetFilter = new QFilter("targetcosttype", "=", (Object)updateApplyBill.getLong("targetcosttype.id"));
        QFilter statusFilter = new QFilter("updatestatus", "=", (Object)Character.valueOf('N'));
        QFilter idFilter = new QFilter("id", "!=", updateApplyBill.get("id"));
        if (QueryServiceHelper.exists((String)"cad_costupdatenew", (QFilter[])new QFilter[]{targetFilter, statusFilter, idFilter})) {
            if (notUpdateBills != null) {
                notUpdateBills.addAll(this.getNotUpdateBills(new QFilter[]{targetFilter, statusFilter, idFilter}));
            }
            return true;
        }
        return false;
    }

    private Set<String> getNotUpdateBills(QFilter[] filters) {
        DynamicObjectCollection costUpdates = QueryServiceHelper.query((String)"cad_costupdatenew", (String)"billno", (QFilter[])filters);
        HashSet<String> notUpdateBills = new HashSet<String>(10);
        for (DynamicObject costUpdate : costUpdates) {
            String billno = costUpdate.getString("billno");
            if (CadEmptyUtils.isEmpty((String)billno)) continue;
            notUpdateBills.add(billno);
        }
        return notUpdateBills;
    }

    private Set<String> getNotUpdateBills(Long id, Long costType, List<Long> existsKeyColIds, List<Long> existsMatIds) {
        QFilter targetFilter = new QFilter("targetcosttype", "=", (Object)costType);
        QFilter statusFilter = new QFilter("updatestatus", "=", (Object)Character.valueOf('N'));
        QFilter idFilter = new QFilter("id", "!=", (Object)id);
        DataSet costUpdates = QueryServiceHelper.queryDataSet((String)"getNotUpdateBills", (String)"cad_costupdatenew", (String)"billno,entryentity.material material,entryentity.auxprop auxprop,entryentity.configuredcode configuredcode,entryentity.tracknumber tracknumber,entryentity.lot lot,entryentity.project project", (QFilter[])new QFilter[]{targetFilter, statusFilter, idFilter}, null);
        DataSet keyColObjs = QueryServiceHelper.queryDataSet((String)"getNotUpdateBills", (String)"cad_keycol", (String)"material,matvers mversion,auxproperty assist,project,tracknumber,configuredcode,lot", (QFilter[])new QFilter[]{new QFilter("id", "in", existsKeyColIds)}, null);
        costUpdates = costUpdates.join(keyColObjs, JoinType.INNER).on("material", "material").on("auxprop", "assist").on("configuredcode", "configuredcode").on("tracknumber", "tracknumber").on("project", "project").on("lot", "lot").select(costUpdates.getRowMeta().getFieldNames()).finish();
        HashSet<String> notUpdateBills = new HashSet<String>(10);
        while (costUpdates.hasNext()) {
            Row row = costUpdates.next();
            String billno = row.getString("billno");
            if (CadEmptyUtils.isEmpty((String)billno)) continue;
            notUpdateBills.add(billno);
        }
        return notUpdateBills;
    }
}

