/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.feealloc;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostCloseAccountHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import org.apache.commons.lang.StringUtils;

public abstract class MfgAllocBaseValidator
extends AbstractValidator {
    Map<Long, Long> accCurPeriodMap = new HashMap<Long, Long>();
    Map<Long, Boolean> accEnableFactoryMap = new HashMap<Long, Boolean>();
    Map<String, Boolean> closeAccountMap = new HashMap<String, Boolean>();

    public void validate() {
        ExtendedDataEntity[] datas = this.dataEntities;
        if (!this.validateAll(datas)) {
            return;
        }
        for (int i = 0; i < datas.length; ++i) {
            ExtendedDataEntity dataEntity = datas[i];
            if (!this.validateCommon(dataEntity)) continue;
            this.validate(dataEntity);
        }
    }

    public boolean validateAll(ExtendedDataEntity[] datas) {
        return true;
    }

    public abstract void validate(ExtendedDataEntity var1);

    public boolean validateCommon(ExtendedDataEntity dataEntity) {
        String entityType = this.getEntityKey();
        Long costaccountId = dataEntity.getDataEntity().getLong("costaccount.id");
        Long orgId = dataEntity.getDataEntity().getLong("org.id");
        if (!this.isPlanMfg(entityType)) {
            Long curPeriodId = 0L;
            if (!this.accCurPeriodMap.containsKey(costaccountId)) {
                DynamicObject dyn = PeriodHelper.getCurrentPeriod((Long)costaccountId);
                if (dyn != null) {
                    curPeriodId = dyn.getLong("id");
                    this.accCurPeriodMap.put(costaccountId, dyn.getLong("id"));
                }
            } else {
                curPeriodId = this.accCurPeriodMap.get(costaccountId);
            }
            if (!curPeriodId.equals(dataEntity.getDataEntity().getLong("period.id")) && !entityType.equals("cad_plannonprodalloc")) {
                String tips = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u5bf9\u975e\u5f53\u524d\u671f\u95f4\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MfgAllocBaseValidator_0", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, tips);
                return false;
            }
            if (!this.accEnableFactoryMap.containsKey(costaccountId)) {
                Boolean enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)costaccountId);
                this.accEnableFactoryMap.put(costaccountId, enableMulFactory);
            }
            if (this.accEnableFactoryMap.get(costaccountId).booleanValue()) {
                Long manuorgId = dataEntity.getDataEntity().getLong("manuorg.id");
                String key = String.format("%s@%s@%s@%s", orgId, manuorgId, costaccountId, curPeriodId);
                if (!this.closeAccountMap.containsKey(key)) {
                    this.closeAccountMap.put(key, CostCloseAccountHelper.checkIsCloseAccount((Long)orgId, (Long)manuorgId, (Long)costaccountId, (Long)curPeriodId));
                }
                if (this.closeAccountMap.get(key).booleanValue()) {
                    String tips = ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\uff08%s\uff09+\u6210\u672c\u8d26\u7c3f+\u5f53\u524d\u671f\u95f4\u5df2\u5173\u8d26\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"MfgAllocBaseValidator_1", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, String.format(tips, dataEntity.getDataEntity().getString("manuorg.name")));
                    return false;
                }
            }
            String voucherNum = dataEntity.getDataEntity().getString("vouchernum");
            String operateKey = this.getOperateKey();
            if (StringUtils.isNotBlank((String)voucherNum) && "op_unconfirm".equals(operateKey)) {
                String tips = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5df2\u751f\u6210\u4e86\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u786e\u8ba4\u3002", (String)"MfgAllocBaseValidator_2", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, tips);
                return false;
            }
        } else {
            Long planSchemeId = dataEntity.getDataEntity().getLong("planscheme.id");
            String tips = PlanFeeAllocHelper.checkPeriodClosed((Long)planSchemeId, (Long)dataEntity.getDataEntity().getLong("period.id"));
            if (!CadEmptyUtils.isEmpty((String)tips)) {
                this.addErrorMessage(dataEntity, tips);
                return false;
            }
        }
        return true;
    }

    public boolean isPlanMfg(String entity) {
        return "cad_plannonprodalloc".equals(entity) || "cad_planauxprodalloc".equals(entity) || "cad_planbasicalloc".equals(entity) || "cad_planfeebill".equals(entity);
    }
}

