/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.feealloc;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.opplugin.feealloc.MfgAllocBaseValidator;

public class MfgInnerCsConfirmOpPlugin
extends AbstractOperationServicePlugIn {
    private Log logger = LogFactory.getLog(MfgInnerCsConfirmOpPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("benefcostcenter");
        fieldKeys.add("allocstatus");
        fieldKeys.add("org");
        fieldKeys.add("costaccount");
        fieldKeys.add("manuorg");
        fieldKeys.add("period");
        fieldKeys.add("billstatus");
        fieldKeys.add("vouchernum");
        fieldKeys.add("appnum");
        fieldKeys.add("entryentity.costobject");
        fieldKeys.add("auditdate");
        fieldKeys.add("auditor");
        fieldKeys.add("modifytime");
        fieldKeys.add("modifier");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new MfgAllocBaseValidator(){

            @Override
            public void validate(ExtendedDataEntity dataEntity) {
                DynamicObjectCollection entryEntity;
                DynamicObject data = dataEntity.getDataEntity();
                if (!ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue().equals(data.getString("allocstatus"))) {
                    String tips = ResManager.loadKDString((String)"\u5355\u636e\u5728\u5df2\u5206\u914d\u72b6\u6001\u624d\u53ef\u4ee5\u64cd\u4f5c\u786e\u8ba4\u3002", (String)"MfgInnerCsConfirmOpPlugin_0", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, tips);
                }
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)(entryEntity = data.getDynamicObjectCollection("entryentity")))) {
                    String tips = ResManager.loadKDString((String)"\u5355\u636e\u5206\u914d\u7ed3\u679c\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u786e\u8ba4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MfgInnerCsConfirmOpPlugin_2", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, tips);
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        Date curDate = new Date();
        Long curUserId = Long.parseLong(RequestContext.get().getUserId());
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(16);
        for (DynamicObject dyn : e.getDataEntities()) {
            dyn.set("allocstatus", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue());
            dyn.set("billstatus", (Object)"C");
            dyn.set("auditdate", (Object)curDate);
            dyn.set("auditor", (Object)curUserId);
            dyn.set("modifytime", (Object)curDate);
            dyn.set("modifier", (Object)curUserId);
            if (!"eca".equals(dyn.getString("appnum"))) continue;
            selectedRows.add(new ListSelectedRow(dyn.getPkValue()));
        }
        SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
        if (!selectedRows.isEmpty()) {
            this.pushCarryBill(selectedRows);
            this.logger.info("\u6210\u672c\u4e2d\u5fc3\u5185\u5206\u914d\u4e0b\u63a8\u6210\u672c\u7ed3\u8f6c\u5355\uff1a{}", (Object)selectedRows.size());
        }
    }

    private void pushCarryBill(List<ListSelectedRow> selectedRows) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("cad_mfgfeeallocco");
        pushArgs.setTargetEntityNumber("eca_costcarrybill");
        pushArgs.setHasRight(true);
        pushArgs.setBuildConvReport(true);
        pushArgs.setSelectedRows(selectedRows);
        try (TXHandle h = TX.required();){
            try {
                ConvertOperationResult pushResult = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
                if (!pushResult.isSuccess()) {
                    StringBuilder errMessage = this.pushErrorMsgHandle(pushResult);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u5931\u8d25\uff1a%s\u3002", (String)"MfgInnerCsConfirmOpPlugin_1", (String)"macc-cad-opplugin", (Object[])new Object[0]), errMessage.toString()));
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private StringBuilder pushErrorMsgHandle(ConvertOperationResult pushResult) {
        StringBuilder errMessage = new StringBuilder();
        errMessage.append(pushResult.getMessage());
        for (SourceBillReport billReport : pushResult.getBillReports()) {
            if (billReport.isSuccess()) continue;
            String billMessage = billReport.getFailMessage();
            this.logger.error("\u4e0b\u63a8\u6210\u672c\u7ed3\u8f6c\u5355\u5931\u8d25\uff1a{}", (Object)billMessage);
            errMessage.append(billMessage);
        }
        return errMessage;
    }
}

