/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.feealloc;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.opplugin.feealloc.MfgAllocBaseValidator;

public class MfgInnerCsUnConfirmOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("allocstatus");
        fieldKeys.add("org");
        fieldKeys.add("costaccount");
        fieldKeys.add("manuorg");
        fieldKeys.add("period");
        fieldKeys.add("billstatus");
        fieldKeys.add("vouchernum");
        fieldKeys.add("appnum");
        fieldKeys.add("modifytime");
        fieldKeys.add("modifier");
        fieldKeys.add("directalloc");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new MfgAllocBaseValidator(){

            @Override
            public void validate(ExtendedDataEntity dataEntity) {
                QFilter[] filters;
                String vouchernum;
                if (!ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue().equals(dataEntity.getDataEntity().getString("allocstatus"))) {
                    String tips = ResManager.loadKDString((String)"\u5355\u636e\u5728\u5df2\u786e\u8ba4\u72b6\u6001\u624d\u80fd\u64cd\u4f5c\u53cd\u786e\u8ba4\u3002", (String)"MfgInnerCsUnConfirmOpPlugin_0", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, tips);
                }
                if (StringUtils.isNotEmpty((CharSequence)(vouchernum = dataEntity.getDataEntity().getString("vouchernum"))) && !" ".equals(vouchernum)) {
                    String tips = ResManager.loadKDString((String)"\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u786e\u8ba4\u3002", (String)"MfgInnerCsUnConfirmOpPlugin_1", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, tips);
                }
                if ("eca".equals(dataEntity.getDataEntity().getString("appnum")) && QueryServiceHelper.exists((String)"eca_costcarrybill", (QFilter[])(filters = new QFilter[]{new QFilter("srcbillid", "=", dataEntity.getDataEntity().getPkValue()), new QFilter("billtype", "=", (Object)"cad_mfgfeeallocco"), new QFilter("vouchernum", "!=", (Object)" ")}))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0b\u6e38\u6210\u672c\u7ed3\u8f6c\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u786e\u8ba4\u3002", (String)"MfgInnerCsUnConfirmOpPlugin_2", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        Date curDate = TimeServiceHelper.now();
        Long curUserId = RequestContext.get().getCurrUserId();
        ArrayList<Object> ids = new ArrayList<Object>(16);
        for (DynamicObject dyn : e.getDataEntities()) {
            dyn.set("allocstatus", (Object)ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue());
            dyn.set("billstatus", (Object)"A");
            dyn.set("modifytime", (Object)curDate);
            dyn.set("modifier", (Object)curUserId);
            if (!"eca".equals(dyn.getString("appnum"))) continue;
            ids.add(dyn.getPkValue());
        }
        SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
        if (!ids.isEmpty()) {
            QFilter[] filters = new QFilter[]{new QFilter("srcbillid", "in", ids), new QFilter("billtype", "=", (Object)"cad_mfgfeeallocco"), new QFilter("vouchernum", "=", (Object)" ")};
            DeleteServiceHelper.delete((String)"eca_costcarrybill", (QFilter[])filters);
        }
    }
}

