/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.feealloc;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.business.feealloc.MfgFeeNonProdAllocService;
import kd.macc.cad.common.dto.MfgFeeAllocImportParam;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.opplugin.feealloc.MfgAllocBaseValidator;

public class MfgNonProdUnConfirmOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("allocstatus");
        fieldKeys.add("org");
        fieldKeys.add("costaccount");
        fieldKeys.add("manuorg");
        fieldKeys.add("period");
        fieldKeys.add("billstatus");
        fieldKeys.add("vouchernum");
        fieldKeys.add("modifytime");
        fieldKeys.add("modifier");
        fieldKeys.add("appnum");
        fieldKeys.add("planscheme");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new MfgAllocBaseValidator(){

            @Override
            public boolean validateAll(ExtendedDataEntity[] datas) {
                if (!this.isPlanMfg(this.getEntityKey())) {
                    DynamicObject[] billEntitys = new DynamicObject[datas.length];
                    for (int i = 0; i < datas.length; ++i) {
                        billEntitys[i] = datas[i].getDataEntity();
                    }
                    MfgFeeNonProdAllocService service = new MfgFeeNonProdAllocService();
                    List importDtos = MfgNonProdUnConfirmOpPlugin.this.getAllocImportDtos(billEntitys);
                    if (service.isBillGenVounums(importDtos, "cad_auxprodalloc") || service.isBillGenVounums(importDtos, "cad_basicalloc") || service.isBillGenVounums(importDtos, "cad_mfgfeeallocco")) {
                        String tip = ResManager.loadKDString((String)"\u4e0b\u6e38\u7684\u5206\u914d\u5355\u5df2\u7ecf\u751f\u6210\u4e86\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u786e\u8ba4\uff0c\u8bf7\u5220\u9664\u51ed\u8bc1\u540e\u518d\u64cd\u4f5c\u3002", (String)"MfgNonProdUnConfirmOpPlugin_0", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                        for (ExtendedDataEntity dataEntity : datas) {
                            this.addErrorMessage(dataEntity, tip);
                        }
                        return false;
                    }
                }
                return true;
            }

            @Override
            public void validate(ExtendedDataEntity dataEntity) {
                String vouchernum;
                if (!ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue().equals(dataEntity.getDataEntity().getString("allocstatus"))) {
                    String tips = ResManager.loadKDString((String)"\u5355\u636e\u5728\u5df2\u786e\u8ba4\u72b6\u6001\u624d\u80fd\u64cd\u4f5c\u53cd\u786e\u8ba4\u3002", (String)"MfgNonProdUnConfirmOpPlugin_1", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, tips);
                }
                if (!this.isPlanMfg(this.getEntityKey()) && StringUtils.isNotEmpty((CharSequence)(vouchernum = dataEntity.getDataEntity().getString("vouchernum"))) && !" ".equals(vouchernum)) {
                    String tips = ResManager.loadKDString((String)"\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u786e\u8ba4\u3002", (String)"MfgNonProdUnConfirmOpPlugin_2", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, tips);
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        Date curDate = new Date();
        Long curUserId = Long.parseLong(RequestContext.get().getUserId());
        for (DynamicObject dyn : e.getDataEntities()) {
            dyn.set("allocstatus", (Object)ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue());
            dyn.set("billstatus", (Object)"A");
            dyn.set("modifytime", (Object)curDate);
            dyn.set("modifier", (Object)curUserId);
        }
        this.deleteRelaBill(e.getDataEntities());
        SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
    }

    private List<MfgFeeAllocImportParam> getAllocImportDtos(DynamicObject[] billEntitys) {
        HashMap<String, MfgFeeAllocImportParam> dtpMap = new HashMap<String, MfgFeeAllocImportParam>(16);
        for (DynamicObject dyn : billEntitys) {
            String sourceEntityType = dyn.getDataEntityType().getName();
            Long orgId = dyn.getLong("org.id");
            Long costaccountId = dyn.getLong("costaccount.id");
            Long planschemeId = dyn.getLong("planscheme.id");
            Long periodId = dyn.getLong("period.id");
            String key = String.format("%s@%s@%s@%s", orgId, costaccountId, periodId, planschemeId);
            MfgFeeAllocImportParam dto = dtpMap.computeIfAbsent(key, t -> new MfgFeeAllocImportParam());
            dto.setEntityType(sourceEntityType);
            dto.setOrg(orgId);
            dto.setCostaccount(costaccountId);
            dto.setPeriod(periodId);
            dto.setAppnum(dyn.getString("appnum"));
            if (dto.getManuorg() == null) {
                dto.setManuorg(new ArrayList());
            }
            Long manuorg = dyn.getLong("manuorg.id");
            if (!dto.getManuorg().contains(manuorg)) {
                dto.getManuorg().add(manuorg);
            }
            dto.setEnableFactory(true);
            dto.setPlanscheme(planschemeId);
        }
        ArrayList<MfgFeeAllocImportParam> importDtos = new ArrayList<MfgFeeAllocImportParam>(dtpMap.values());
        for (MfgFeeAllocImportParam dto : importDtos) {
            boolean enableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)dto.getOrg());
            dto.setEnableFactory(enableMulFactory);
            if (!enableMulFactory) continue;
            dto.setCostCenterIds(OrgHelper.getCenterIdsByManuOrgIds((Long)dto.getOrg(), (List)dto.getManuorg(), (String)"sca"));
        }
        return importDtos;
    }

    private void deleteRelaBill(DynamicObject[] billEntitys) {
        List<MfgFeeAllocImportParam> importDtos = this.getAllocImportDtos(billEntitys);
        MfgFeeNonProdAllocService service = new MfgFeeNonProdAllocService();
        for (MfgFeeAllocImportParam importDto : importDtos) {
            service.deleteNonProdAndRelaBills(importDto, false);
        }
    }
}

