/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.resourcerate;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;

public class PlanCostDriverSaveOp
extends AbstractOperationServicePlugIn {
    private static final String COSTCENTER = "COSTCENTER";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("costaccount");
        fieldKeys.add("period");
        fieldKeys.add("entryentity");
        fieldKeys.add("benefcostcenter");
        fieldKeys.add("costcenter");
        fieldKeys.add("costobject");
        fieldKeys.add("costdriver");
        fieldKeys.add("entryqty");
        fieldKeys.add("manuorg");
        fieldKeys.add("appnum");
        fieldKeys.add("planscheme");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                HashSet<String> uniqueData = new HashSet<String>(10);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObjectCollection entryentity;
                    this.checkPeriodEnableClosed(dataEntity);
                    DynamicObject diyBill = dataEntity.getDataEntity();
                    long orgId = diyBill.getLong("org.id");
                    DynamicObject costdriver = diyBill.getDynamicObject("costdriver");
                    if (kd.macc.cad.common.utils.CadEmptyUtils.isEmpty((DynamicObject)costdriver)) {
                        return;
                    }
                    String allocClass = costdriver.getString("allocclass");
                    DynamicObject costcenter = diyBill.getDynamicObject("costcenter");
                    if (kd.macc.cad.common.utils.CadEmptyUtils.isEmpty((DynamicObject)costcenter)) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u8bf7\u586b\u5199\u201c\u6210\u672c\u4e2d\u5fc3\u201d", (String)"PlanCostDriverSaveOp_1", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    String costcentName = diyBill.getString("costcenter.name");
                    DynamicObject manuorg = diyBill.getDynamicObject("manuorg");
                    boolean isOrgEnableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
                    if (isOrgEnableMulFactory) {
                        if (kd.macc.cad.common.utils.CadEmptyUtils.isEmpty((DynamicObject)manuorg)) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff1a\u6838\u7b97\u7ec4\u7ec7\u5f00\u542f\u591a\u5de5\u5382\u6838\u7b97\u65f6\uff0c\u751f\u4ea7\u7ec4\u7ec7\u4e3a\u5fc5\u5f55\u3002", (String)"PlanCostDriverSaveOp_2", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                            return;
                        }
                        boolean isProduce = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"04");
                        List manuOrgIds = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)orgId, (boolean)isProduce);
                        if (kd.macc.cad.common.utils.CadEmptyUtils.isEmpty((List)manuOrgIds) || !manuOrgIds.contains(manuorg.getPkValue())) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff1a\u5f53\u524d\u751f\u4ea7\u7ec4\u7ec7\u4e0e\u6838\u7b97\u7ec4\u7ec7\u65e0\u5173\u8054\u5173\u7cfb\u3002", (String)"PlanCostDriverSaveOp_3", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                            return;
                        }
                    }
                    if ((entryentity = diyBill.getDynamicObjectCollection("entryentity")).size() == 0) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u81f3\u5c11\u7ef4\u62a4\u4e00\u6761\u660e\u7ec6\u4fe1\u606f\u3002", (String)"PlanCostDriverSaveOp_4", (String)"macc-cad-opplugin", (Object[])new Object[0]), costcentName));
                        return;
                    }
                    Long periodId = diyBill.getLong("period.id");
                    String key = String.format("%s@%s@%s", costcenter.getPkValue(), costdriver.getPkValue(), periodId);
                    if (uniqueData.contains(key)) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u3010%1$s\u3011 \u3010%2$s\u3011 \u5728\u3010%3$s\u3011\u6570\u503c\u5df2\u7ef4\u62a4\u3002", (String)"PlanCostDriverSaveOp_7", (String)"macc-cad-opplugin", (Object[])new Object[0]), diyBill.getString("costcenter.name"), diyBill.getString("costdriver.name"), diyBill.getString("period.name")));
                    } else {
                        uniqueData.add(key);
                    }
                    if (PlanCostDriverSaveOp.this.checkExists(diyBill)) {
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u3010%1$s\u3011 \u3010%2$s\u3011 \u5728\u3010%3$s\u3011\u6570\u503c\u5df2\u7ef4\u62a4\u3002", (String)"PlanCostDriverSaveOp_7", (String)"macc-cad-opplugin", (Object[])new Object[0]), diyBill.getString("costcenter.name"), diyBill.getString("costdriver.name"), diyBill.getString("period.name")));
                    }
                    HashSet<Long> benefcostcenterSet = new HashSet<Long>(16);
                    for (DynamicObject entry : entryentity) {
                        DynamicObject benefCostcenter = entry.getDynamicObject("benefcostcenter");
                        if (kd.macc.cad.common.utils.CadEmptyUtils.isEmpty((DynamicObject)benefCostcenter)) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff1a\u6210\u672c\u52a8\u56e0\u7684\u5206\u914d\u5c42\u7ea7\u4e3a\u6210\u672c\u4e2d\u5fc3\u6216\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u65f6\uff0c\u53d7\u76ca\u6210\u672c\u4e2d\u5fc3\u4e3a\u5fc5\u5f55\u3002", (String)"PlanCostDriverSaveOp_5", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                            return;
                        }
                        if (!PlanCostDriverSaveOp.COSTCENTER.equals(allocClass)) continue;
                        if (benefcostcenterSet.contains(benefCostcenter.getLong("id"))) {
                            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5206\u914d\u5c42\u7ea7\u4e3a\u6210\u672c\u4e2d\u5fc3\u65f6\uff0c\u660e\u7ec6\u4fe1\u606f\u4e2d\u53d7\u76ca\u6210\u672c\u4e2d\u5fc3\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PlanCostDriverSaveOp_6", (String)"macc-cad-opplugin", (Object[])new Object[0]), new Object[0]));
                            return;
                        }
                        benefcostcenterSet.add(benefCostcenter.getLong("id"));
                    }
                }
            }

            private void checkPeriodEnableClosed(ExtendedDataEntity dataEntity) {
                DynamicObject resourceBill = dataEntity.getDataEntity();
                Long schemeId = resourceBill.get("planscheme") instanceof DynamicObject ? Long.valueOf(resourceBill.getLong("planscheme.id")) : Long.valueOf(resourceBill.getLong("planscheme"));
                Long periodId = resourceBill.get("period") instanceof DynamicObject ? Long.valueOf(resourceBill.getLong("period.id")) : Long.valueOf(resourceBill.getLong("period"));
                if (kd.macc.cad.common.utils.CadEmptyUtils.isEmpty((Long)schemeId) || kd.macc.cad.common.utils.CadEmptyUtils.isEmpty((Long)periodId)) {
                    return;
                }
                String errorMsg = PlanFeeAllocHelper.checkPeriodClosed((Long)schemeId, (Long)periodId);
                if (!CadEmptyUtils.isEmpty((String)errorMsg)) {
                    this.addErrorMessage(dataEntity, errorMsg);
                }
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] datas;
        for (DynamicObject data : datas = e.getDataEntities()) {
            boolean isOrgEnableMulFactory = OrgHelper.isOrgEnableMultiFactory((Long)data.getLong("org.id"));
            if (isOrgEnableMulFactory) continue;
            data.set("manuorg", null);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] datas;
        for (DynamicObject data : datas = e.getDataEntities()) {
            Object id = data.getPkValue();
            this.setEntity(id);
        }
    }

    private void setEntity(Object id) {
        HashSet<Object> fids = new HashSet<Object>();
        fids.add(id);
        Object[] diyCostdBill = BusinessDataServiceHelper.load((Object[])fids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_plancostdriver"));
        if (kd.macc.cad.common.utils.CadEmptyUtils.isEmpty((Object[])diyCostdBill)) {
            return;
        }
        DynamicObject costdriver = diyCostdBill[0].getDynamicObject("costdriver");
        diyCostdBill[0].set("costbaseunit", (Object)costdriver.getLong("unit.id"));
        DynamicObjectCollection entryentitys = diyCostdBill[0].getDynamicObjectCollection("entryentity");
        if (kd.macc.cad.common.utils.CadEmptyUtils.isEmpty((List)entryentitys)) {
            return;
        }
        BigDecimal sum = new BigDecimal(0);
        for (DynamicObject entry : entryentitys) {
            BigDecimal entryQty = entry.getBigDecimal("entryqty");
            sum = sum.add(entryQty);
        }
        diyCostdBill[0].set("qty", (Object)sum);
        SaveServiceHelper.update((DynamicObject[])diyCostdBill);
    }

    private boolean checkExists(DynamicObject dataEntity) {
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        DynamicObject costDriver = dataEntity.getDynamicObject("costdriver");
        DynamicObject period = dataEntity.getDynamicObject("period");
        DynamicObject costCenter = dataEntity.getDynamicObject("costcenter");
        DynamicObject planscheme = dataEntity.getDynamicObject("planscheme");
        QFilter[] filters = new QFilter[]{new QFilter("id", "!=", dataEntity.getPkValue()), new QFilter("org", "=", org.getPkValue()), new QFilter("costaccount", "=", costAccount.getPkValue()), new QFilter("period", "=", period == null ? Long.valueOf(0L) : period.getPkValue()), new QFilter("costcenter", "=", costCenter == null ? Long.valueOf(0L) : costCenter.getPkValue()), new QFilter("costdriver", "=", costDriver.getPkValue()), new QFilter("planscheme", "=", planscheme == null ? Long.valueOf(0L) : planscheme.getPkValue())};
        return QueryServiceHelper.exists((String)"cad_plancostdriver", (QFilter[])filters);
    }
}

