/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.resourcerate;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PlanFeeDelOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("currency");
        fieldKeys.add("expenseitem");
        fieldKeys.add("costaccount");
        fieldKeys.add("period");
        fieldKeys.add("amount");
        fieldKeys.add("srcsys");
        fieldKeys.add("costcenter");
        fieldKeys.add("allocmold");
        fieldKeys.add("manuorg");
        fieldKeys.add("seq");
        fieldKeys.add("planscheme");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    this.checkPeriodClosed(dataEntity);
                    this.checkExistAllocated(dataEntity);
                }
            }

            private void checkExistAllocated(ExtendedDataEntity dataEntity) {
                String tip = ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u8ba1\u5212\u8d39\u7528\u5206\u914d\u5df2\u5f15\u7528\u6b64\u5355", (String)"PlanFeeDelOp_0", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                DynamicObject planFee = dataEntity.getDataEntity();
                DynamicObject delPeriod = planFee.getDynamicObject("period");
                DynamicObject costAccount = planFee.getDynamicObject("costaccount");
                DynamicObject costCenter = planFee.getDynamicObject("costcenter");
                QFilter qFilter = new QFilter("costaccount", "=", (Object)costAccount.getLong("id"));
                qFilter.and("period", "=", (Object)delPeriod.getLong("id"));
                qFilter.and("allocstatus", "=", (Object)"1");
                qFilter.and("costcenter", "=", (Object)(costCenter == null ? 0L : costCenter.getLong("id")));
                boolean existAllocated = QueryServiceHelper.exists((String)"cad_planbasicalloc", (QFilter[])qFilter.toArray());
                if (existAllocated) {
                    this.addErrorMessage(dataEntity, tip);
                }
            }

            private void checkPeriodClosed(ExtendedDataEntity dataEntity) {
                DynamicObject delPeriod;
                DynamicObject entity = dataEntity.getDataEntity();
                DynamicObject scheme = entity.getDynamicObject("planscheme");
                Long schemeId = scheme.getLong("id");
                String errorMsg = PlanFeeAllocHelper.checkPeriodClosed((Long)schemeId, (Long)(delPeriod = entity.getDynamicObject("period")).getLong("id"));
                if (!CadEmptyUtils.isEmpty((String)errorMsg)) {
                    this.addErrorMessage(dataEntity, errorMsg);
                }
            }
        });
        super.onAddValidators(e);
    }
}

