/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.resourcerate;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PlanPeriodControlSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("costaccount");
        fieldKeys.add("startperiod");
        fieldKeys.add("endperiod");
        fieldKeys.add("enable");
        fieldKeys.add("close");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                this.checkUnique();
            }

            private void checkUnique() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject bill = dataEntity.getDataEntity();
                    DynamicObjectCollection rows = bill.getDynamicObjectCollection("entryentity");
                    if (CadEmptyUtils.isEmpty((DynamicObjectCollection)rows)) {
                        String error = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u5f55\u3002", (String)"PlanPeriodControlSaveOp_0", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                        this.addFatalErrorMessage(dataEntity, error);
                        return;
                    }
                    Long id = bill.getLong("id");
                    if (id != 0L) continue;
                    DynamicObject org = bill.getDynamicObject("org");
                    DynamicObject costAccount = bill.getDynamicObject("costaccount");
                    if (org == null || costAccount == null) continue;
                    QFilter qFilter = new QFilter("org", "=", (Object)org.getLong("id"));
                    qFilter.and(new QFilter("costaccount", "=", (Object)costAccount.getLong("id")));
                    boolean exist = QueryServiceHelper.exists((String)"cad_planperiod", (QFilter[])qFilter.toArray());
                    if (!exist) continue;
                    String error = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u5df2\u5b58\u5728\u3010%1$s\u3011+\u3010%2$s\u3011\u7684\u8ba1\u5212\u671f\u95f4\u8bbe\u7f6e\u6570\u636e\u3002", (String)"PlanPeriodControlSaveOp_1", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                    this.addFatalErrorMessage(dataEntity, String.format(error, org.getString("name"), costAccount.getString("name")));
                    return;
                }
            }
        });
        super.onAddValidators(e);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
    }
}

