/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.resourcerate;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;

public class PlanResourceSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("manuorg");
        fieldKeys.add("sourcetype");
        fieldKeys.add("planscheme");
        fieldKeys.add("resourceunit");
        fieldKeys.add("period");
        fieldKeys.add("srcbillid");
        fieldKeys.add("appnum");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    String appNum;
                    Long accountorg;
                    List manuorgList;
                    DynamicObject resouceBill = dataEntity.getDataEntity();
                    this.checkPeriodEnableClosed(dataEntity);
                    String sourcetype = dataEntity.getDataEntity().getString("sourcetype");
                    Long manuorgId = resouceBill.get("manuorg") instanceof DynamicObject ? Long.valueOf(resouceBill.getLong("manuorg.id")) : Long.valueOf(resouceBill.getLong("manuorg"));
                    Long srcMuId = resouceBill.get("resourceunit") instanceof DynamicObject ? Long.valueOf(resouceBill.getLong("resourceunit.id")) : Long.valueOf(resouceBill.getLong("resourceunit"));
                    Long desMuId = 9L;
                    if (!PlanResourceSaveOp.this.checkUnitConvert(srcMuId, desMuId)) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u672a\u627e\u5230\u5de5\u65f6\u5355\u4f4d\u7684\u8f6c\u6362\u5173\u7cfb.", (String)"PlanResourceSaveOp_1", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    }
                    if (!"EXCEL".equalsIgnoreCase(sourcetype) || CadEmptyUtils.isEmpty((Long)manuorgId) || (manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)(accountorg = (Long)resouceBill.getDynamicObject("org").getPkValue()), (String)"cad_planresource", (String)(appNum = dataEntity.getDataEntity().getString("appnum")))) != null && manuorgList.contains(manuorgId)) continue;
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u751f\u4ea7\u7ec4\u7ec7\u4e0e\u6838\u7b97\u7ec4\u7ec7\u6ca1\u6709\u59d4\u6258\u5173\u7cfb\uff0c\u4e0d\u80fd\u5f15\u5165", (String)"PlanResourceSaveOp_0", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                }
            }

            private void checkPeriodEnableClosed(ExtendedDataEntity dataEntity) {
                DynamicObject resourceBill = dataEntity.getDataEntity();
                Long schemeId = resourceBill.get("planscheme") instanceof DynamicObject ? Long.valueOf(resourceBill.getLong("planscheme.id")) : Long.valueOf(resourceBill.getLong("planscheme"));
                Long periodId = resourceBill.get("period") instanceof DynamicObject ? Long.valueOf(resourceBill.getLong("period.id")) : Long.valueOf(resourceBill.getLong("period"));
                if (CadEmptyUtils.isEmpty((Long)schemeId) || CadEmptyUtils.isEmpty((Long)periodId)) {
                    return;
                }
                String errorMsg = PlanFeeAllocHelper.checkPeriodClosed((Long)schemeId, (Long)periodId);
                if (!CadEmptyUtils.isEmpty((String)errorMsg)) {
                    this.addErrorMessage(dataEntity, errorMsg);
                }
            }
        });
    }

    private boolean checkUnitConvert(Long srcMuId, Long desMuId) {
        if (srcMuId == 8L || srcMuId == 9L || srcMuId == 10L) {
            return true;
        }
        QFilter srcMuIdFilter = new QFilter("srcmuid", "=", (Object)srcMuId);
        QFilter desMuIdFilter = new QFilter("desmuid", "=", (Object)desMuId);
        DynamicObject measureUnitObj = QueryServiceHelper.queryOne((String)"bd_measureunitconv", (String)"denominator, numerator, desmuid", (QFilter[])new QFilter[]{srcMuIdFilter, desMuIdFilter});
        if (measureUnitObj == null) {
            srcMuIdFilter = new QFilter("srcmuid", "=", (Object)desMuId);
            desMuIdFilter = new QFilter("desmuid", "=", (Object)srcMuId);
            measureUnitObj = QueryServiceHelper.queryOne((String)"bd_measureunitconv", (String)"denominator, numerator, desmuid", (QFilter[])new QFilter[]{srcMuIdFilter, desMuIdFilter});
        }
        return measureUnitObj != null;
    }
}

