/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.resourcerate;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.PeriodHelper;

public class PlanSchemeDelOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("name");
        fieldKeys.add("org");
        fieldKeys.add("costaccount");
        fieldKeys.add("entryentity");
        fieldKeys.add("entryentity.startperiod");
        fieldKeys.add("entryentity.endperiod");
        fieldKeys.add("entryentity.enabled");
        fieldKeys.add("entryentity.close");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    this.checkExistBizData(dataEntity);
                }
            }

            private void checkExistBizData(ExtendedDataEntity dataEntity) {
                String tip = "";
                DynamicObject planScheme = dataEntity.getDataEntity();
                DynamicObjectCollection entryEntity = planScheme.getDynamicObjectCollection("entryentity");
                String schemeNumber = planScheme.getString("number");
                String schemeName = planScheme.getString("name");
                long schemeId = planScheme.getLong("id");
                DynamicObject org = planScheme.getDynamicObject("org");
                DynamicObject costAccount = planScheme.getDynamicObject("costaccount");
                boolean cancel = false;
                for (DynamicObject dynamicObject : entryEntity) {
                    String enable = dynamicObject.getString("enabled");
                    if (enable.equals("1")) {
                        tip = String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u65b9\u6848\u3010%s\u3011\u4e2d\u5b58\u5728\u5df2\u542f\u7528\u7684\u6838\u7b97\u671f\u95f4", (String)"PlanSchemeDelOp_0", (String)"macc-cad-opplugin", (Object[])new Object[0]), schemeName);
                        cancel = true;
                        break;
                    }
                    QFilter qFilter = new QFilter("org", "=", (Object)org.getLong("id"));
                    qFilter.and(new QFilter("costaccount", "=", (Object)costAccount.getLong("id")));
                    DynamicObject startPeriod = dynamicObject.getDynamicObject("startperiod");
                    DynamicObject endPeriod = dynamicObject.getDynamicObject("endperiod");
                    List periodIds = PeriodHelper.getStart2EndAllPeriodIds((DynamicObject)startPeriod, (DynamicObject)endPeriod);
                    qFilter.and(new QFilter("period", "in", (Object)periodIds));
                    qFilter.and(new QFilter("planscheme", "=", (Object)schemeId));
                    boolean existPlanFee = QueryServiceHelper.exists((String)"cad_planfeebill", (QFilter[])qFilter.toArray());
                    boolean existPlanResource = QueryServiceHelper.exists((String)"cad_planresource", (QFilter[])qFilter.toArray());
                    boolean existPlanWork = QueryServiceHelper.exists((String)"cad_planwork", (QFilter[])qFilter.toArray());
                    boolean existPlanCostDriver = QueryServiceHelper.exists((String)"cad_plancostdriver", (QFilter[])qFilter.toArray());
                    if (!existPlanFee && !existPlanResource && !existPlanWork && !existPlanCostDriver) continue;
                    tip = String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u201c%1$s/%2$s\u201d\u8ba1\u5212\u65b9\u6848\u5df2\u88ab\u8ba1\u5212\u5355\u636e\u5f15\u7528\u3002", (String)"PlanSchemeDelOp_1", (String)"macc-cad-opplugin", (Object[])new Object[0]), schemeNumber, schemeName);
                    cancel = true;
                    break;
                }
                if (cancel) {
                    this.addErrorMessage(dataEntity, tip);
                }
            }
        });
        super.onAddValidators(e);
    }
}

