/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.resourcerate;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PlanSchemeSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("name");
        fieldKeys.add("org");
        fieldKeys.add("costaccount");
        fieldKeys.add("mulcalcrule");
        fieldKeys.add("entryentity");
        fieldKeys.add("entryentity.startperiod");
        fieldKeys.add("entryentity.endperiod");
        fieldKeys.add("entryentity.enabled");
        fieldKeys.add("entryentity.close");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
                }
            }

            private void checkUniqueCalcRule(ExtendedDataEntity dataEntity) {
                DynamicObject planScheme = dataEntity.getDataEntity();
                Long id = planScheme.getLong("id");
                DynamicObject org = planScheme.getDynamicObject("org");
                DynamicObject costAccount = planScheme.getDynamicObject("costaccount");
                DynamicObjectCollection mulCalcRule = planScheme.getDynamicObjectCollection("mulcalcrule");
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)mulCalcRule)) {
                    List ruleIds = mulCalcRule.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
                    QFilter qFilter = new QFilter("org", "=", (Object)org.getLong("id"));
                    qFilter.and(new QFilter("costaccount", "=", (Object)costAccount.getLong("id")));
                    qFilter.and(new QFilter("enable", "=", (Object)true));
                    qFilter.and(new QFilter("id", "!=", (Object)id));
                    qFilter.and(new QFilter("mulcalcrule.fbasedataid", "in", ruleIds));
                    DynamicObject existCalcRule = QueryServiceHelper.queryOne((String)"cad_planscheme", (String)"id,number,name,mulcalcrule.fbasedataid ruleid", (QFilter[])qFilter.toArray());
                    if (existCalcRule != null) {
                        String schemeNumber = existCalcRule.getString("number");
                        String schemeName = existCalcRule.getString("name");
                        String tip = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5377\u7b97\u53d6\u4ef7\u89c4\u5219\u5df2\u5206\u914d\u7ed9\u6b64\u6838\u7b97\u7ec4\u7ec7+\u6210\u672c\u8d26\u8584\u4e0b\u7684\u3010%1$s\u3011+\u3010%2$s\u3011\u4e86\u3002", (String)"PlanSchemeSaveOp_0", (String)"macc-cad-opplugin", (Object[])new Object[0]), schemeNumber, schemeName);
                        this.addErrorMessage(dataEntity, tip);
                    }
                }
            }
        });
    }
}

