/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.resourcerate;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PlanWorkDelOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("costaccount");
        fieldKeys.add("period");
        fieldKeys.add("planscheme");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    this.checkPeriodClosed(dataEntity);
                }
            }

            private void checkPeriodClosed(ExtendedDataEntity dataEntity) {
                DynamicObject delPeriod;
                DynamicObject entity = dataEntity.getDataEntity();
                DynamicObject scheme = entity.getDynamicObject("planscheme");
                Long schemeId = scheme.getLong("id");
                String errorMsg = PlanFeeAllocHelper.checkPeriodClosed((Long)schemeId, (Long)(delPeriod = entity.getDynamicObject("period")).getLong("id"));
                if (!CadEmptyUtils.isEmpty((String)errorMsg)) {
                    this.addErrorMessage(dataEntity, errorMsg);
                }
            }
        });
        super.onAddValidators(e);
    }
}

