/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.resourcerate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PlanWorkImportOp
extends BatchImportPlugin {
    private Log log = LogFactory.getLog(PlanWorkImportOp.class);

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        Iterator<ImportBillData> iterator = billdatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData billData = iterator.next();
            if (!this.validateData(billData, logger)) {
                iterator.remove();
                logger.setFailed(logger.getFailed() + 1);
                continue;
            }
            JSONObject data = billData.getData();
            JSONObject org = (JSONObject)data.get((Object)"org");
            JSONObject costaccount = (JSONObject)data.get((Object)"costaccount");
            JSONObject period = (JSONObject)data.get((Object)"period");
            period.replace((Object)"importprop", (Object)"number", (Object)"id");
            Long periodId = this.getPeriodId(org, costaccount, period);
            period.put("id", (Object)periodId);
            Date[] date = PeriodHelper.getPeriodStartAndEndTime((Long)periodId);
            data.put("bizdate", (Object)date[1]);
            JSONArray entryEntity = data.getJSONArray("entryentity");
            BigDecimal total = BigDecimal.ZERO;
            for (int i = 0; i < entryEntity.size(); ++i) {
                JSONObject jsonObject = entryEntity.getJSONObject(i);
                total = total.add(jsonObject.getBigDecimal("entryqty"));
            }
            data.put("qty", (Object)total);
        }
    }

    private boolean validateData(ImportBillData billData, ImportLogger logger) {
        boolean checkFlag = true;
        int index = billData.getStartIndex();
        JSONObject rowData = billData.getData();
        try {
            if (!this.checkUnExistInDB(index, rowData, logger)) {
                return false;
            }
            if (!this.checkOrg(index, rowData, logger)) {
                return false;
            }
            if (!this.checkPeriod(index, rowData, logger)) {
                return false;
            }
            if (!this.checkOrgCostAccount(index, rowData, logger)) {
                checkFlag = false;
            }
            if (!this.checkOrgCostCenter(index, rowData, logger)) {
                checkFlag = false;
            }
            if (!this.checkManuOrgCostCenter(index, rowData, logger)) {
                return false;
            }
            if (!this.checkCostAccountScheme(index, rowData, logger)) {
                checkFlag = false;
            }
            if (!this.checkWorkCostDriver(index, rowData, logger)) {
                checkFlag = false;
            }
        }
        catch (Exception e) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u6570\u636e\u89e3\u6790\u5f02\u5e38\u3002", (String)"PlanWorkImportOp_0", (String)"macc-cad-opplugin", (Object[])new Object[0]));
            this.log.error("\u5f15\u5165\u5931\u8d25\u3002\u6570\u636e\u89e3\u6790\u5f02\u5e38", (Throwable)e);
            checkFlag = false;
        }
        return checkFlag;
    }

    private boolean checkUnExistInDB(int index, JSONObject rowData, ImportLogger logger) {
        Map orgMap = (Map)rowData.get((Object)"org");
        String orgNumber = orgMap.get("number").toString();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number,name,fisaccounting", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber)});
        if (org == null) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u7f16\u7801:\u3010%s\u3011\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e", (String)"PlanWorkImportOp_13", (String)"macc-cad-opplugin", (Object[])new Object[0]), orgNumber));
            return false;
        }
        Map costAccountMap = (Map)rowData.get((Object)"costaccount");
        String costAccountNumber = costAccountMap.get("number").toString();
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costaccount", (String)"id,calpolicy.currency", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)costAccountNumber)});
        if (costAccount == null) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u7f16\u7801:\u3010%s\u3011\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e", (String)"PlanWorkImportOp_14", (String)"macc-cad-opplugin", (Object[])new Object[0]), costAccountNumber));
            return false;
        }
        Boolean orgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
        if (orgEnableMultiFactory.booleanValue()) {
            if (rowData.get((Object)"manuorg") == null) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u7f16\u7801\u672a\u586b\u5165", (String)"PlanWorkImportOp_4", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                return false;
            }
            Map manuOrgMap = (Map)rowData.get((Object)"manuorg");
            String manuOrgNumber = manuOrgMap.get("number").toString();
            DynamicObject manuOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)manuOrgNumber)});
            if (manuOrg == null) {
                logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u7f16\u7801:\u3010%s\u3011\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e", (String)"PlanWorkImportOp_15", (String)"macc-cad-opplugin", (Object[])new Object[0]), costAccountNumber));
                return false;
            }
        } else if (rowData.get((Object)"manuorg") != null) {
            String tip = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u3010%s\u3011\u672a\u5f00\u542f\u591a\u5de5\u5382\uff0c\u8bf7\u52ff\u586b\u5199\u751f\u4ea7\u7ec4\u7ec7", (String)"PlanWorkImportOp_5", (String)"macc-cad-opplugin", (Object[])new Object[0]), org.getString("name"));
            logger.log(Integer.valueOf(index), tip);
            return false;
        }
        Map costCenterMap = (Map)rowData.get((Object)"costcenter");
        String costCenterNumber = costCenterMap.get("number").toString();
        DynamicObject costCenter = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_costcenter", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)costCenterNumber)});
        if (costCenter == null) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u7f16\u7801:\u3010%s\u3011\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e", (String)"PlanWorkImportOp_16", (String)"macc-cad-opplugin", (Object[])new Object[0]), costCenterNumber));
            return false;
        }
        Map planSchemeMap = (Map)rowData.get((Object)"planscheme");
        String planSchemeNumber = planSchemeMap.get("number").toString();
        DynamicObject planScheme = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_planscheme", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)planSchemeNumber)});
        if (planScheme == null) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u65b9\u6848\u7f16\u7801:\u3010%s\u3011\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e", (String)"PlanWorkImportOp_17", (String)"macc-cad-opplugin", (Object[])new Object[0]), costCenterNumber));
            return false;
        }
        Map workActivityMap = (Map)rowData.get((Object)"workactivity");
        String workActivityNumber = workActivityMap.get("number").toString();
        DynamicObject workActivity = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_new_workactivity", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)workActivityNumber)});
        if (workActivity == null) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u4f5c\u4e1a\u6d3b\u52a8\u7f16\u7801:\u3010%s\u3011\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e", (String)"PlanWorkImportOp_18", (String)"macc-cad-opplugin", (Object[])new Object[0]), workActivityNumber));
            return false;
        }
        return true;
    }

    private boolean checkOrg(int index, JSONObject rowData, ImportLogger logger) {
        Map orgMap = (Map)rowData.get((Object)"org");
        String orgNumber = orgMap.get("number").toString();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number,name,fisaccounting", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber)});
        Long orgId = org.getLong("id");
        List acctOrgs = OrgHelper.getHasPermAccountOrgIds((String)"cad_planwork", (String)"sca");
        if (CadEmptyUtils.isEmpty((List)acctOrgs)) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u6237\u6ca1\u6709\u6838\u7b97\u7ec4\u7ec7\u3010%s\u3011\u6743\u9650", (String)"PlanWorkImportOp_7", (String)"macc-cad-opplugin", (Object[])new Object[0]), org.getString("name")));
            return false;
        }
        if (!acctOrgs.contains(orgId)) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u6237\u6ca1\u6709\u6838\u7b97\u7ec4\u7ec7\u3010%s\u3011\u6743\u9650", (String)"PlanWorkImportOp_7", (String)"macc-cad-opplugin", (Object[])new Object[0]), org.getString("name")));
            return false;
        }
        return true;
    }

    private boolean checkManuOrgCostCenter(int index, JSONObject rowData, ImportLogger logger) {
        Map orgMap = (Map)rowData.get((Object)"org");
        String orgNumber = orgMap.get("number").toString();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber)});
        Boolean orgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
        if (rowData.get((Object)"manuorg") != null && orgEnableMultiFactory.booleanValue()) {
            Map manuOrgMap = (Map)rowData.get((Object)"manuorg");
            String manuOrgNumber = manuOrgMap.get("number").toString();
            DynamicObject manuOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)manuOrgNumber)});
            Map costCenterMap = (Map)rowData.get((Object)"costcenter");
            String costCenterNumber = costCenterMap.get("number").toString();
            DynamicObject costCenter = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_costcenter", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)costCenterNumber)});
            if (manuOrg != null) {
                ArrayList<Long> manuOrgList = new ArrayList<Long>(10);
                manuOrgList.add(manuOrg.getLong("id"));
                Set centerIds = OrgHelper.getCenterIdsByManuOrgIds((Long)org.getLong("id"), manuOrgList, (String)"sca");
                if (!CadEmptyUtils.isEmpty((Set)centerIds)) {
                    if (!centerIds.contains(costCenter.getLong("id"))) {
                        String tip = String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u3010%1$s\u3011\u548c\u751f\u4ea7\u7ec4\u7ec7\u3010%2$s\u3011\u4e0d\u5b58\u5728\u5bf9\u5e94\u5173\u7cfb", (String)"PlanWorkImportOp_6", (String)"macc-cad-opplugin", (Object[])new Object[0]), costCenter.getString("name"), manuOrg.getString("name"));
                        logger.log(Integer.valueOf(index), tip);
                        return false;
                    }
                } else {
                    String tip = String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u3010%1$s\u3011\u548c\u751f\u4ea7\u7ec4\u7ec7\u3010%2$s\u3011\u4e0d\u5b58\u5728\u5bf9\u5e94\u5173\u7cfb", (String)"PlanWorkImportOp_6", (String)"macc-cad-opplugin", (Object[])new Object[0]), costCenter.getString("name"), manuOrg.getString("name"));
                    logger.log(Integer.valueOf(index), tip);
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkManuOrg(int index, JSONObject rowData, ImportLogger logger) {
        Map orgMap = (Map)rowData.get((Object)"org");
        String orgNumber = orgMap.get("number").toString();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber)});
        Boolean orgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"));
        if (orgEnableMultiFactory.booleanValue()) {
            if (rowData.get((Object)"manuorg") == null) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u7f16\u7801\u672a\u586b\u5165", (String)"PlanWorkImportOp_4", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                return false;
            }
        } else if (rowData.get((Object)"manuorg") != null) {
            String tip = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u3010%s\u3011\u672a\u5f00\u542f\u591a\u5de5\u5382\uff0c\u8bf7\u52ff\u586b\u5199\u751f\u4ea7\u7ec4\u7ec7", (String)"PlanWorkImportOp_5", (String)"macc-cad-opplugin", (Object[])new Object[0]), org.getString("name"));
            logger.log(Integer.valueOf(index), tip);
            return false;
        }
        return true;
    }

    private boolean checkOrgCostAccount(int index, JSONObject rowData, ImportLogger logger) {
        Map orgMap = (Map)rowData.get((Object)"org");
        String orgNumber = orgMap.get("number").toString();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber)});
        Map costAccountMap = (Map)rowData.get((Object)"costaccount");
        String costAccountNumber = costAccountMap.get("number").toString();
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costaccount", (String)"id,calpolicy.currency", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)costAccountNumber)});
        Long costAccountId = costAccount.getLong("id");
        List costAccountIds = CostAccountHelper.getOrgUseStdCostAccount((Long)org.getLong("id"), (String)"sca");
        if (CadEmptyUtils.isEmpty((List)costAccountIds)) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u7f16\u7801:\u3010%s\u3011\u672a\u627e\u5230\u6210\u672c\u8d26\u7c3f", (String)"PlanWorkImportOp_8", (String)"macc-cad-opplugin", (Object[])new Object[0]), org.getString("number")));
            return false;
        }
        if (!costAccountIds.contains(costAccountId)) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u7f16\u7801:\u3010%1$s\u3011\u4e0e\u6210\u672c\u8d26\u7c3f\u7f16\u7801:\u3010%2$s\u3011\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb", (String)"PlanWorkImportOp_9", (String)"macc-cad-opplugin", (Object[])new Object[0]), org.getString("number"), costAccountNumber));
            return false;
        }
        return true;
    }

    private boolean checkOrgCostCenter(int index, JSONObject rowData, ImportLogger logger) {
        Map orgMap = (Map)rowData.get((Object)"org");
        String orgNumber = orgMap.get("number").toString();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber)});
        Map costCenterMap = (Map)rowData.get((Object)"costcenter");
        String costCenterNumber = costCenterMap.get("number").toString();
        DynamicObject costCenter = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_costcenter", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)costCenterNumber)});
        DynamicObject accountOrg = costCenter.getDynamicObject("accountorg");
        if (accountOrg == null) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u7f16\u7801\u3010%1$s\u3011\u4e0e\u6838\u7b97\u7ec4\u7ec7\u7f16\u7801\u3010%2$s\u3011\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb", (String)"PlanWorkImportOp_10", (String)"macc-cad-opplugin", (Object[])new Object[0]), costCenterNumber, org.getString("number")));
            return false;
        }
        if (org != null && accountOrg.getLong("id") != org.getLong("id")) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u7f16\u7801\u3010%1$s\u3011\u4e0e\u6838\u7b97\u7ec4\u7ec7\u7f16\u7801\u3010%2$s\u3011\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb", (String)"PlanWorkImportOp_10", (String)"macc-cad-opplugin", (Object[])new Object[0]), costCenterNumber, org.getString("number")));
            return false;
        }
        return true;
    }

    private boolean checkCostAccountScheme(int index, JSONObject rowData, ImportLogger logger) {
        Map costAccountMap = (Map)rowData.get((Object)"costaccount");
        String costAccountNumber = costAccountMap.get("number").toString();
        Map schemeMap = (Map)rowData.get((Object)"planscheme");
        String schemeNumber = schemeMap.get("number").toString();
        DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_planscheme", (String)"id,number,name,costaccount,enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)schemeNumber)});
        if (!costAccountNumber.equals(scheme.getString("costaccount.number"))) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u65b9\u6848\u7f16\u7801\u3010%1$s\u3011\u4e0e\u6210\u672c\u8d26\u7c3f\u7f16\u7801\u3010%2$s\u3011\u4e0d\u5339\u914d", (String)"PlanWorkImportOp_12", (String)"macc-cad-opplugin", (Object[])new Object[0]), schemeNumber, costAccountNumber));
            return false;
        }
        if (!scheme.getBoolean("enable")) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u65b9\u6848\u7f16\u7801\u3010%1$s\u3011\u5df2\u7981\u7528", (String)"PlanWorkImportOp_21", (String)"macc-cad-opplugin", (Object[])new Object[0]), schemeNumber));
            return false;
        }
        return true;
    }

    private boolean checkWorkCostDriver(int index, JSONObject rowData, ImportLogger logger) {
        Map orgMap = (Map)rowData.get((Object)"org");
        String orgNumber = orgMap.get("number").toString();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id,number,name,fisaccounting", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber)});
        Map workActivityMap = (Map)rowData.get((Object)"workactivity");
        String workActivityNumber = workActivityMap.get("number").toString();
        DynamicObject workActivity = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_new_workactivity", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)workActivityNumber)});
        if (workActivity == null) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u4f5c\u4e1a\u6d3b\u52a8\u7f16\u7801:\u3010%s\u3011\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e", (String)"PlanWorkImportOp_18", (String)"macc-cad-opplugin", (Object[])new Object[0]), workActivityNumber));
            return false;
        }
        QFilter orgQf = BaseDataServiceHelper.getBaseDataFilter((String)"cad_costdriver", (Long)org.getLong("id"));
        QFilter allocClassQf = new QFilter("allocclass", "=", (Object)"COSTCENTER");
        QFilter isRelatedWorkQf = new QFilter("isrelatedwork", "=", (Object)Boolean.TRUE);
        QFilter appQf = new QFilter("appnum", "=", (Object)"sca");
        QFilter workQf = new QFilter("workactivity", "=", (Object)workActivity.getLong("id"));
        DynamicObject costDriver = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_costdriver", (String)"id,number,name", (QFilter[])new QFilter[]{orgQf, allocClassQf, isRelatedWorkQf, appQf, workQf});
        if (costDriver == null) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u4f5c\u4e1a\u6d3b\u52a8\u7f16\u7801:\u3010%s\u3011\u672a\u627e\u5230\u5bf9\u5e94\u6210\u672c\u52a8\u56e0", (String)"PlanWorkImportOp_19", (String)"macc-cad-opplugin", (Object[])new Object[0]), workActivityNumber));
            return false;
        }
        JSONObject costDriverJson = new JSONObject();
        costDriverJson.put("id", (Object)costDriver.getLong("id"));
        rowData.put("costdriver", (Object)costDriverJson);
        return true;
    }

    private boolean checkPeriod(int index, JSONObject rowData, ImportLogger logger) {
        if (rowData.get((Object)"period") == null) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u6838\u7b97\u671f\u95f4\u7f16\u7801\u672a\u586b\u5165", (String)"PlanWorkImportOp_1", (String)"macc-cad-opplugin", (Object[])new Object[0]));
            return false;
        }
        Map periodMap = (Map)rowData.get((Object)"period");
        String periodNumber = periodMap.get("number").toString();
        Map costAccountMap = (Map)rowData.get((Object)"costaccount");
        String costAccountNumber = costAccountMap.get("number").toString();
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costaccount", (String)"id,calpolicy", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)costAccountNumber)});
        DynamicObject calpolicy = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_calpolicy", (String)"id,periodtype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccount.getLong("calpolicy.id"))});
        QFilter qFilter = new QFilter("periodtype", "=", (Object)calpolicy.getLong("periodtype.id"));
        qFilter.and(new QFilter("number", "=", periodMap.get("number")));
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"id", (QFilter[])qFilter.toArray());
        if (period == null) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u6838\u7b97\u671f\u95f4\u7f16\u7801\u3010%s\u3011\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e", (String)"PlanWorkImportOp_2", (String)"macc-cad-opplugin", (Object[])new Object[0]), periodNumber));
            return false;
        }
        return true;
    }

    private Long getPeriodId(JSONObject org, JSONObject costaccount, JSONObject period) {
        if (org == null) {
            return null;
        }
        if (costaccount == null) {
            return null;
        }
        if (period == null) {
            return null;
        }
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costaccount", (String)"id,calpolicy", (QFilter[])new QFilter[]{new QFilter("number", "=", costaccount.get((Object)"number"))});
        if (costAccount == null) {
            return null;
        }
        DynamicObject calpolicy = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_calpolicy", (String)"id,periodtype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccount.getLong("calpolicy.id"))});
        if (calpolicy == null) {
            return null;
        }
        QFilter qFilter = new QFilter("periodtype", "=", (Object)calpolicy.getLong("periodtype.id"));
        qFilter.and(new QFilter("number", "=", period.get((Object)"number")));
        DynamicObject result = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"id", (QFilter[])qFilter.toArray());
        if (result == null) {
            return null;
        }
        return result.getLong("id");
    }
}

