/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.resourcerate;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.PlanFeeAllocHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PlanWorkSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("baseunit");
        fieldKeys.add("entryentity");
        fieldKeys.add("org");
        fieldKeys.add("qty");
        fieldKeys.add("costcenter");
        fieldKeys.add("entryentity.seq");
        fieldKeys.add("entryentity.entryqty");
        fieldKeys.add("entryentity.benefcostcenter");
        fieldKeys.add("appnum");
        fieldKeys.add("manuorg");
        fieldKeys.add("workactivity");
        fieldKeys.add("planscheme");
        fieldKeys.add("period");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                String faultTip = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"PlanWorkSaveOp_0", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    this.checkPeriodEnableClosed(dataEntity);
                    this.checkManuorgObjectMust(dataEntity, faultTip);
                    this.checkQty(dataEntity, faultTip);
                    this.dealPrecision(dataEntity);
                }
            }

            private void dealPrecision(ExtendedDataEntity dataEntity) {
                DynamicObject bill = dataEntity.getDataEntity();
                DynamicObject baseunit = bill.getDynamicObject("baseunit");
                if (baseunit != null) {
                    String precisionaccount = baseunit.getString("precisionaccount");
                    int roundType = 4;
                    if ("2".equals(precisionaccount)) {
                        roundType = 1;
                    } else if ("3".equals(precisionaccount)) {
                        roundType = 0;
                    }
                    bill.set("qty", (Object)bill.getBigDecimal("qty").setScale(baseunit.getInt("precision"), roundType));
                    DynamicObjectCollection rows = bill.getDynamicObjectCollection("entryentity");
                    for (DynamicObject row : rows) {
                        row.set("entryqty", (Object)row.getBigDecimal("entryqty").setScale(baseunit.getInt("precision"), roundType));
                    }
                }
            }

            private void checkQty(ExtendedDataEntity dataEntity, String faultTip) {
                double diff;
                DynamicObject entity = dataEntity.getDataEntity();
                BigDecimal qty = entity.getBigDecimal("qty");
                if (qty == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5355\u636e\u5934\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlanWorkSaveOp_5", (String)"macc-cad-opplugin", (Object[])new Object[0]), faultTip));
                } else if (qty.compareTo(BigDecimal.ZERO) <= 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5355\u636e\u5934\u6570\u91cf\u5fc5\u987b>0\u3002", (String)"PlanWorkSaveOp_6", (String)"macc-cad-opplugin", (Object[])new Object[0]), faultTip));
                }
                DynamicObjectCollection entryentity = entity.getDynamicObjectCollection("entryentity");
                if (entryentity == null || entryentity.isEmpty()) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5355\u636e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlanWorkSaveOp_7", (String)"macc-cad-opplugin", (Object[])new Object[0]), faultTip));
                    return;
                }
                BigDecimal countQty = BigDecimal.ZERO;
                for (DynamicObject entry : entryentity) {
                    BigDecimal entryqty = entry.getBigDecimal("entryqty");
                    int seq = entry.getInt("seq");
                    if (entryqty == null) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5355\u636e\u4f53\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlanWorkSaveOp_8", (String)"macc-cad-opplugin", (Object[])new Object[0]), faultTip));
                    } else if (entryqty.compareTo(BigDecimal.ZERO) <= 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e\u4f53\u7b2c%2$s\u884c\u6570\u91cf\u5fc5\u987b>0\u3002", (String)"PlanWorkSaveOp_9", (String)"macc-cad-opplugin", (Object[])new Object[0]), faultTip, seq));
                    }
                    countQty = countQty.add(entryqty);
                }
                if (qty != null && countQty != null && (BigDecimal.valueOf(diff = qty.doubleValue() - countQty.doubleValue()).compareTo(BigDecimal.ZERO) < 0 || BigDecimal.valueOf(diff).compareTo(BigDecimal.ZERO) > 0)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5355\u636e\u5934\u6570\u91cf \u2260 \u5355\u636e\u4f53\u6570\u91cf\u5408\u8ba1\u3002", (String)"PlanWorkSaveOp_10", (String)"macc-cad-opplugin", (Object[])new Object[0]), faultTip));
                }
            }

            private void checkPeriodEnableClosed(ExtendedDataEntity dataEntity) {
                DynamicObject entity = dataEntity.getDataEntity();
                Long schemeId = entity.get("planscheme") instanceof DynamicObject ? Long.valueOf(entity.getLong("planscheme.id")) : Long.valueOf(entity.getLong("planscheme"));
                Long periodId = entity.get("period") instanceof DynamicObject ? Long.valueOf(entity.getLong("period.id")) : Long.valueOf(entity.getLong("period"));
                if (CadEmptyUtils.isEmpty((Long)schemeId) || CadEmptyUtils.isEmpty((Long)periodId)) {
                    return;
                }
                String errorMsg = PlanFeeAllocHelper.checkPeriodClosed((Long)schemeId, (Long)periodId);
                if (!kd.macc.cad.algox.utils.CadEmptyUtils.isEmpty((String)errorMsg)) {
                    this.addErrorMessage(dataEntity, errorMsg);
                }
            }

            private void checkManuorgObjectMust(ExtendedDataEntity dataEntity, String faultTip) {
                DynamicObject entity = dataEntity.getDataEntity();
                String appnum = entity.getString("appnum");
                long orgId = entity.getLong("org.id");
                DynamicObject manuorg = entity.getDynamicObject("manuorg");
                if (CostAccountHelper.isOrgEnableMulFactory((Long)orgId, (String)appnum) && CadEmptyUtils.isEmpty((DynamicObject)manuorg)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u4fdd\u5b58\u5931\u8d25\u3002\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff1a\u751f\u4ea7\u7ec4\u7ec7\u4e3a\u5fc5\u5f55\u3002", (String)"PlanWorkSaveOp_11", (String)"macc-cad-opplugin", (Object[])new Object[0]), faultTip));
                }
            }
        });
    }
}

