/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.router;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.macc.cad.business.router.SyncRouterHandle;

public class ReSyncRouterOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ReSyncRouterOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List keys = e.getFieldKeys();
        keys.add("productrouter");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        ArrayList<Object> routerIds = new ArrayList<Object>(datas.length);
        ArrayList<Object> logIds = new ArrayList<Object>(datas.length);
        try {
            for (DynamicObject data : datas) {
                DynamicObject router = data.getDynamicObject("productrouter");
                if (router != null) {
                    routerIds.add(router.getPkValue());
                }
                logIds.add(data.getPkValue());
            }
            if (!routerIds.isEmpty()) {
                SyncRouterHandle.syncRouter((String)"pdm_route", routerIds);
            }
            DeleteServiceHelper.delete((IDataEntityType)datas[0].getDataEntityType(), (Object[])logIds.toArray());
        }
        catch (Exception ex) {
            logger.error("\u540c\u6b65\u5931\u8d25", (Throwable)ex);
        }
    }
}

