/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.settle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.macc.cad.business.settle.CalcSettleEngine;
import kd.macc.cad.business.settle.common.CalcSettleEnum;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class SettleReportReCalcOpValidate
extends AbstractValidator {
    Map<Long, Long> accCurPeriodMap = new HashMap<Long, Long>();

    public void validate() {
        ExtendedDataEntity[] datas;
        for (ExtendedDataEntity dataEntity : datas = this.dataEntities) {
            DynamicObject dyn = dataEntity.getDataEntity();
            Long costaccountId = dyn.getLong("costaccount.id");
            Long curPeriodId = 0L;
            if (!this.accCurPeriodMap.containsKey(costaccountId)) {
                DynamicObject periodDyn = PeriodHelper.getCurrentPeriod((Long)costaccountId);
                if (periodDyn != null) {
                    curPeriodId = periodDyn.getLong("id");
                    this.accCurPeriodMap.put(costaccountId, periodDyn.getLong("id"));
                }
            } else {
                curPeriodId = this.accCurPeriodMap.get(costaccountId);
            }
            if (!curPeriodId.equals(dataEntity.getDataEntity().getLong("period.id"))) {
                String tips = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u5bf9\u975e\u5f53\u524d\u671f\u95f4\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SettleReportReCalcOpValidate_0", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, tips);
                continue;
            }
            String status = dyn.getString("status");
            if (!CalcSettleEnum.SETTLESTATUS_FAIL.getValue().equals(status) && !CalcSettleEnum.SETTLESTATUS_ABORT.getValue().equals(status)) {
                String tips = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u62a5\u544a\u72b6\u6001\u4e3a\u3010\u5931\u8d25\u3011\u6216\u3010\u7ec8\u6b62\u6267\u884c\u3011\u65f6\u624d\u5141\u8bb8\u91cd\u65b0\u8fd0\u7b97\u3002", (String)"SettleReportReCalcOpValidate_3", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, tips);
                continue;
            }
            if (CalcSettleEnum.SETTLESTATUS_ABORT.getValue().equals(status)) {
                DynamicObjectCollection funcDyns = dyn.getDynamicObjectCollection("entryentity");
                block1: for (DynamicObject funcDyn : funcDyns) {
                    DynamicObjectCollection taskDyns = funcDyn.getDynamicObjectCollection("subentryentity");
                    for (DynamicObject taskDyn : taskDyns) {
                        String substatus = taskDyn.getString("substatus");
                        if (!CalcSettleEnum.SETTLESUB_RUN.getValue().equals(substatus)) continue;
                        String tips = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u62a5\u544a\u8fd8\u5b58\u5728\u8fd0\u884c\u4e2d\u7684\u5b50\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u64cd\u4f5c\u3002", (String)"SettleReportReCalcOpValidate_4", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                        this.addErrorMessage(dataEntity, tips);
                        continue block1;
                    }
                }
            }
            ArrayList<Long> costaccountIds = new ArrayList<Long>(10);
            costaccountIds.add(costaccountId);
            Set runCostaccountIds = CalcSettleEngine.getRunningSettleReport(costaccountIds, (Long)curPeriodId);
            if (CadEmptyUtils.isEmpty((Set)runCostaccountIds)) continue;
            String tips = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u5f53\u524d\u8d26\u7c3f\u5b58\u5728\u8fd0\u884c\u4e2d\u7684\u4efb\u52a1\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u3002", (String)"SettleReportReCalcOpValidate_2", (String)"macc-cad-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, tips);
        }
    }
}

