/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.sysparam;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.helper.CalcKeycolHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public class SysParamSaveOpValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.dataEntities;
        for (int i = 0; i < datas.length; ++i) {
            ExtendedDataEntity dataEntity = datas[i];
            this.validateSave(dataEntity);
        }
    }

    protected void validateSave(ExtendedDataEntity dataEntity) {
        DynamicObject item = dataEntity.getDataEntity();
        DynamicObjectCollection actrows = item.getDynamicObjectCollection("accountparamlist");
        DynamicObjectCollection rows = item.getDynamicObjectCollection("paramlist");
        DynamicObjectCollection actTimeRows = item.getDynamicObjectCollection("timelist");
        if (actrows.size() != 0) {
            DataSet sysParamDataSet = null;
            Iterator typeOrgDataSet = null;
            Boolean isScaApp = "sca".equals(item.getString("appnum"));
            if (Boolean.TRUE.equals(isScaApp)) {
                sysParamDataSet = this.getDBParam();
                typeOrgDataSet = this.getCostTypeOrg("calorg org,costaccount");
            }
            HashSet<Integer> set = new HashSet<Integer>();
            int f = 1;
            for (DynamicObject row : actrows) {
                DynamicObject sysParam;
                String isUpdateByPeriodErr;
                DynamicObject acctOrg = row.getDynamicObject("org");
                DynamicObject costAccount = row.getDynamicObject("costaccount");
                String reductStrategy = row.getString("reductstrategy");
                String restoreCalcRange = row.getString("restorecalcrange");
                DynamicObjectCollection restoreGetDataRangeDyns = row.getDynamicObjectCollection("restoregetdatarange");
                if (acctOrg == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u53c2\u6570\u7b2c%s\u884c\uff0c\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u503c\u4e3a\u7a7a\u3002", (String)"SysParamSaveOpValidator_6", (String)"macc-cad-opplugin", (Object[])new Object[0]), f));
                }
                if (costAccount == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u53c2\u6570\u7b2c%s\u884c\uff0c\u201c\u6210\u672c\u8d26\u7c3f\u201d\u503c\u4e3a\u7a7a\u3002", (String)"SysParamSaveOpValidator_7", (String)"macc-cad-opplugin", (Object[])new Object[0]), f));
                }
                if (Boolean.TRUE.equals(isScaApp) && StringUtils.isNotEmpty((String)(isUpdateByPeriodErr = this.validIsUpdateByPeriod(sysParamDataSet, (DataSet)typeOrgDataSet, row)))) {
                    this.addErrorMessage(dataEntity, isUpdateByPeriodErr);
                }
                if (reductStrategy == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u53c2\u6570\u7b2c%s\u884c\uff0c\u201c\u8fd8\u539f\u7b56\u7565\u201d\u503c\u4e3a\u7a7a\u3002", (String)"SysParamSaveOpValidator_8", (String)"macc-cad-opplugin", (Object[])new Object[0]), f));
                }
                if (restoreCalcRange.contains(SysParamEnum.RESTORECALCRANGE_PURINBILL.getValue()) && restoreGetDataRangeDyns.size() == 0 && costAccount != null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u6210\u672c\u6838\u7b97\u53c2\u6570\u7b2c%1$s\u884c\u201c%2$s\u201d\u6210\u672c\u8d26\u7c3f\uff0c\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u8303\u56f4\u52fe\u9009\u4e86\u91c7\u8d2d\u5165\u5e93\u5355\uff0c\u9700\u8981\u8bbe\u7f6e\u91c7\u8d2d\u5165\u5e93\u5355\u53d6\u6570\u8303\u56f4\u3002", (String)"SysParamSaveOpValidator_9", (String)"macc-cad-opplugin", (Object[])new Object[0]), f, costAccount.get("name")));
                }
                if (costAccount != null && (sysParam = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)"id,calckeyfield,reductcalckeycol,reductrestorekeycol", (QFilter[])new QFilter[]{new QFilter("costaccount", "=", (Object)costAccount.getLong("id"))})) != null) {
                    boolean isQueryChange;
                    Set srcKeySet = CalcKeycolHelper.getKeySet((String)sysParam.getString("calckeyfield"));
                    Set tarKeySet = CalcKeycolHelper.getKeySet((String)row.getString("calckeyfield"));
                    boolean calckeyfieldChange = true;
                    if (srcKeySet.size() == tarKeySet.size()) {
                        srcKeySet.removeAll(tarKeySet);
                        if (srcKeySet.isEmpty()) {
                            calckeyfieldChange = false;
                        }
                    }
                    if (isQueryChange = "1".equals(CadBgParamUtils.getCadBgParamForString((String)"checkkeycolchange", (String)"1"))) {
                        boolean reductrestorekeycolChange;
                        if (calckeyfieldChange) {
                            if (this.validateExistCalcData(costAccount.getLong("id"))) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%s\u201d\u5b58\u5728\u6210\u672c\u8ba1\u7b97\u7ed3\u679c\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"SysParamSaveOpValidator_20", (String)"macc-cad-opplugin", (Object[])new Object[0]), costAccount.get("name")));
                            } else if (this.validateExistRecoveryData(costAccount.getLong("id"))) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%s\u201d\u5b58\u5728\u6210\u672c\u8fd8\u539f\u7ed3\u679c\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"SysParamSaveOpValidator_22", (String)"macc-cad-opplugin", (Object[])new Object[0]), costAccount.get("name")));
                            } else if (this.validateMatAllocExistCalcKeyCol(costAccount.getLong("id"))) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%s\u201d\u5b58\u5728\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u7528\u4e86\u8ba1\u7b97\u7ef4\u5ea6\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"SysParamSaveOpValidator_21", (String)"macc-cad-opplugin", (Object[])new Object[0]), costAccount.get("name")));
                            }
                        }
                        boolean reductcalckeycolChange = !sysParam.getString("reductcalckeycol").equals(row.getString("reductcalckeycol"));
                        boolean bl = reductrestorekeycolChange = !sysParam.getString("reductrestorekeycol").equals(row.getString("reductrestorekeycol"));
                        if ((reductcalckeycolChange || reductrestorekeycolChange) && this.validateExistRecoveryData(costAccount.getLong("id"))) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%s\u201d\u5b58\u5728\u6210\u672c\u8fd8\u539f\u7ed3\u679c\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"SysParamSaveOpValidator_22", (String)"macc-cad-opplugin", (Object[])new Object[0]), costAccount.get("name")));
                        }
                    }
                }
                String key = null;
                if (acctOrg != null) {
                    String acctOrgId = acctOrg.getString("id");
                    String costAccountId = Optional.ofNullable(costAccount).map(s -> s.getString("id")).orElse("");
                    key = acctOrgId + (String)costAccountId;
                }
                int g = 1;
                for (DynamicObject compRow : actrows) {
                    if (f >= g || set.contains(f)) {
                        ++g;
                        continue;
                    }
                    DynamicObject compAcctOrg = compRow.getDynamicObject("org");
                    DynamicObject comCostAccount = compRow.getDynamicObject("costaccount");
                    String compKey = null;
                    if (compAcctOrg != null) {
                        String acctOrgId = compAcctOrg.getString("id");
                        String costAccountId = Optional.ofNullable(comCostAccount).map(s -> s.getString("id")).orElse("");
                        compKey = acctOrgId + costAccountId;
                    }
                    if (key != null && compKey != null && key.equals(compKey)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u53c2\u6570\u7b2c%s\u884c\uff0c\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u548c\u201c\u6210\u672c\u8d26\u7c3f\u201d\u7ec4\u5408\u91cd\u590d\u3002", (String)"SysParamSaveOpValidator_10", (String)"macc-cad-opplugin", (Object[])new Object[0]), g));
                        set.add(g);
                    }
                    ++g;
                }
                ++f;
            }
        }
        int k = 1;
        if (actTimeRows.size() != 0) {
            for (DynamicObject row : actTimeRows) {
                DynamicObject actOrg = row.getDynamicObject("actorg");
                String importPeriodScope = row.getString("importperiodscope");
                if (actOrg == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u5f52\u96c6\u53c2\u6570-\u65f6\u95f4\u8303\u56f4\u7b2c%s\u884c\uff0c\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u503c\u4e3a\u7a7a\u3002", (String)"SysParamSaveOpValidator_11", (String)"macc-cad-opplugin", (Object[])new Object[0]), k));
                }
                if (importPeriodScope == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u5f52\u96c6\u53c2\u6570-\u65f6\u95f4\u8303\u56f4\u7b2c%s\u884c\uff0c\u201c\u4e1a\u52a1\u5355\u636e\u8986\u76d6\u5f15\u5165\u671f\u95f4\u8303\u56f4\u201d\u503c\u4e3a\u7a7a\u3002", (String)"SysParamSaveOpValidator_19", (String)"macc-cad-opplugin", (Object[])new Object[0]), k));
                }
                ++k;
            }
        }
        if (rows.size() != 0) {
            HashSet<Integer> set = new HashSet<Integer>();
            int i = 1;
            for (DynamicObject row : rows) {
                String matcollectrange;
                String resourcerange;
                String billRanges;
                DynamicObject acctOrg = row.getDynamicObject("accountorg");
                DynamicObject costCenter = row.getDynamicObject("costcenter");
                if (acctOrg == null) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u5f52\u96c6\u53c2\u6570-\u4e1a\u52a1\u8303\u56f4\u7b2c%s\u884c\uff0c\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u503c\u4e3a\u7a7a\u3002", (String)"SysParamSaveOpValidator_13", (String)"macc-cad-opplugin", (Object[])new Object[0]), i));
                }
                if (StringUtils.isEmpty((String)(billRanges = row.getString("billrange"))) && SysParamEnum.COMPTYPE_OBJECTRULE.getValue().equals(row.getString("completetype"))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u5f52\u96c6\u53c2\u6570-\u4e1a\u52a1\u8303\u56f4\u7b2c%s\u884c\uff0c\u201c\u53c2\u4e0e\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u7684\u5355\u636e\u8303\u56f4\u201d\u503c\u4e3a\u7a7a\u3002", (String)"SysParamSaveOpValidator_14", (String)"macc-cad-opplugin", (Object[])new Object[0]), i));
                }
                if (StringUtils.isEmpty((String)(resourcerange = row.getString("resourcerange"))) && SysParamEnum.COMPTYPE_OBJECTRULE.getValue().equals(row.getString("resourceusetype"))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u5f52\u96c6\u53c2\u6570-\u4e1a\u52a1\u8303\u56f4\u7b2c%s\u884c\uff0c\u201c\u53c2\u4e0e\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u7684\u5355\u636e\u8303\u56f4\u201d\u503c\u4e3a\u7a7a\u3002", (String)"SysParamSaveOpValidator_15", (String)"macc-cad-opplugin", (Object[])new Object[0]), i));
                }
                if (StringUtils.isEmpty((String)(matcollectrange = row.getString("matcollectrange"))) && "INNERSYSIMPORT".equals(row.getString("matcollectway"))) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u5f52\u96c6\u53c2\u6570-\u4e1a\u52a1\u8303\u56f4\u7b2c%s\u884c\uff0c\u201c\u6750\u6599\u8017\u7528\u5f52\u96c6\u7684\u5355\u636e\u8303\u56f4\u201d\u503c\u4e3a\u7a7a\u3002", (String)"SysParamSaveOpValidator_16", (String)"macc-cad-opplugin", (Object[])new Object[0]), i));
                }
                String key = null;
                if (acctOrg != null) {
                    String acctOrgId = acctOrg.getString("id");
                    String cost = Optional.ofNullable(costCenter).map(s -> s.getString("id")).orElse("");
                    key = acctOrgId + cost;
                }
                int j = 1;
                for (DynamicObject compRow : rows) {
                    if (i >= j || set.contains(i)) {
                        ++j;
                        continue;
                    }
                    DynamicObject compAcctOrg = compRow.getDynamicObject("accountorg");
                    DynamicObject compCostCenter = compRow.getDynamicObject("costcenter");
                    String compKey = null;
                    if (compAcctOrg != null) {
                        String acctOrgId = compAcctOrg.getString("id");
                        String cost = Optional.ofNullable(compCostCenter).map(s -> s.getString("id")).orElse("");
                        compKey = acctOrgId + cost;
                    }
                    if (key != null && compKey != null && key.equals(compKey)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u5f52\u96c6\u53c2\u6570-\u4e1a\u52a1\u8303\u56f4\u7b2c%s\u884c\uff0c\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u548c\u201c\u6210\u672c\u4e2d\u5fc3\u201d\u7ec4\u5408\u91cd\u590d\u3002", (String)"SysParamSaveOpValidator_17", (String)"macc-cad-opplugin", (Object[])new Object[0]), j));
                        set.add(j);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private boolean validateExistCalcData(long costAccountId) {
        List periodIds = PeriodHelper.getCurrentPreviousPeriod((Long)costAccountId);
        if (CadEmptyUtils.isEmpty((List)periodIds)) {
            return false;
        }
        QFilter qFilter = new QFilter("costaccount", "=", (Object)costAccountId);
        qFilter.and(new QFilter("period", "in", (Object)periodIds));
        return QueryServiceHelper.exists((String)"aca_calcresult", (QFilter[])new QFilter[]{qFilter});
    }

    private boolean validateExistRecoveryData(long costAccountId) {
        List periodIds = PeriodHelper.getCurrentPreviousPeriod((Long)costAccountId);
        if (CadEmptyUtils.isEmpty((List)periodIds)) {
            return false;
        }
        QFilter qFilter = new QFilter("costaccount", "=", (Object)costAccountId);
        qFilter.and(new QFilter("period", "in", (Object)periodIds));
        return QueryServiceHelper.exists((String)"sca_costrecovry", (QFilter[])new QFilter[]{qFilter});
    }

    private boolean validateMatAllocExistCalcKeyCol(long costAccountId) {
        List periodIds = PeriodHelper.getCurrentPreviousPeriod((Long)costAccountId);
        if (CadEmptyUtils.isEmpty((List)periodIds)) {
            return false;
        }
        QFilter qFilter = new QFilter("costaccount", "=", (Object)costAccountId);
        qFilter.and(new QFilter("period", "in", (Object)periodIds));
        qFilter.and(new QFilter("allocdim", "!=", (Object)" "));
        boolean existCalcKeyCol = QueryServiceHelper.exists((String)"aca_matalloc", (QFilter[])new QFilter[]{qFilter});
        return existCalcKeyCol;
    }

    private String validIsUpdateByPeriod(DataSet sysParamDataSet, DataSet typeOrgDataSet, DynamicObject row) {
        DynamicObject acctOrg = row.getDynamicObject("org");
        DynamicObject costAccount = row.getDynamicObject("costaccount");
        if (acctOrg == null || costAccount == null) {
            return null;
        }
        Object orgId = acctOrg.getPkValue();
        Object costAccountId = costAccount.getPkValue();
        Boolean isUpdateByPeriod = row.getBoolean("isupdatebyperiod");
        String reductStrategy = row.getString("reductstrategy");
        DataSet data = sysParamDataSet.copy().filter("org = " + orgId + " and costaccount =" + costAccountId);
        if (data.isEmpty()) {
            DataSet typeOrg = typeOrgDataSet.copy().filter("org = " + orgId + " and costaccount =" + costAccountId);
            if (typeOrg.isEmpty()) {
                return this.noCostTypeTip(row);
            }
            return null;
        }
        Row dbRow = data.next();
        Boolean dbIsUpdateByPeriod = dbRow.getBoolean("isupdatebyperiod");
        if (isUpdateByPeriod.equals(dbIsUpdateByPeriod)) {
            return null;
        }
        Object dbCostType = dbRow.get("costtype");
        if (dbCostType == null) {
            return this.noCostTypeTip(row);
        }
        DynamicObject period = PeriodHelper.getPeriodByDate((Date)TimeServiceHelper.now(), (Long)((Long)costAccountId));
        Date effectDate = dbRow.getDate("effectdate");
        if (effectDate == null || DateUtils.getDefaultEffectDate().compareTo(effectDate) == 0) {
            return null;
        }
        DynamicObject effectPeriod = PeriodHelper.getPeriodByDate((Date)effectDate, (Long)((Long)costAccountId));
        String dbReductStrategy = dbRow.getString("reductstrategy");
        if (SysParamEnum.ITEMIZED_REDUCT.getValue().equalsIgnoreCase(dbReductStrategy) && SysParamEnum.OVERALL_REDUCT.getValue().equalsIgnoreCase(reductStrategy) && effectPeriod.getLong("id") > period.getLong("id")) {
            return ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u7269\u6599\u5df2\u7ecf\u5728\u4e0b\u671f\u8fdb\u884c\u4e86\u6807\u51c6\u6210\u672c\u66f4\u65b0\uff0c\u5f53\u671f\u4e0d\u5141\u8bb8\u4fee\u6539\u6309\u671f\u8fdb\u884c\u6210\u672c\u66f4\u65b0\u53c2\u6570\u3002", (String)"SysParamSaveOpValidator_4", (String)"macc-cad-opplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private DataSet getDBParam() {
        QFilter[] filters = new QFilter[]{new QFilter("appnum", "=", (Object)"sca"), new QFilter("tab", "=", (Object)"costaccounttabpage")};
        DataSet sysParamDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".getDBParamSetting"), (String)"cad_sysparam", (String)"org,costaccount,isupdatebyperiod,reductstrategy", (QFilter[])filters, null);
        DataSet costTypeOrgDataSet = this.getCostTypeOrg("calorg,costaccount,costtype");
        DataSet costTypeDataSet = costTypeOrgDataSet.copy().select("costtype");
        HashSet<Long> costTypeIds = new HashSet<Long>(16);
        for (Row row : costTypeDataSet) {
            costTypeIds.add(row.getLong("costtype"));
        }
        filters = new QFilter[]{new QFilter("costtype", "in", costTypeIds)};
        DataSet matCostInfoDataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".getMatCostInfo"), (String)"cad_matcostinfo", (String)"costtype,effectdate", (QFilter[])filters, null).groupBy(new String[]{"costtype"}).max("effectdate").finish();
        costTypeOrgDataSet = costTypeOrgDataSet.leftJoin(matCostInfoDataSet).on("costtype", "costtype").select(costTypeOrgDataSet.getRowMeta().getFieldNames(), new String[]{"effectdate"}).finish();
        return sysParamDataSet.leftJoin(costTypeOrgDataSet).on("org", "calorg").on("costaccount", "costaccount").select(sysParamDataSet.getRowMeta().getFieldNames(), new String[]{"costtype", "effectdate"}).finish();
    }

    private DataSet getCostTypeOrg(String selectFields) {
        Date date = TimeServiceHelper.now();
        QFilter[] filters = new QFilter[]{new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
        return QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ".getCostTypeOrg"), (String)"cal_bd_costtypeorg", (String)selectFields, (QFilter[])filters, null);
    }

    private String noCostTypeTip(DynamicObject row) {
        DynamicObject org = row.getDynamicObject("org");
        DynamicObject costAccount = row.getDynamicObject("costaccount");
        return String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u8bf7\u5148\u5728\u201c\u6210\u672c\u7c7b\u578b\u4e0e\u7ec4\u7ec7\u5bf9\u5e94\u8868\u201d\u7ef4\u62a4\u6838\u7b97\u7ec4\u7ec7\u201c%1$s/%2$s\u201d\u6210\u672c\u8d26\u7c3f\u201c%3$s/%4$s\u201d\u5bf9\u5e94\u7684\u6210\u672c\u7c7b\u578b\u3002", (String)"SysParamSaveOpValidator_18", (String)"macc-cad-opplugin", (Object[])new Object[0]), org.getString("number"), org.getString("name"), costAccount.getString("number"), costAccount.getString("name"));
    }
}

