/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.yieldcollection;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.OutSourcePrice;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class FactnedOutputBillAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("srcauditdate");
        fieldKeys.add("auditdate");
        fieldKeys.add("sourcebill");
        fieldKeys.add("entrycost");
        fieldKeys.add("appnum");
        fieldKeys.add("srcbilltype");
        fieldKeys.add("manuorg");
        fieldKeys.add("org");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObjectCollection entryCost;
                    DynamicObject factnedObject = dataEntity.getDataEntity();
                    String appNum = factnedObject.getString("appnum");
                    if (!"sca".equals(appNum) || (entryCost = factnedObject.getDynamicObjectCollection("entrycost")) != null && entryCost.size() != 0) continue;
                    String message = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u6210\u672c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FactnedOutputBillAuditOp_0", (String)"macc-cad-opplugin", (Object[])new Object[0]), (String)"BaseSettingSaveOpValidate_1", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, message);
                    break;
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        HashSet<Long> wwFinishIds = new HashSet<Long>(16);
        HashSet<Long> factIds = new HashSet<Long>(16);
        ArrayList<Long> manuOrgs = new ArrayList<Long>();
        Long orgId = 0L;
        String appNum = "";
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            String srcbilltype;
            long srcBillId;
            if (CadEmptyUtils.isEmpty((Long)orgId)) {
                orgId = dataEntity.getLong("org.id");
            }
            if (CadEmptyUtils.isEmpty((String)appNum)) {
                appNum = dataEntity.getString("appnum");
            }
            if (CadEmptyUtils.isEmpty((Long)(srcBillId = dataEntity.getLong("sourcebill")))) {
                factIds.add(dataEntity.getLong("id"));
            }
            if (!"im_mdc_omcmplinbill".equals(srcbilltype = dataEntity.getString("srcbilltype.number"))) continue;
            wwFinishIds.add(dataEntity.getLong("id"));
            long manuOrgId = dataEntity.getLong("manuorg.id");
            if (CadEmptyUtils.isEmpty((Long)manuOrgId)) continue;
            manuOrgs.add(manuOrgId);
        }
        if (!factIds.isEmpty()) {
            DynamicObject[] facts;
            for (DynamicObject fact : facts = BusinessDataServiceHelper.load((Object[])factIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cad_factnedoutputbill"))) {
                fact.set("srcauditdate", (Object)fact.getDate("auditdate"));
            }
            SaveServiceHelper.update((DynamicObject[])facts);
        }
        if (!wwFinishIds.isEmpty() && "sca".equals(appNum)) {
            DynamicObject[] finishs = BusinessDataServiceHelper.load((Object[])wwFinishIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cad_factnedoutputbill"));
            ArrayList<DynamicObject> outPutAbsorbList = new ArrayList<DynamicObject>(10);
            Map<String, Long> accountManuOrgCostType = this.getAccountManuOrgCostType(orgId, manuOrgs);
            Map<Long, Map<Long, Set<OutSourcePrice>>> costtypeAndMaterialAndOutPrice = this.getOurPriceMap(accountManuOrgCostType);
            for (DynamicObject finish : finishs) {
                DynamicObject entryDyn;
                DynamicObjectCollection entrycost = finish.getDynamicObjectCollection("entrycost");
                Long keycolid = 0L;
                Iterator<Map.Entry<String, Long>> iterator = entrycost.iterator();
                while (iterator.hasNext() && CadEmptyUtils.isEmpty((Long)(keycolid = Long.valueOf((entryDyn = (DynamicObject)iterator.next()).getLong("entrykeycolid.id"))))) {
                }
                for (Map.Entry<String, Long> ele : accountManuOrgCostType.entrySet()) {
                    String[] split = ele.getKey().split("-");
                    Long costaccount = Long.valueOf(split[0]);
                    Long manuorg = Long.valueOf(split[1]);
                    if (manuorg != 0L && !manuorg.equals(finish.getLong("manuorg.id"))) continue;
                    Long costtype = ele.getValue();
                    Map<Long, Set<OutSourcePrice>> materialAndOutPrice = costtypeAndMaterialAndOutPrice.get(costtype);
                    Set outSourcePrices = materialAndOutPrice.computeIfAbsent(keycolid, v -> new HashSet(16));
                    DynamicObject resourceAbsorb = this.buildResourceAbsorbBill(finish, finish.getDynamicObjectCollection("entryentity"), costaccount, outSourcePrices);
                    if (resourceAbsorb.getDynamicObjectCollection("entryentity").isEmpty()) continue;
                    outPutAbsorbList.add(resourceAbsorb);
                }
            }
            if (!outPutAbsorbList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])outPutAbsorbList.toArray(new DynamicObject[0]));
            }
        }
    }

    protected DynamicObject buildResourceAbsorbBill(DynamicObject factned, DynamicObjectCollection entryentity, Long costaccount, Set<OutSourcePrice> outSourcePrices) {
        DynamicObject costAccountDO = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.calpolicy.currency currency,entry.calpolicy.currency.amtprecision amtprecision,entry.currentperiod currentperiod", (QFilter[])new QFilter("entry.costaccount", "=", (Object)costaccount).toArray());
        DynamicObject resourceAbsorb = BusinessDataServiceHelper.newDynamicObject((String)"sca_resourceabsorb");
        resourceAbsorb.set("billno", (Object)factned.getString("billno"));
        resourceAbsorb.set("org", (Object)factned.getLong("org.id"));
        resourceAbsorb.set("costaccount", (Object)costaccount);
        resourceAbsorb.set("costcenter", (Object)factned.getLong("costcenter.id"));
        resourceAbsorb.set("period", (Object)PeriodHelper.getPeriodByDate((Date)factned.getDate("bookdate"), (Long)costaccount).getLong("id"));
        resourceAbsorb.set("currency", (Object)costAccountDO.getLong("currency"));
        resourceAbsorb.set("sourcetype", (Object)"F");
        resourceAbsorb.set("outputbillno", (Object)factned.getString("billno"));
        resourceAbsorb.set("businessdate", (Object)factned.getDate("bizdate"));
        resourceAbsorb.set("bookdate", (Object)factned.getDate("bookdate"));
        resourceAbsorb.set("costobject", (Object)((DynamicObject)entryentity.get(0)).getLong("costobject.id"));
        resourceAbsorb.set("sourcebill", (Object)factned.getLong("id"));
        resourceAbsorb.set("sourcebillentry", (Object)0L);
        resourceAbsorb.set("material", (Object)factned.getLong("material.id"));
        resourceAbsorb.set("auxpty", (Object)factned.getLong("auxpty.id"));
        resourceAbsorb.set("creator", (Object)RequestContext.get().getCurrUserId());
        resourceAbsorb.set("modifier", (Object)RequestContext.get().getCurrUserId());
        resourceAbsorb.set("auditor", (Object)RequestContext.get().getCurrUserId());
        resourceAbsorb.set("createtime", (Object)TimeServiceHelper.now());
        resourceAbsorb.set("modifytime", (Object)TimeServiceHelper.now());
        resourceAbsorb.set("auditdate", (Object)TimeServiceHelper.now());
        resourceAbsorb.set("billstatus", (Object)"C");
        Date srcAuditDate = factned.getDate("srcauditdate");
        DynamicObjectCollection entryEntity = resourceAbsorb.getDynamicObjectCollection("entryentity");
        for (OutSourcePrice materialPrice : outSourcePrices) {
            if (srcAuditDate.getTime() < materialPrice.getEffectDate().getTime() || srcAuditDate.getTime() >= materialPrice.getExpDate().getTime()) continue;
            BigDecimal qty = factned.getBigDecimal("completeqty");
            BigDecimal unitPrice = materialPrice.getPrice();
            int amtprecision = costAccountDO.getInt("amtprecision");
            BigDecimal amount = unitPrice.multiply(qty).setScale(amtprecision, 4);
            long element = materialPrice.getElement();
            long subElement = materialPrice.getSubElement();
            resourceAbsorb.set("keycol", (Object)materialPrice.getKeycol());
            resourceAbsorb.set("keycolid", (Object)materialPrice.getKeycolid());
            DynamicObject raEntry = entryEntity.addNew();
            raEntry.set("element", (Object)element);
            raEntry.set("subelement", (Object)subElement);
            raEntry.set("qty", (Object)qty);
            raEntry.set("unitprice", (Object)unitPrice);
            raEntry.set("amount", (Object)amount);
            raEntry.set("baseunit", (Object)factned.getLong("baseunit.id"));
        }
        return resourceAbsorb;
    }

    private Map<String, Long> getAccountManuOrgCostType(Long orgId, List<Long> manuOrgs) {
        HashMap<String, Long> accountManuorgAndCosttype = new HashMap<String, Long>();
        QFilter startQf = new QFilter("org", "=", (Object)orgId);
        QFilter initQf = new QFilter("entryentity.isinit", "=", (Object)true);
        QFilter appNumQf = new QFilter("appnum", "=", (Object)"sca");
        DynamicObjectCollection scaStartStdCost = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount costaccount", (QFilter[])new QFilter[]{startQf, initQf, appNumQf});
        Set costAccountSet = scaStartStdCost.stream().map(v -> v.getLong("costaccount")).collect(Collectors.toSet());
        for (Long costAccount : costAccountSet) {
            if (!manuOrgs.isEmpty()) {
                for (Long manuOrg : manuOrgs) {
                    Long costtypeId = CostTypeHelper.getCostTypeIdByManuOrgIdFromCal((Long)costAccount, (Long)orgId, (Long)manuOrg);
                    if (costtypeId == null) continue;
                    accountManuorgAndCosttype.put(costAccount + "-" + manuOrg, costtypeId);
                }
                continue;
            }
            Long costtypeId = CostTypeHelper.getCostTypeIdByManuOrgIdFromCal((Long)costAccount, (Long)orgId, null);
            if (costtypeId == null) continue;
            accountManuorgAndCosttype.put(costAccount + "-0", costtypeId);
        }
        return accountManuorgAndCosttype;
    }

    private Map<Long, Map<Long, Set<OutSourcePrice>>> getOurPriceMap(Map<String, Long> accountManuorgAndCosttype) {
        HashMap<Long, Map<Long, Set<OutSourcePrice>>> costtypeAndMaterialAndOutPrice = new HashMap<Long, Map<Long, Set<OutSourcePrice>>>(16);
        for (Long costtype : accountManuorgAndCosttype.values()) {
            QFilter filter = QFilter.of((String)"billstatus ='C' and costtype =?", (Object[])new Object[]{costtype});
            DynamicObjectCollection allOutSourcePrice = QueryServiceHelper.query((String)"cad_outsourceprice", (String)"id,material,element,subelement,price,effectdate,expdate,keycol,keycolid,entryentity.extelement extelement,entryentity.extsubelement extsubelement,entryentity.amount amount", (QFilter[])new QFilter[]{filter});
            HashMap<Long, Set> map = new HashMap<Long, Set>();
            for (DynamicObject outPriceDO : allOutSourcePrice) {
                long material = outPriceDO.getLong("material");
                Long keycolid = outPriceDO.getLong("keycolid");
                Set set = map.computeIfAbsent(keycolid, s -> new HashSet());
                Long element = outPriceDO.getLong("element");
                Long subElement = outPriceDO.getLong("subelement");
                BigDecimal price = outPriceDO.getBigDecimal("price");
                Date effectDate = outPriceDO.getDate("effectdate");
                Date expDate = outPriceDO.getDate("expdate");
                String keycol = outPriceDO.getString("keycol");
                OutSourcePrice outSource = new OutSourcePrice(Long.valueOf(material), Integer.valueOf(1), element, subElement, price, effectDate, expDate, keycol, keycolid);
                set.add(outSource);
                Long extElement = outPriceDO.getLong("extelement");
                if (CadEmptyUtils.isEmpty((Long)extElement)) continue;
                Long extSubElement = outPriceDO.getLong("extsubelement");
                BigDecimal extPrice = outPriceDO.getBigDecimal("amount");
                OutSourcePrice extOutPrice = new OutSourcePrice(Long.valueOf(material), Integer.valueOf(2), extElement, extSubElement, extPrice, effectDate, expDate, keycol, keycolid);
                set.add(extOutPrice);
            }
            costtypeAndMaterialAndOutPrice.put(costtype, map);
        }
        return costtypeAndMaterialAndOutPrice;
    }
}

