/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.yieldcollection;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class FactnedOutputBillSaveOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FactnedOutputBillSaveOpPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("lastqty");
        fieldKeys.add("completeqty");
        fieldKeys.add("completetype");
        fieldKeys.add("plannedoutput");
        fieldKeys.add("entryentity");
        fieldKeys.add("qty");
        fieldKeys.add("warehouse");
        fieldKeys.add("entrycost");
        fieldKeys.add("appnum");
        fieldKeys.add("material");
        fieldKeys.add("auxpty");
        fieldKeys.add("project");
        fieldKeys.add("tracknumber");
        fieldKeys.add("configuredcode");
        fieldKeys.add("lot");
        fieldKeys.add("keycol");
        fieldKeys.add("keycolid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObjectCollection entryCost;
                    DynamicObject factOutputBill = dataEntity.getDataEntity();
                    String appNum = factOutputBill.getString("appnum");
                    if ("aca".equals(appNum)) {
                        return;
                    }
                    BigDecimal completeqty = factOutputBill.getBigDecimal("completeqty");
                    BigDecimal qts = new BigDecimal(0);
                    DynamicObjectCollection factEntrys = factOutputBill.getDynamicObjectCollection("entryentity");
                    for (DynamicObject factEntry : factEntrys) {
                        BigDecimal qty = factEntry.getBigDecimal("qty");
                        qts = qts.add(qty);
                    }
                    ArrayList<String> inType = new ArrayList<String>(10);
                    inType.add("WIPCOMPELETE");
                    inType.add("WIPCOMPELETEBACK");
                    inType.add("PRODUCTCOMPELETE");
                    inType.add("PRODUCTCOMPELETEBACK");
                    inType.add("WWGRK");
                    if (inType.contains(factOutputBill.getString("completetype"))) continue;
                    Long warehouse = 0L;
                    warehouse = factOutputBill.get("warehouse") instanceof DynamicObject ? Long.valueOf(factOutputBill.getLong("warehouse.id")) : Long.valueOf(factOutputBill.getLong("warehouse"));
                    if (CadEmptyUtils.isEmpty((Long)warehouse)) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4ed3\u5e93\u3002", (String)"FactnedOutputBillSaveOpPlugin_1", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    }
                    if (qts.compareTo(completeqty) != 0) {
                        logger.info("qts{},completeqty{}", (Object)qts, (Object)completeqty);
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u4fdd\u5b58\uff0c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u57fa\u672c\u6570\u91cf\u5408\u8ba1\u4e0d\u7b49\u4e8e\u57fa\u672c\u6570\u91cf\u3002", (String)"FactnedOutputBillSaveOpPlugin_2", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    }
                    if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(entryCost = factOutputBill.getDynamicObjectCollection("entrycost")))) continue;
                    String message = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u4e0d\u80fd\u4fdd\u5b58\u3002\u6210\u672c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FactnedOutputBillSaveOpPlugin_5", (String)"macc-cad-opplugin", (Object[])new Object[0]), (String)"FactnedOutputBillSaveOpPlugin_5", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                    this.addFatalErrorMessage(dataEntity, message);
                }
            }
        });
    }
}

