/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.yieldcollection;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PlannedOutputBillSaveOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PlannedOutputBillSaveOpPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("planneddate");
        fieldKeys.add("bizdate");
        fieldKeys.add("qty");
        fieldKeys.add("totalinqty");
        fieldKeys.add("baseunit");
        fieldKeys.add("creator.id");
        fieldKeys.add("totalinqty");
        fieldKeys.add("wipqty");
        fieldKeys.add("closestatu");
        fieldKeys.add("source");
        fieldKeys.add("fromlogid");
        fieldKeys.add("appnum");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject planOutputBill = dataEntity.getDataEntity();
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                    if (!"0".equals(String.valueOf(planOutputBill.getInt("source")))) continue;
                    Date bizdate = planOutputBill.getDate("bizdate");
                    Date planneddate = planOutputBill.getDate("planneddate");
                    try {
                        if (formatter.parse(formatter.format(bizdate)).compareTo(formatter.parse(formatter.format(planneddate))) <= 0) continue;
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u6761\u4ef6\uff1a\u201c\u8ba1\u5212\u5b8c\u5de5\u65e5\u671f\u2265\u4e1a\u52a1\u65e5\u671f\u201d\u3002", (String)"PlannedOutputBillSaveOpPlugin_0", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    }
                    catch (ParseException e) {
                        logger.error((Throwable)e);
                    }
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        Object[] datas = e.getDataEntities();
        if (CadEmptyUtils.isEmpty((Object[])datas) || "aca".equals(datas[0].getString("appnum"))) {
            return;
        }
    }
}

