/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin.yieldcollection;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PlannedOutputEnableOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("closestatu");
        fieldKeys.add("costobject.bizstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject planOutputBill = dataEntity.getDataEntity();
                    if (!planOutputBill.getBoolean("closestatu")) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u542f\u7528\u3002\u8ba1\u5212\u751f\u4ea7\u6570\u91cf\u5f52\u96c6\u672a\u5173\u95ed\u3002", (String)"PlannedOutputEnableOpPlugin_0", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    }
                    if (!"B".equalsIgnoreCase(planOutputBill.getString("costobject.bizstatus"))) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u542f\u7528\uff0c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5df2\u7ed3\u7b97\u3002", (String)"PlannedOutputEnableOpPlugin_1", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] plannedOutput;
        DynamicObject[] datas = e.getDataEntities();
        HashSet<Object> ids = new HashSet<Object>(16);
        for (DynamicObject data : datas) {
            ids.add(data.getPkValue());
        }
        DynamicObject[] dynamicObjectArray = plannedOutput = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_plannedoutputbill"));
        int n = dynamicObjectArray.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject plan;
            BigDecimal wipQty = (plan = dynamicObjectArray[i]).getBigDecimal("qty").subtract(plan.getBigDecimal("totalinqty"));
            plan.set("wipqty", (Object)(BigDecimal.ZERO.compareTo(wipQty) < 0 ? wipQty : Integer.valueOf(0)));
            plan.set("closeuser", (Object)0);
            plan.set("closedatetime", null);
            plan.set("closestyle", null);
            plan.set("closestatu", (Object)false);
        }
        SaveServiceHelper.update((DynamicObject[])plannedOutput);
    }
}

