/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.bom;

import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;

public class BomSettingService {
    private static final Log logger = LogFactory.getLog(BomSettingService.class);
    private static ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public static void updateMatCalcProp(List<Long> bomSettingIds, String matCalcProp) {
        QFilter filter = new QFilter("id", "in", bomSettingIds);
        DynamicObject[] bomSettingBills = BusinessDataServiceHelper.load((String)"cad_bomsetting", (String)"id, number, matcalcprop, isdowncalc", (QFilter[])new QFilter[]{filter});
        HashSet<String> descriptions = new HashSet<String>(16);
        String desc = ResManager.loadKDString((String)"\u7f16\u53f7%1$s\uff0c\u6279\u91cf\u4fee\u6539\u6210\u529f\u3002\u7269\u6599\u5377\u7b97\u5c5e\u6027:%2$s -> %3$s", (String)"BomSettingService_6", (String)"macc-cad-business", (Object[])new Object[0]);
        for (DynamicObject bill : bomSettingBills) {
            descriptions.add(String.format(desc, bill.getString("number"), BomSettingService.getMatCalcProp(bill.getString("matcalcprop")), BomSettingService.getMatCalcProp(matCalcProp)));
            bill.set("matcalcprop", (Object)matCalcProp);
            if ("B".equals(matCalcProp)) {
                bill.set("isdowncalc", (Object)false);
                continue;
            }
            bill.set("isdowncalc", (Object)true);
        }
        logger.info("\u6210\u672cbom\u8bbe\u7f6e\u6279\u91cf\u4fee\u6539\u7269\u6599\u5377\u7b97\u5c5e\u6027\u5355\u636eid\u96c6\u5408{}", bomSettingIds);
        SaveServiceHelper.update((DynamicObject[])bomSettingBills);
        String opType = ResManager.loadKDString((String)"\u6279\u91cf\u4fee\u6539", (String)"BomSettingService_1", (String)"macc-cad-business", (Object[])new Object[0]);
        WriteLogUtils.addBatchLog((ILogService)logService, (RequestContext)RequestContext.get(), (String)"0DDNKGUZRMR8", (String)opType, descriptions, (String)"cad_bomsetting");
    }

    private static String getMatCalcProp(String matCalcProp) {
        if (CadEmptyUtils.isEmpty((String)matCalcProp)) {
            return matCalcProp;
        }
        String resultProp = "";
        switch (matCalcProp) {
            case "A": {
                resultProp = ResManager.loadKDString((String)"\u81ea\u5236", (String)"BomSettingService_2", (String)"macc-cad-business", (Object[])new Object[0]);
                break;
            }
            case "B": {
                resultProp = ResManager.loadKDString((String)"\u5916\u8d2d", (String)"BomSettingService_3", (String)"macc-cad-business", (Object[])new Object[0]);
                break;
            }
            case "C": {
                resultProp = ResManager.loadKDString((String)"\u59d4\u5916", (String)"BomSettingService_4", (String)"macc-cad-business", (Object[])new Object[0]);
            }
        }
        return ResManager.loadKDString((String)resultProp, (String)"BomSettingService_1", (String)"BomSettingService_5", (Object[])new Object[0]);
    }
}

