/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.bom;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.CalcDimenHelper;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class SyncBomHandle {
    private static final Log logger = LogFactory.getLog(SyncBomHandle.class);

    public static void syncBom(String entity, List<Object> bomIds) {
        int syncBomBatchSize = CadBgParamUtils.getCadParamForInt((String)"pushSyncBomBatchSize", (int)5000);
        Lists.partition(bomIds, (int)syncBomBatchSize).forEach(bomIdSubList -> {
            Map<DynamicObject, Set<Long>> ruleAndIds = SyncBomHandle.filterBomIds(entity, bomIdSubList);
            SyncBomHandle.doSyncBom(entity, ruleAndIds);
        });
    }

    private static void doSyncBom(String entity, Map<DynamicObject, Set<Long>> ruleAndIds) {
        Date now = TimeServiceHelper.now();
        ArrayList<DynamicObject> boms = new ArrayList<DynamicObject>();
        List<DynamicObject> tempCostBom = null;
        for (Map.Entry<DynamicObject, Set<Long>> entry : ruleAndIds.entrySet()) {
            tempCostBom = SyncBomHandle.createCostBom(entity, entry.getKey(), entry.getValue());
            SyncBomHandle.setCommonData(tempCostBom, now, entry.getKey());
            boms.addAll(tempCostBom);
        }
        SyncBomHandle.saveCostBom(boms);
    }

    private static void setCommonData(List<DynamicObject> boms, Date now, DynamicObject rule) {
        if (boms.isEmpty()) {
            return;
        }
        Object org = rule.get("calorg");
        Object syncUser = rule.get("syncuser");
        long[] ids = DB.genGlobalLongIds((int)boms.size());
        int index = 0;
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter auxptFilter = new QFilter("isuseauxpty", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection materials = QueryServiceHelper.query((String)"bd_material", (String)"id,masterid as masterId", (QFilter[])new QFilter[]{statusFilter, enableFilter, auxptFilter});
        HashSet<Long> matWithAuxpt = new HashSet<Long>(10);
        for (DynamicObject material : materials) {
            matWithAuxpt.add(material.getLong("masterId"));
        }
        for (DynamicObject bom : boms) {
            bom.set("createorg", org);
            bom.set("useorg", org);
            bom.set("org", org);
            bom.set("enable", (Object)"1");
            bom.set("ctrlstrategy", (Object)"5");
            bom.set("creator", syncUser);
            bom.set("createtime", (Object)now);
            if (matWithAuxpt.contains(bom.getLong("material")) && (bom.get("auxproperty") == null || bom.getLong("auxproperty") == 0L)) {
                bom.set("status", (Object)"A");
            } else {
                bom.set("status", (Object)"C");
                bom.set("auditor", syncUser);
                bom.set("auditdate", (Object)now);
            }
            bom.set("id", (Object)ids[index]);
            bom.set("masterid", (Object)ids[index]);
            ++index;
        }
    }

    private static QFilter parseQfilter(DynamicObject rule) {
        String fsStr = rule.getString("filter_tag");
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)fsStr, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(MetadataServiceHelper.getDataEntityType((String)"pdm_mftbom"), condition);
        fb.buildFilter();
        QFilter fbQFilter = fb.getQFilter();
        QFilter matTypeFilter = new QFilter("material.masterid.configproperties", "!=", (Object)"2");
        fbQFilter.and(matTypeFilter);
        return fbQFilter;
    }

    private static List<DynamicObject> createCostBom(String entity, DynamicObject rule, Set<Long> productBomIds) {
        QFilter qFilter;
        QFilter ruleFs = SyncBomHandle.parseQfilter(rule);
        QFilter fs = new QFilter("id", "in", productBomIds);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u89c4\u5219\uff1a%1$s,\u540c\u6b65\u89c4\u5219\u8fc7\u6ee4\u6761\u4ef6\uff1a%2$s", (String)"SyncBomHandle_8", (String)"macc-cad-business", (Object[])new Object[0]), rule, ruleFs));
        if (ruleFs != null) {
            fs.and(ruleFs);
        }
        HashMap<Long, DynamicObject> costBoms = new HashMap<Long, DynamicObject>();
        DataSet datas = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.business.bom.SyncBomHandle.createCostBom", (String)entity, (String)"id,copentry.id,number,type,group,material.masterid,version,replaceno,yieldrate,auxproperty,configuredcode,iscoproduct,auditdate,copentry.copentrytype,copentry.copentrymaterial.masterid,copentry.copentryunit,copentry.copentryqty,copentry.copentryoperation,copentry.copentryvaliddate,copentry.copentryinvaliddate,copentry.copentryversion,copentry.copentryauxproperty,createorg,ctrlstrategy", (QFilter[])fs.toArray(), null);
        Map<Long, Date> bomSyncDateMap = SyncBomHandle.getPdm_eco(productBomIds);
        Long id = null;
        DynamicObject costBom = null;
        for (Row row : datas) {
            id = row.getLong("id");
            costBom = (DynamicObject)costBoms.get(id);
            if (costBom == null) {
                costBom = BusinessDataServiceHelper.newDynamicObject((String)"cad_costbom");
                costBoms.put(id, costBom);
                SyncBomHandle.setBomHeadInfo(costBom, row, bomSyncDateMap);
            }
            SyncBomHandle.setBomCopentryInfo(costBom, row);
        }
        if (costBoms.isEmpty()) {
            return new ArrayList<DynamicObject>();
        }
        fs = new QFilter("id", "in", costBoms.keySet());
        boolean isreplace = rule.getBoolean("isreplace");
        boolean isjumplevel = rule.getBoolean("isjumplevel");
        if (!isreplace) {
            qFilter = new QFilter("entry.entryisreplace", "=", (Object)false);
            fs = fs.and(qFilter);
        }
        if (!isjumplevel) {
            qFilter = new QFilter("entry.entryisjumplevel", "=", (Object)false);
            fs = fs.and(qFilter);
        }
        DataSet entryData = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.business.bom.SyncBomHandle.createCostBom", (String)entity, (String)"id,entry.id,entry.entrymaterial.masterid,entry.entrytype,entry.entryownertype,entry.entryqty,entry.entryunit,entry.entryversion,entry.entryqtytype,entry.entryqtynumerator,entry.entryqtydenominator,entry.entryfixscrap,entry.entryscraprate,entry.entryvaliddate,entry.entryinvaliddate,entry.entryauxproperty,entry.entryowner,entry.entryconfiguredcode,entry.entryisreplace,entry.entryisjumplevel", (QFilter[])fs.toArray(), null);
        sb.append("#");
        sb.append(entryData);
        sb.append("#");
        for (Row row : entryData) {
            id = row.getLong("id");
            costBom = (DynamicObject)costBoms.get(id);
            sb.append(String.format(ResManager.loadKDString((String)"BOM\u7ec4\u4ef6\u4fe1\u606f\uff1aBomId:%1$s,Bom\u7ec4\u4ef6:%2$s,Bom\u7ec4\u4ef6number:%3$s", (String)"SyncBomHandle_9", (String)"macc-cad-business", (Object[])new Object[0]), id, costBom, costBom.getString("number")));
            if (costBom == null) continue;
            SyncBomHandle.setBomEntryInfo(costBom, row);
        }
        logger.info(sb.toString());
        return new ArrayList<DynamicObject>(costBoms.values());
    }

    private static void setBomCopentryInfo(DynamicObject costBom, Row row) {
        Object materialId = row.get("copentry.copentrymaterial.masterid");
        if (materialId == null) {
            return;
        }
        DynamicObjectCollection costCopentry = costBom.getDynamicObjectCollection("copentry");
        DynamicObject addNew = costCopentry.addNew();
        addNew.set("copentrytype", (Object)row.getString("copentry.copentrytype"));
        addNew.set("copentrymaterial", materialId);
        addNew.set("copentryunit", row.get("copentry.copentryunit"));
        addNew.set("copentryqty", row.get("copentry.copentryqty"));
        addNew.set("copentryoperation", row.get("copentry.copentryoperation"));
        addNew.set("copentryvaliddate", row.get("copentry.copentryvaliddate"));
        addNew.set("copentryinvaliddate", row.get("copentry.copentryinvaliddate"));
        addNew.set("copentryversion", row.get("copentry.copentryversion"));
        addNew.set("copentryauxproperty", (Object)CalcDimenHelper.getAffectAuxpty((Object)Long.parseLong(materialId.toString()), (Object)row.getLong("copentry.copentryauxproperty")));
        HashMap<String, Object> keycolMap = new HashMap<String, Object>(16);
        keycolMap.put("material", addNew.get("copentrymaterial"));
        keycolMap.put("auxproperty", addNew.get("copentryauxproperty"));
        keycolMap.put("configuredcode", costBom.get("configuredcode"));
        addNew.set("copentrykeycol", (Object)CalcKeyHelper.getCalcKey(keycolMap, new ArrayList(), (boolean)true).getKeycol());
    }

    private static void setBomEntryInfo(DynamicObject costBom, Row row) {
        Object materialId = row.get("entry.entrymaterial.masterid");
        if (materialId == null) {
            return;
        }
        DynamicObjectCollection entryentity = costBom.getDynamicObjectCollection("entry");
        DynamicObject addNew = entryentity.addNew();
        addNew.set("entrytype", (Object)row.getString("entry.entrytype"));
        addNew.set("entrymaterial", materialId);
        addNew.set("ownertype", row.get("entry.entryownertype"));
        addNew.set("entryqty", row.get("entry.entryqty"));
        addNew.set("entryunit", row.get("entry.entryunit"));
        addNew.set("entryversion", row.get("entry.entryversion"));
        addNew.set("entryqtytype", row.get("entry.entryqtytype"));
        addNew.set("entryqtynumerator", row.get("entry.entryqtynumerator"));
        addNew.set("entryqtydenominator", row.get("entry.entryqtydenominator"));
        addNew.set("entryfixscrap", row.get("entry.entryfixscrap"));
        addNew.set("entryscraprate", row.get("entry.entryscraprate"));
        addNew.set("entryvaliddate", row.get("entry.entryvaliddate"));
        addNew.set("entryinvaliddate", row.get("entry.entryinvaliddate"));
        addNew.set("entryauxproperty", (Object)CalcDimenHelper.getAffectAuxpty((Object)Long.parseLong(materialId.toString()), (Object)row.getLong("entry.entryauxproperty")));
        addNew.set("owner", (Object)row.getLong("entry.entryowner"));
        addNew.set("entryconfiguredcode", row.get("entry.entryconfiguredcode"));
        addNew.set("entryisreplace", row.get("entry.entryisreplace"));
        addNew.set("entryisjumplevel", row.get("entry.entryisjumplevel"));
        HashMap<String, Object> keycolMap = new HashMap<String, Object>(16);
        keycolMap.put("material", addNew.get("entrymaterial"));
        keycolMap.put("auxproperty", addNew.get("entryauxproperty"));
        keycolMap.put("configuredcode", addNew.get("entryconfiguredcode"));
        addNew.set("entrykeycol", (Object)CalcKeyHelper.getCalcKey(keycolMap, new ArrayList(), (boolean)true).getKeycol());
    }

    private static void setBomHeadInfo(DynamicObject costBom, Row row, Map<Long, Date> bomSyncDateMap) {
        costBom.set("sourceid", row.get("id"));
        costBom.set("number", row.get("number"));
        costBom.set("type", row.get("type"));
        costBom.set("group", row.get("group"));
        costBom.set("material", row.get("material.masterid"));
        costBom.set("version", row.get("version"));
        costBom.set("replaceno", row.get("replaceno"));
        costBom.set("yieldrate", row.get("yieldrate"));
        costBom.set("auxproperty", (Object)CalcDimenHelper.getAffectAuxpty((Object)row.getLong("material.masterid"), (Object)row.getLong("auxproperty")));
        costBom.set("iscoproduct", row.get("iscoproduct"));
        costBom.set("manuorg", row.get("createorg"));
        costBom.set("configuredcode", row.get("configuredcode"));
        costBom.set("synctime", row.get("auditdate"));
        HashMap<String, Object> keycolMap = new HashMap<String, Object>(16);
        keycolMap.put("material", costBom.get("material"));
        keycolMap.put("auxproperty", costBom.get("auxproperty"));
        keycolMap.put("configuredcode", costBom.get("configuredcode"));
        costBom.set("keycol", (Object)CalcKeyHelper.getCalcKey(keycolMap, new ArrayList(), (boolean)true).getKeycol());
        if (bomSyncDateMap.get(row.getLong("id")) == null) {
            costBom.set("synctime", (Object)row.getDate("auditdate"));
        } else if (bomSyncDateMap.get(row.getLong("id")).after(row.getDate("auditdate"))) {
            costBom.set("synctime", (Object)bomSyncDateMap.get(row.getLong("id")));
        } else {
            costBom.set("synctime", (Object)row.getDate("auditdate"));
        }
    }

    private static void saveCostBom(List<DynamicObject> productBoms) {
        if (productBoms.isEmpty()) {
            return;
        }
        try (TXHandle tx = TX.requiresNew((String)"kd.macc.cad.business.bom.SyncBomHandle.saveCostBom");){
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
            for (DynamicObject productBom : productBoms) {
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)productBom.getDynamicObjectCollection("entry"))) continue;
                list.add(productBom);
            }
            Object[] array = list.toArray(new DynamicObject[0]);
            if (CadEmptyUtils.isEmpty((Object[])array)) {
                return;
            }
            try {
                SaveServiceHelper.save((DynamicObject[])array);
                SyncBomHandle.insertUseOrgData((DynamicObject[])array);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("\u6210\u672cBOM\u540c\u6b65\u65f6\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
                throw e;
            }
        }
    }

    private static void insertUseOrgData(DynamicObject[] productBoms) {
        IDataEntityType entityType = productBoms[0].getDataEntityType();
        String tb = entityType.getAlias() + "_U";
        String insertSql = "insert into " + tb + " (fuseorgid, FDataID) values (?, ?)";
        ArrayList<Object[]> params = new ArrayList<Object[]>(10);
        for (DynamicObject pro : productBoms) {
            params.add(new Object[]{pro.get("createorg"), pro.getPkValue()});
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)entityType.getDBRouteKey()), (String)insertSql, params);
    }

    private static Map<DynamicObject, Set<Long>> filterBomIds(String entity, List<Object> bomIds) {
        Map<Long, List<Long>> billOrgs = SyncBomHandle.getCalOrg(entity, bomIds);
        Map<Long, DynamicObject> orgRules = SyncBomHandle.getOrgSyncRule(billOrgs);
        HashMap<DynamicObject, Set<Long>> idGroup = new HashMap<DynamicObject, Set<Long>>();
        for (Map.Entry<Long, List<Long>> entry : billOrgs.entrySet()) {
            for (Long orgId : entry.getValue()) {
                DynamicObject rule = orgRules.get(orgId);
                if (rule == null) continue;
                HashSet<Long> ids = (HashSet<Long>)idGroup.get(rule);
                if (ids == null) {
                    ids = new HashSet<Long>();
                    idGroup.put(rule, ids);
                }
                ids.add(entry.getKey());
            }
        }
        return idGroup;
    }

    private static Map<Long, DynamicObject> getOrgSyncRule(Map<Long, List<Long>> billOrgs) {
        HashSet<Long> orgIds = new HashSet<Long>();
        for (List<Long> orgs : billOrgs.values()) {
            orgIds.addAll(orgs);
        }
        if (orgIds.isEmpty()) {
            return new HashMap<Long, DynamicObject>();
        }
        HashMap<Long, DynamicObject> ruleMap = new HashMap<Long, DynamicObject>(orgIds.size());
        QFilter fs = new QFilter("calorg", "in", orgIds);
        DynamicObjectCollection rules = QueryServiceHelper.query((String)"cad_syncbom_rule", (String)"calorg,syncuser,filter_tag,isreplace,isjumplevel", (QFilter[])fs.toArray());
        for (DynamicObject rule : rules) {
            ruleMap.put(rule.getLong("calorg"), rule);
        }
        return ruleMap;
    }

    private static Map<Long, List<Long>> getCalOrg(String entity, List<Object> bomIds) {
        QFilter fs = new QFilter("id", "in", bomIds);
        DataSet data = QueryServiceHelper.queryDataSet((String)"", (String)entity, (String)"id,createorg", (QFilter[])fs.toArray(), null);
        HashMap<Long, Long> billOrg = new HashMap<Long, Long>();
        for (Row row : data) {
            billOrg.put(row.getLong("id"), row.getLong("createorg"));
        }
        HashMap<Long, List<Long>> cacheAccOrg = new HashMap<Long, List<Long>>();
        HashMap<Long, List<Long>> findResult = new HashMap<Long, List<Long>>();
        Map<Long, Long> parents = SyncBomHandle.findParents(new ArrayList<Long>(billOrg.values()));
        for (int count = 0; !parents.isEmpty() && count <= 10; ++count) {
            parents = SyncBomHandle.findAccOrg(parents, findResult, cacheAccOrg);
            SyncBomHandle.replaceNextParents(parents);
        }
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(16);
        for (Map.Entry entry : billOrg.entrySet()) {
            result.put((Long)entry.getKey(), (List<Long>)findResult.get(entry.getValue()));
        }
        return result;
    }

    private static void replaceNextParents(Map<Long, Long> parents) {
        if (parents.isEmpty()) {
            return;
        }
        Map<Long, Long> nextParent = SyncBomHandle.findParents(new ArrayList<Long>(parents.values()));
        for (Map.Entry<Long, Long> entry : parents.entrySet()) {
            parents.put(entry.getKey(), nextParent.get(entry.getValue()));
        }
    }

    private static Map<Long, Long> findParents(List<Long> orgIds) {
        return OrgUnitServiceHelper.getDirectSuperiorOrg((String)"04", orgIds);
    }

    private static Map<Long, Long> findAccOrg(Map<Long, Long> parents, Map<Long, List<Long>> findResult, Map<Long, List<Long>> cacheAccOrg) {
        HashMap<Long, Long> notFind = new HashMap<Long, Long>();
        for (Map.Entry<Long, Long> entry : parents.entrySet()) {
            List<Long> fromOrg = SyncBomHandle.getFromOrgs(entry.getKey(), cacheAccOrg);
            if (fromOrg == null) {
                Long parentId = entry.getValue();
                if (parentId == null || parentId == 0L) {
                    findResult.put(entry.getKey(), null);
                    continue;
                }
                fromOrg = SyncBomHandle.getFromOrgs(parentId, cacheAccOrg);
                if (fromOrg == null) {
                    notFind.put(entry.getKey(), parentId);
                    continue;
                }
                findResult.put(entry.getKey(), fromOrg);
                continue;
            }
            findResult.put(entry.getKey(), fromOrg);
        }
        return notFind;
    }

    private static List<Long> getFromOrgs(Long orgId, Map<Long, List<Long>> cacheAccOrg) {
        if (cacheAccOrg.containsKey(orgId)) {
            return cacheAccOrg.get(orgId);
        }
        List fromOrgs = OrgUnitServiceHelper.getFromOrgs((String)"04", (Long)orgId, (String)"10", (boolean)true);
        if (fromOrgs != null && fromOrgs.isEmpty()) {
            fromOrgs = null;
        }
        cacheAccOrg.put(orgId, fromOrgs);
        return fromOrgs;
    }

    private static Map<Long, Date> getPdm_eco(Set<Long> bomIds) {
        HashMap<Long, Date> map = new HashMap<Long, Date>(16);
        SyncBomHandle.setPdm_eco(map, bomIds, "pdm_bom_eco");
        SyncBomHandle.setPdm_eco(map, bomIds, "pdm_eco");
        return map;
    }

    private static void setPdm_eco(Map<Long, Date> map, Set<Long> bomIds, String dataName) {
        QFilter bomIdQF = new QFilter("pentry.pentrybom", "in", bomIds);
        QFilter statusQF = new QFilter("billstatus", "=", (Object)"C");
        QFilter enableQF = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection pdmEcos = QueryServiceHelper.query((String)dataName, (String)"type,pentry.pentrybom.id,auditdate", (QFilter[])new QFilter[]{bomIdQF, statusQF, enableQF});
        for (DynamicObject pdmEco : pdmEcos) {
            if (!map.containsKey(pdmEco.getLong("pentry.pentrybom.id"))) {
                map.put(pdmEco.getLong("pentry.pentrybom.id"), pdmEco.getDate("auditdate"));
                continue;
            }
            if (!map.get(pdmEco.getLong("pentry.pentrybom.id")).before(pdmEco.getDate("auditdate"))) continue;
            map.put(pdmEco.getLong("pentry.pentrybom.id"), pdmEco.getDate("auditdate"));
        }
    }
}

