/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.calc;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.algox.StandCostCalculateService;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.business.calc.CalcChangedInfo;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang.StringUtils;

public class AutoStandCostCalcHandler {
    public static Map<Long, CalcChangedInfo> getCostTypeCalcChangeMap(QFilter filter) {
        HashMap<Long, CalcChangedInfo> result = new HashMap<Long, CalcChangedInfo>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AutoStandCostCalcTask", (String)"cad_calchangerecord", (String)"id,costtype,material,keycol,costtype.currency.priceprecision,costtype.name", (QFilter[])new QFilter[]{filter}, null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long costTypeId = row.getLong("costtype");
                CalcChangedInfo info = result.computeIfAbsent(costTypeId, s -> new CalcChangedInfo());
                info.getChangeRecordId().add(row.getLong("id"));
                info.setCostTypeId(costTypeId);
                info.setCostTypeName(row.getString("costtype.name"));
                info.setPricePrecision(row.getInteger("costtype.currency.priceprecision"));
                Long matId = row.getLong("material");
                if (!info.getMatIds().contains(matId)) {
                    info.getMatIds().add(matId);
                }
                String keyCol = row.getString("keycol");
                if (info.getKeyCols().contains(keyCol)) continue;
                info.getKeyCols().add(keyCol);
            }
        }
        return result;
    }

    public static void doCalc(CalcChangedInfo info) {
        StandCostCalcParam param = new StandCostCalcParam();
        Date calcDate = new Date();
        param.setCalcDate(calcDate);
        param.setTaskId(DBServiceHelper.genGlobalLongId());
        param.setCostTypeId(String.valueOf(info.getCostTypeId()));
        param.setPriceprecision(info.getPricePrecision());
        List<Long> matIds = info.getMatIds();
        if (CadEmptyUtils.isEmpty(matIds)) {
            param.setScopetype(0);
        } else {
            param.setMatids(matIds);
            param.setKeycols(info.getKeyCols());
            param.setScopetype(1);
        }
        StandCostCalculateService standCostCalculateService = new StandCostCalculateService();
        standCostCalculateService.calculate(param);
    }

    public static void updateStatus(Set<Long> ids, String status) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        DB.execute((DBRoute)new DBRoute("cal"), (String)("update t_cad_calchangerecord set fstatus = '" + status + "' where fid in (" + StringUtils.join(ids, (char)',') + ")"));
    }
}

