/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.calc;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.algox.mfgfee.helper.MfgfeeAllocHelper;
import kd.macc.cad.algox.utils.CadEmptyUtils;
import kd.macc.cad.common.enums.AcaMutexEnum;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.utils.AcaMutexHelper;
import org.apache.commons.lang3.StringUtils;

public class InproAlloStdValListHelper {
    private static final Log LOGGER = LogFactory.getLog(InproAlloStdValListHelper.class);
    private static final String ORG = "org";
    private static final String COSTACCOUNT = "costAccount";
    private static final String PERIOD = "period";
    private static Map<Long, String> costcenterCalMap = new HashMap<Long, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String inproCal(Long orgId, Long costAccountId, Long period, String sourcetype) {
        LOGGER.info("\u81ea\u5b9a\u4e49\u5728\u4ea7\u54c1\u5206\u914d\u6807\u51c6-\u8ba1\u7b97\u5f00\u59cb");
        String lockErrStr = null;
        StringBuilder msg = new StringBuilder();
        lockErrStr = AcaMutexHelper.requireMutex((AcaMutexEnum)AcaMutexEnum.CALCULATE, (long)costAccountId);
        if (StringUtils.isNotEmpty((CharSequence)lockErrStr)) {
            msg.append(lockErrStr);
            return String.valueOf(msg);
        }
        try {
            Long start = System.currentTimeMillis();
            InproAlloStdValListHelper.deleteInPro(orgId, costAccountId, period);
            Map<Long, Set<Long>> costCenterMap = InproAlloStdValListHelper.queryProAllocStd(orgId, costAccountId);
            HashSet costAgentSet = new HashSet();
            ArrayList costAgentList = new ArrayList();
            costCenterMap.forEach((k, v) -> costAgentSet.addAll(v));
            costAgentList.addAll(costAgentSet);
            ArrayList<DynamicObject> inProList = new ArrayList<DynamicObject>();
            if (costAgentList == null || costAgentList.isEmpty()) {
                String string = InproAlloStdValListHelper.genInfoMsg(inProList);
                return string;
            }
            MfgfeeAllocHelper mfgfeeAllocHelper = new MfgfeeAllocHelper();
            DataSet dataSet = null;
            try {
                dataSet = mfgfeeAllocHelper.getCostdriverStdVal(orgId, costAccountId, period, "aca", costAgentList, false);
            }
            catch (Exception e) {
                LOGGER.error("\u81ea\u5b9a\u4e49\u5728\u4ea7\u54c1\u5206\u914d\u6807\u51c6\u503c\u8ba1\u7b97\u5931\u8d25", (Throwable)e);
            }
            MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)"cad_inproallocstdval");
            if (dataSet != null) {
                dataSet.forEach(arg_0 -> InproAlloStdValListHelper.lambda$inproCal$1(costCenterMap, (DynamicObjectType)dynamicObjectType, orgId, costAccountId, period, sourcetype, inProList, arg_0));
                if (!CadEmptyUtils.isEmpty(inProList)) {
                    String[] numberArr = CodeRuleServiceHelper.getBatchNumber((String)"cad_inproallocstdval", (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"cad_inproallocstdval"), (String)"", (int)inProList.size());
                    int i = 0;
                    for (DynamicObject dyn : inProList) {
                        dyn.set("billno", (Object)numberArr[i++]);
                    }
                    MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cad_inproallocstdval");
                    SaveServiceHelper.save((IDataEntityType)type, (Object[])inProList.toArray());
                }
            }
            LOGGER.info("\u81ea\u5b9a\u4e49\u5728\u4ea7\u54c1\u5206\u914d\u6807\u51c6-\u8ba1\u7b97\u7ed3\u675f\uff0c\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
            String string = InproAlloStdValListHelper.genInfoMsg(inProList);
            return string;
        }
        finally {
            if (StringUtils.isEmpty((CharSequence)lockErrStr)) {
                AcaMutexHelper.releaseMutex((AcaMutexEnum)AcaMutexEnum.CALCULATE, (long)costAccountId);
            }
        }
    }

    private static String genInfoMsg(List<DynamicObject> inProList) {
        String info;
        int sucSize = 0;
        int failSize = 0;
        StringBuilder errMsg = new StringBuilder();
        StringBuilder infoMsg = new StringBuilder();
        if (sucSize > 0 || failSize == 0) {
            info = String.format(ResManager.loadKDString((String)"\u5f15\u5165\u6210\u529f%s\u6761\u6570\u636e\u3002", (String)"InproAlloStdValListHelper_0", (String)"macc-cad-business", (Object[])new Object[0]), inProList.size());
            infoMsg.append(info);
        }
        if (failSize > 0) {
            info = String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25%s\u6761\u6570\u636e\u3002", (String)"InproAlloStdValListHelper_1", (String)"macc-cad-business", (Object[])new Object[0]), inProList.size());
            infoMsg.append(info);
            infoMsg.append((CharSequence)errMsg);
        }
        return String.valueOf(infoMsg);
    }

    private static void deleteInPro(Long org, Long costAccount, Long period) {
        QFilter orgFilter = new QFilter(ORG, "=", (Object)org);
        QFilter costAccountFilter = new QFilter(COSTACCOUNT, "=", (Object)costAccount);
        QFilter periodFilter = new QFilter(PERIOD, "=", (Object)period);
        DeleteServiceHelper.delete((String)"cad_inproallocstdval", (QFilter[])new QFilter[]{orgFilter, costAccountFilter, periodFilter});
    }

    private static Map<Long, Set<Long>> queryProAllocStd(Long orgId, Long costAccountId) {
        QFilter filter = new QFilter(ORG, "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costAccountId);
        filter.and("effectstatus", "=", (Object)"1");
        filter.and("billstatus", "=", (Object)"C");
        DataSet ds = QueryServiceHelper.queryDataSet((String)"proallocstd", (String)"aca_proallocstd", (String)"costaccount,allocentry.costcenter costcenter,allocentry.costdriver costdriver,allocentry.costagent costagent,allocentry.calmethod calmethod,allocentry.productsubentry.costdriverdetail costdriverdetail,allocentry.productsubentry.costagentdetail costagentdetail,allocentry.productsubentry.calmethoddetail calmethoddetail", (QFilter[])filter.toArray(), null);
        HashSet hasStdCostcenters = Sets.newHashSetWithExpectedSize((int)10);
        HashMap customCostcenters = Maps.newHashMapWithExpectedSize((int)10);
        Long zero = 0L;
        for (Row row : ds) {
            Long costagent;
            Long costcenter = row.getLong("costcenter");
            String calmethod = row.getString("calmethod");
            if (costcenter == null) {
                costcenter = zero;
            }
            if (!CadEmptyUtils.isEmpty((Long)costcenter)) {
                hasStdCostcenters.add(costcenter);
            }
            String costdriver = row.getString("costdriver");
            String costdriverdetail = row.getString("costdriverdetail");
            if ("6".equals(costdriver) && !CadEmptyUtils.isEmpty((Long)(costagent = row.getLong("costagent")))) {
                customCostcenters.computeIfAbsent(costcenter, t -> new HashSet()).add(costagent);
                costcenterCalMap.put(costcenter, calmethod);
            }
            if (!"6".equals(costdriverdetail)) continue;
            Long costagentdetail = row.getLong("costagentdetail");
            String calmethoddetail = row.getString("calmethoddetail");
            if (CadEmptyUtils.isEmpty((Long)costagentdetail)) continue;
            customCostcenters.computeIfAbsent(costcenter, t -> new HashSet()).add(costagentdetail);
            costcenterCalMap.put(costcenter, calmethoddetail);
        }
        if (customCostcenters.containsKey(zero)) {
            List costCenterIds = CostCenterHelper.getCostCenterByOrg((Long)orgId, (Long[])new Long[]{4L});
            Set costValue = (Set)customCostcenters.remove(zero);
            String calmethod = costcenterCalMap.remove(zero);
            costCenterIds.removeAll(hasStdCostcenters);
            for (Long costcenter : costCenterIds) {
                customCostcenters.put(costcenter, costValue);
                costcenterCalMap.put(costcenter, calmethod);
            }
        }
        return customCostcenters;
    }

    private static /* synthetic */ void lambda$inproCal$1(Map costCenterMap, DynamicObjectType dynamicObjectType, Long orgId, Long costAccountId, Long period, String sourcetype, List inProList, Row x) {
        Long costcenter = x.getLong("costcenter");
        Long costdriver = x.getLong("costdriver");
        Set costdriverIds = (Set)costCenterMap.get(costcenter);
        if (costdriverIds == null || !costdriverIds.contains(costdriver)) {
            return;
        }
        DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
        Long costobject = x.getLong("costobject");
        BigDecimal value = x.getBigDecimal("value");
        dynamicObject.set("costdriver", (Object)costdriver);
        dynamicObject.set("costobject", (Object)costobject);
        dynamicObject.set("allocvalue", (Object)value);
        dynamicObject.set("costcenter", (Object)costcenter);
        dynamicObject.set("calmethod", (Object)costcenterCalMap.get(costcenter));
        dynamicObject.set(ORG, (Object)orgId);
        dynamicObject.set(COSTACCOUNT, (Object)costAccountId);
        dynamicObject.set(PERIOD, (Object)period);
        dynamicObject.set("sourcetype", (Object)sourcetype);
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        inProList.add(dynamicObject);
    }
}

