/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.business.calc;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.algox.calc.helper.BomRuleSettingStdCalcHelper;
import kd.macc.cad.algox.calc.helper.CostTypeHelper;
import kd.macc.cad.algox.calc.helper.StdCalculateHelper;
import kd.macc.cad.algox.calc.pojo.CostProcessRouteDyo;
import kd.macc.cad.algox.function.ProcessRouteCost;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.common.dto.Keycol;
import kd.macc.cad.common.dto.PlanCostCalcParam;
import kd.macc.cad.common.dto.ProcessCalcDto;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ElementHelper;
import kd.macc.cad.common.helper.MatDimensionHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public class PlanCostCalcHelper {
    private static final Log logger = LogFactory.getLog(PlanCostCalcHelper.class);

    public static void planCostCalc(String entityNum, List<DynamicObject> dynamicObjects, Boolean isAuto) {
        PlanCostCalcParam param = new PlanCostCalcParam();
        try {
            for (DynamicObject dynamicObject : dynamicObjects) {
                param.getEntryIds().add(dynamicObject.getLong("orderentryid"));
                param.getCostTypes().add(dynamicObject.getLong("accountcosttype"));
                param.getLogIds().add(dynamicObject.getLong("id"));
                param.getLogObjMap().put(dynamicObject.getLong("orderentryid"), dynamicObject);
                param.getOrgIds().add(dynamicObject.getLong("org"));
            }
            param.setAuto(isAuto);
            DynamicObjectCollection orders = PlanCostCalcHelper.queryOrderData(entityNum, param.getEntryIds());
            PlanCostCalcHelper.generateCalcParams(param, entityNum, orders);
            logger.info("\u8ba1\u7b97\u8fc7\u7a0b\u6570\u636e\u6784\u5efa\u5b8c\u6210,\u5f00\u59cb\u8fdb\u884c\u8ba1\u7b97==>{}", (Object)param);
            ArrayList<DynamicObject> saveObjList = new ArrayList<DynamicObject>(20);
            for (DynamicObject order : orders) {
                boolean isProceDure;
                StringJoiner logJoiner = new StringJoiner(";");
                long entryId = order.getLong("entryId");
                long process = order.getLong("process");
                BigDecimal yieldRate = order.getBigDecimal("yieldrate").compareTo(new BigDecimal("0.00")) == 0 ? new BigDecimal("1") : order.getBigDecimal("yieldrate");
                BigDecimal rate = order.getBigDecimal("qty").divide(yieldRate, 2, RoundingMode.HALF_UP);
                DynamicObject logObj = (DynamicObject)param.getLogObjMap().get(entryId);
                long costType = logObj.getLong("accountcosttype");
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sca_plancostcalcresult");
                DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("entryentity");
                PlanCostCalcHelper.setBasicInfo(param, entityNum, dynamicObject, order, logObj);
                Long orgId = logObj.getLong("org");
                List stockList = (List)param.getOrderSumMater().get(entryId);
                if (stockList == null || stockList.isEmpty()) {
                    logJoiner.add(ResManager.loadKDString((String)"\u5f53\u524d\u5de5\u5355\u5bf9\u5e94\u7684\u7ec4\u4ef6\u6e05\u5355\u4e3a\u7a7a\u3002", (String)"PlanCostCalcHelper_0", (String)"macc-cad-business", (Object[])new Object[0]));
                } else {
                    int sueModelCount = 0;
                    StringJoiner subJoiner = null;
                    for (DynamicObject obj : stockList) {
                        String sueModel = obj.getString("issuemode");
                        if ("C".equals(sueModel)) {
                            ++sueModelCount;
                            continue;
                        }
                        long l = obj.getLong("submaterial");
                        BigDecimal qty = !obj.getBoolean("iscannegative") ? obj.getBigDecimal("qty") : obj.getBigDecimal("qty").negate();
                        DynamicObject entryObj = entry.addNew();
                        entryObj.set("calcbasis", (Object)"1");
                        entryObj.set("submaterial", (Object)l);
                        entryObj.set("needqty", (Object)qty);
                        String subElementKey = String.format("%s@%s", orgId, l);
                        entryObj.set("subelement", (Object)(param.getSubMatElementMap().get(subElementKey) == null ? param.getSubElement() : (Long)param.getSubMatElementMap().get(subElementKey)));
                        BigDecimal standPrice = (BigDecimal)param.getStandPriceMap().get(l + "@" + logObj.getLong("accountcosttype") + "@" + PlanCostCalcHelper.getKeyColByOrder(param, costType, l, "PM", order, obj));
                        if (standPrice == null) {
                            if (subJoiner == null) {
                                subJoiner = new StringJoiner("\u3001", ResManager.loadKDString((String)"\u5f53\u524d\u5de5\u5355\u5bf9\u5e94\u7684\u7ec4\u4ef6\u6e05\u5355 ", (String)"PlanCostCalcHelper_13", (String)"macc-cad-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u672a\u5728\u7269\u6599\u6210\u672c\u4fe1\u606f\u4e2d\u83b7\u53d6\u5230\u4ef7\u683c\u3002", (String)"PlanCostCalcHelper_14", (String)"macc-cad-business", (Object[])new Object[0]));
                            }
                            subJoiner.add((CharSequence)param.getSubMaterNameMap().get(l));
                            continue;
                        }
                        entryObj.set("price", (Object)standPrice);
                        entryObj.set("needamount", (Object)standPrice.multiply(qty));
                    }
                    if (subJoiner != null) {
                        logJoiner.add(subJoiner.toString());
                    }
                    if (sueModelCount == stockList.size()) {
                        param.getEntryIds().remove(entryId);
                        continue;
                    }
                }
                if (param.isOmOrder()) {
                    long id = order.getLong("masterid");
                    String key = id + "@" + costType + "@" + PlanCostCalcHelper.getKeyColByOrder(param, costType, id, "OM", order, null);
                    DynamicObject omDynamicObj = (DynamicObject)param.getOmPriceMap().get(key);
                    if (omDynamicObj == null) {
                        logJoiner.add(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u5de5\u5355\u7684\u59d4\u5916\u52a0\u5de5\u8d39\u3002", (String)"PlanCostCalcHelper_6", (String)"macc-cad-business", (Object[])new Object[0]));
                    } else {
                        BigDecimal qty = order.getBigDecimal("qty");
                        DynamicObject dynamicObject2 = entry.addNew();
                        dynamicObject2.set("calcbasis", (Object)"0");
                        dynamicObject2.set("submaterial", (Object)order.getLong("masterid"));
                        dynamicObject2.set("needqty", (Object)qty);
                        dynamicObject2.set("needamount", (Object)omDynamicObj.getBigDecimal("price").multiply(qty));
                        dynamicObject2.set("subelement", (Object)omDynamicObj.getLong("subelement.id"));
                        dynamicObject2.set("price", (Object)omDynamicObj.getBigDecimal("price"));
                        DynamicObjectCollection entryEntity = omDynamicObj.getDynamicObjectCollection("entryentity");
                        for (DynamicObject omEntryObj : entryEntity) {
                            DynamicObject omEntry = entry.addNew();
                            omEntry.set("calcbasis", (Object)"0");
                            omEntry.set("submaterial", (Object)order.getLong("masterid"));
                            omEntry.set("needqty", (Object)qty);
                            omEntry.set("needamount", (Object)omEntryObj.getBigDecimal("amount").multiply(qty));
                            omEntry.set("subelement", (Object)omEntryObj.getLong("extsubelement.id"));
                            omEntry.set("price", (Object)omEntryObj.getBigDecimal("amount"));
                        }
                    }
                }
                if (isProceDure = order.getBoolean("isprocedure")) {
                    Long gxId = (Long)param.getOrderGxIdMap().get(entryId);
                    if (gxId == null) {
                        logger.info("\u5f53\u524d\u5de5\u5355\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u5de5\u5e8f\u8ba1\u5212\uff0c\u4e0d\u8ba1\u7b97\u672c\u5c42\u6210\u672c");
                        process = 0L;
                    } else {
                        process = gxId;
                    }
                }
                if (!CadEmptyUtils.isEmpty((Long)process)) {
                    DynamicObject entryObj;
                    String key = process + "@" + costType + "@" + order.getLong("masterid") + "@" + order.getLong("auxproperty");
                    List list = (List)param.getProcessMap().get(key);
                    if (list == null) {
                        if (isProceDure) {
                            logJoiner.add(ResManager.loadKDString((String)"\u5f53\u524d\u5de5\u5355\u5de5\u5e8f\u8ba1\u5212\u5bf9\u5e94\u7684\u8d44\u6e90\u6210\u672c\u4e3a\u7a7a\u3002", (String)"PlanCostCalcHelper_7", (String)"macc-cad-business", (Object[])new Object[0]));
                        } else {
                            logJoiner.add(ResManager.loadKDString((String)"\u5f53\u524d\u5de5\u5355\u5de5\u827a\u8def\u7ebf\u5bf9\u5e94\u7684\u8d44\u6e90\u6210\u672c\u4e3a\u7a7a\u3002", (String)"PlanCostCalcHelper_8", (String)"macc-cad-business", (Object[])new Object[0]));
                        }
                        Map longBigDecimalMap = (Map)param.getRouterResMap().get(process);
                        if (longBigDecimalMap != null) {
                            for (Map.Entry entry2 : longBigDecimalMap.entrySet()) {
                                entryObj = entry.addNew();
                                entryObj.set("calcbasis", (Object)"0");
                                entryObj.set("resource", entry2.getKey());
                                entryObj.set("needqty", entry2.getValue());
                            }
                        }
                    } else {
                        BigDecimal planQty = order.getBigDecimal("planqty");
                        for (ProcessCalcDto processCalcDto : list) {
                            entryObj = entry.addNew();
                            entryObj.set("calcbasis", (Object)"0");
                            entryObj.set("resource", (Object)processCalcDto.getResource());
                            entryObj.set("needqty", (Object)processCalcDto.getQty().multiply(planQty));
                            entryObj.set("needamount", (Object)processCalcDto.getCost().multiply(rate));
                            entryObj.set("subelement", (Object)processCalcDto.getSubElement());
                            entryObj.set("caltype", (Object)processCalcDto.getCalType());
                            entryObj.set("processseq", (Object)processCalcDto.getProcessSeq());
                            entryObj.set("operationno", (Object)processCalcDto.getOperationNo());
                            if (entryObj.getBigDecimal("needqty").compareTo(BigDecimal.ZERO) == 0) {
                                entryObj.set("price", (Object)BigDecimal.ZERO);
                                entryObj.set("needamount", (Object)BigDecimal.ZERO);
                                if (BigDecimal.ZERO.compareTo(planQty) == 0) {
                                    logJoiner.add(ResManager.loadKDString((String)"\u5f53\u524d\u5de5\u5355\u5bf9\u5e94\u7684\u8ba1\u5212\u6570\u91cf\u4e3a0\u3002", (String)"PlanCostCalcHelper_9", (String)"macc-cad-business", (Object[])new Object[0]));
                                    continue;
                                }
                                logJoiner.add(ResManager.loadKDString((String)"\u5f53\u524d\u5de5\u5355\u5bf9\u5e94\u7684\u8d44\u6e90\u57fa\u672c\u6570\u91cf\u4e3a0\u3002", (String)"PlanCostCalcHelper_10", (String)"macc-cad-business", (Object[])new Object[0]));
                                continue;
                            }
                            entryObj.set("price", (Object)entryObj.getBigDecimal("needamount").divide(entryObj.getBigDecimal("needqty"), 4));
                        }
                    }
                }
                saveObjList.add(dynamicObject);
                param.getEntryLogMap().put(entryId, logJoiner.toString());
            }
            PlanCostCalcHelper.writeBackCalcLog(param);
            PlanCostCalcHelper.invalidPlanCostResultBill(param);
            if (!saveObjList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])saveObjList.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e) {
            logger.info("\u8ba1\u5212\u6210\u672c\u8ba1\u7b97\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38 ==>{}", (Object)e);
            PlanCostCalcHelper.writeErrorLog(param, e.getMessage());
            throw e;
        }
    }

    private static String getKeyColByOrder(PlanCostCalcParam param, long costType, long material, String type, DynamicObject order, DynamicObject subOrder) {
        DynamicObject dynamicObject;
        Map map = (Map)param.getCostDimensionMap().get(costType);
        HashMap<String, Long> keyColMap = new HashMap<String, Long>(10);
        keyColMap.put("material", material);
        if (map != null && (dynamicObject = (DynamicObject)map.get(material)) != null) {
            Set<String> dimensionsFields = PlanCostCalcHelper.getDimensions(dynamicObject.getString("dimension"));
            for (String field : dimensionsFields) {
                if ("assist".equals(field)) {
                    field = "auxproperty";
                }
                if ("OM".equals(type)) {
                    if (!order.containsProperty(field)) continue;
                    if (CadEmptyUtils.isEmpty((Long)order.getLong(field))) {
                        return "0";
                    }
                    keyColMap.put(field, order.getLong(field));
                    continue;
                }
                if (subOrder == null || !subOrder.containsProperty(field)) continue;
                if (CadEmptyUtils.isEmpty((Long)subOrder.getLong(field))) {
                    return "0";
                }
                keyColMap.put(field, subOrder.getLong(field));
            }
        }
        String keyCol = CalcKeyHelper.getCalcKey(keyColMap, new ArrayList(), (boolean)false).getKeycol();
        logger.info("\u5de5\u5355\u7f16\u53f7==>{}\u5bf9\u5e94\u7684\u7ef4\u5ea6\u5b57\u6bb5\u96c6\u5408\u4e3a{},\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6keyCol\u4e3a==>{}", new Object[]{order.getString("billno"), keyColMap, keyCol});
        return keyCol;
    }

    private static void setBasicInfo(PlanCostCalcParam param, String entityNum, DynamicObject dynamicObject, DynamicObject order, DynamicObject logObj) {
        long entryId = order.getLong("entryId");
        dynamicObject.set("billno", (Object)order.getString("billno"));
        dynamicObject.set("org", (Object)logObj.getLong("org"));
        dynamicObject.set("manuorg", (Object)order.getLong("manuorg"));
        dynamicObject.set("costtype", (Object)logObj.getLong("accountcosttype"));
        dynamicObject.set("billstatus", (Object)"B");
        dynamicObject.set("billtype", (Object)entityNum);
        dynamicObject.set("calcdate", (Object)new Date());
        dynamicObject.set("effectdate", (Object)(param.getEntryMap().get(entryId) == null ? DateUtils.getDefaultEffectDate() : logObj.getDate("releasedate")));
        dynamicObject.set("expdate", (Object)DateUtils.getDeFaultExpDate());
        dynamicObject.set("orderno", (Object)order.getString("billno"));
        dynamicObject.set("orderentryseq", (Object)order.getInt("seq"));
        dynamicObject.set("orderentryid", (Object)entryId);
        dynamicObject.set("material", (Object)order.getLong("masterid"));
        dynamicObject.set("processroute", (Object)order.getLong("process"));
        dynamicObject.set("configuredcode", (Object)order.getLong("configuredcode"));
        dynamicObject.set("tracknumber", (Object)order.getLong("tracknumber"));
        dynamicObject.set("planqty", (Object)order.getLong("planqty"));
        Keycol keyCol = PlanCostCalcHelper.getKeyCol(order.getLong("masterid"), order.getLong("configuredcode"), order.getLong("tracknumber"));
        dynamicObject.set("keycol", (Object)keyCol.getKeycol());
        dynamicObject.set("keycolid", (Object)keyCol.getId());
    }

    private static Keycol getKeyCol(Long material, Long configuredCode, Long trackNumber) {
        HashMap<String, Long> keyColMap = new HashMap<String, Long>(10);
        ArrayList extColList = new ArrayList(10);
        keyColMap.put("material", material);
        if (!CadEmptyUtils.isEmpty((Long)configuredCode)) {
            keyColMap.put("configuredcode", configuredCode);
        }
        if (!CadEmptyUtils.isEmpty((Long)trackNumber)) {
            keyColMap.put("tracknumber", trackNumber);
        }
        return CalcKeyHelper.getCalcKey(keyColMap, extColList, (boolean)true);
    }

    private static void generateCalcParams(PlanCostCalcParam param, String entityNum, DynamicObjectCollection orders) {
        param.setEntityNum(entityNum);
        for (DynamicObject order : orders) {
            boolean isProceDure = order.getBoolean("isprocedure");
            if (isProceDure) {
                param.getProceDureEntryIds().add(order.getLong("entryId"));
            } else if (!CadEmptyUtils.isEmpty((Long)order.getLong("process"))) {
                param.getProcessIds().add(order.getLong("process"));
                param.getMatGroupCommonRouteMatInfoMap().computeIfAbsent(order.getLong("process"), p -> new HashSet()).add(order.getLong("masterid") + "@" + order.getLong("auxproperty"));
            }
            param.getMaterial().add(order.getLong("masterid"));
        }
        PlanCostCalcHelper.buildSubMaterial(param);
        PlanCostCalcHelper.buildOmPrice(param);
        PlanCostCalcHelper.buildProcess(param);
        PlanCostCalcHelper.buildDimension(param);
        PlanCostCalcHelper.buildEntryExist(param);
    }

    private static void buildEntryExist(PlanCostCalcParam param) {
        QFilter filter = new QFilter("orderentryid", "in", (Object)param.getEntryIds());
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"sca_plancostcalcresult", (String)"orderentryid,id", (QFilter[])new QFilter[]{filter});
        HashMap<Long, Long> entryMap = new HashMap<Long, Long>();
        for (DynamicObject object : objects) {
            entryMap.put(object.getLong("orderentryid"), object.getLong("id"));
        }
        param.setEntryMap(entryMap);
    }

    private static void buildDimension(PlanCostCalcParam param) {
        DynamicObject[] load;
        param.getSubMaterial().addAll(param.getMaterial());
        block0: for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"cad_costtype", (String)"id,costtypeentry.costtypeattr,costtypeentry.costtype,", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)param.getCostTypes())})) {
            DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("costtypeentry");
            for (DynamicObject obj : entry) {
                if (!"1".equals(obj.getString("costtypeattr"))) continue;
                long simCostType = obj.getLong("costtype.id");
                Map map = MatDimensionHelper.getDimensionByMatIds((Long)simCostType, (Set)param.getSubMaterial());
                if (map.isEmpty()) continue block0;
                param.getCostDimensionMap().put(dynamicObject.getLong("id"), map);
                continue block0;
            }
        }
    }

    private static DynamicObjectCollection queryOrderData(String entityNum, Set<Long> entryIds) {
        QFilter filter = new QFilter("treeentryentity.id", "in", entryIds);
        filter.and("billstatus", "=", (Object)"C");
        filter.and("treeentryentity.planstatus", "=", (Object)"C");
        return QueryServiceHelper.query((String)entityNum, (String)"org.id as manuorg,billno,transactiontype.isprocedure as isprocedure,treeentryentity.seq as seq,treeentryentity.id as entryId,treeentryentity.producttype as productType,treeentryentity.material as material,treeentryentity.material.masterid as masterid,treeentryentity.processroute.id as process,treeentryentity.qty as qty,treeentryentity.baseqty as planqty,treeentryentity.yieldrate as yieldrate,treeentryentity.tracknumber as tracknumber,treeentryentity.configuredcode as configuredcode,treeentryentity.auxproperty as auxproperty", (QFilter[])new QFilter[]{filter});
    }

    private static void invalidPlanCostResultBill(PlanCostCalcParam param) {
        QFilter filter = new QFilter("billtype", "=", (Object)param.getEntityNum());
        filter.and("orderentryid", "in", (Object)param.getEntryIds());
        filter.and("effectdate", "<=", (Object)new Date());
        filter.and("expdate", ">", (Object)new Date());
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"sca_plancostcalcresult", (String)"orderentryid,expdate", (QFilter[])new QFilter[]{filter});
        if (objects.length > 0) {
            for (DynamicObject object : objects) {
                DynamicObject dynamicObject = (DynamicObject)param.getLogObjMap().get(object.getLong("orderentryid"));
                if (dynamicObject == null) continue;
                object.set("expdate", (Object)dynamicObject.getDate("releasedate"));
            }
            SaveServiceHelper.update((DynamicObject[])objects);
            logger.info("\u672c\u6b21\u5171\u5931\u6548\u8ba1\u7b97\u7ed3\u679c\u5355==>{}\u6761", (Object)objects.length);
        }
    }

    private static void buildProcess(PlanCostCalcParam param) {
        QFilter gxFilter = new QFilter("mftentryseq", "in", (Object)param.getProceDureEntryIds());
        gxFilter.and("oprentryentity.oprstatus", "in", (Object)Sets.newHashSet((Object[])new String[]{"D", "E", "F", "G"}));
        gxFilter.and("billstatus", "=", (Object)"C");
        DynamicObjectCollection gxDynamicObjs = QueryServiceHelper.query((String)param.getGxEntity(), (String)"id,mftentryseq as orderEntryId", (QFilter[])new QFilter[]{gxFilter});
        HashSet<Long> gxIds = new HashSet<Long>(10);
        for (DynamicObject gxDynamicObj : gxDynamicObjs) {
            gxIds.add(gxDynamicObj.getLong("id"));
            param.getOrderGxIdMap().put(gxDynamicObj.getLong("orderEntryId"), gxDynamicObj.getLong("id"));
        }
        DynamicObject[] process = BusinessDataServiceHelper.load((String)"pdm_route", (String)BomRuleSettingStdCalcHelper.getRouteFields((String)"pdm_route"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)param.getProcessIds())});
        PlanCostCalcHelper.removeTdProcessSeqData(process, param.getProcessIds(), "pdm_route", new Date());
        DynamicObject[] workingPro = BusinessDataServiceHelper.load((String)param.getGxEntity(), (String)BomRuleSettingStdCalcHelper.getGxRouteFields(), (QFilter[])new QFilter[]{new QFilter("id", "in", gxIds)});
        PlanCostCalcHelper.removeTdProcessSeqData(workingPro, gxIds, param.getGxEntity(), new Date());
        param.getProcessIds().addAll(gxIds);
        long taskId = ID.genLongId();
        for (Long costType : param.getCostTypes()) {
            CostProcessRouteDyo costProcessRoute;
            ProcessRouteCost processRouteCost = new ProcessRouteCost();
            StandCostCalcParam standCostCalcParam = new StandCostCalcParam();
            standCostCalcParam.setPriceprecision(10);
            standCostCalcParam.setCostTypeId(costType.toString());
            standCostCalcParam.setPlanCost(true);
            standCostCalcParam.setCalcDate(new Date());
            standCostCalcParam.setTaskId(taskId);
            processRouteCost.setStandCostCalcParam(standCostCalcParam);
            DynamicObject costTypeObj = CostTypeHelper.getCostType((Long)standCostCalcParam.getCostTypeId(), (String)"createorg");
            if (costTypeObj != null) {
                standCostCalcParam.setEnableMulFactory(Boolean.valueOf(OrgHelper.isOrgEnableMultiFactory((Long)costTypeObj.getLong("createorg.id"))));
            }
            HashMap<Long, DynamicObject> glMap = new HashMap<Long, DynamicObject>(16);
            for (DynamicObject dynamicObject : process) {
                if ("A".equals(dynamicObject.getString("processtype"))) {
                    param.getMatGroupCommonRouteMatInfoMap().remove(dynamicObject.getLong("id"));
                }
                glMap.put(dynamicObject.getLong("id"), dynamicObject);
            }
            Set resourceIds = BomRuleSettingStdCalcHelper.dealRoute(glMap, (StandCostCalcParam)standCostCalcParam);
            HashMap<Long, DynamicObject> gxMap = new HashMap<Long, DynamicObject>(16);
            HashSet<Long> gxProcessIds = new HashSet<Long>(param.getProcessIds());
            for (DynamicObject dynamicObject3 : workingPro) {
                gxMap.put(dynamicObject3.getLong("id"), dynamicObject3);
                if (dynamicObject3.get("processroute") == null) continue;
                gxProcessIds.add(dynamicObject3.getLong("processroute.id"));
            }
            Set set = BomRuleSettingStdCalcHelper.dealRoute(gxMap, (StandCostCalcParam)standCostCalcParam);
            resourceIds.addAll(set);
            PlanCostCalcHelper.setResourceId(resourceIds, gxProcessIds, standCostCalcParam);
            gxProcessIds.clear();
            logger.info("\u8ba1\u5212\u6210\u672c\u8ba1\u7b97\u83b7\u53d6\u81ea\u5236\u8d44\u6e90ID\u96c6\u5408==>{}", (Object)standCostCalcParam.getInSourceObjIds());
            logger.info("\u8ba1\u5212\u6210\u672c\u8ba1\u7b97\u83b7\u53d6\u5916\u534f\u8d44\u6e90ID\u96c6\u5408==>{}", (Object)standCostCalcParam.getOutSourceObjIds());
            Map resourceRateIdAndAttachCostMap = processRouteCost.getResourceRateIdAndAttachCostMap();
            Map resourceIdAndObjMap = processRouteCost.getResourceAndObjMap();
            Map outResourceAndObjMap = processRouteCost.getOutResourceAndObjMap();
            Map matGroupCommonRouteMatInfoMap = param.getMatGroupCommonRouteMatInfoMap();
            for (DynamicObject processRoute : process) {
                logger.info("\u5f53\u524d\u5de5\u827a\u8def\u7ebfID==>{}", (Object)processRoute.getLong("id"));
                if ("B".equals(processRoute.getString("processtype")) || "C".equals(processRoute.getString("processtype"))) {
                    Set matInfos = (Set)matGroupCommonRouteMatInfoMap.get(processRoute.getLong("id"));
                    if (CadEmptyUtils.isEmpty((Set)matInfos)) continue;
                    for (String matInfo : matInfos) {
                        String[] split = matInfo.split("@");
                        CostProcessRouteDyo costProcessRoute2 = processRouteCost.getCostProcessRoute(processRoute);
                        HashMap<String, Long> values = new HashMap<String, Long>(5);
                        values.put("material", Long.valueOf(split[0]));
                        values.put("auxproperty", Long.valueOf(split[1]));
                        Keycol calcKey = CalcKeyHelper.getCalcKey(values, new ArrayList(), (boolean)true);
                        costProcessRoute2.setMaterial(Long.valueOf(split[0]));
                        costProcessRoute2.setAuxpty(Long.valueOf(split[1]));
                        costProcessRoute2.setKeycol(calcKey.getKeycol());
                        processRouteCost.calcProcessRouteCost(costProcessRoute2, resourceIdAndObjMap, outResourceAndObjMap, resourceRateIdAndAttachCostMap, null);
                        PlanCostCalcHelper.buildRouterIdResourceMap(processRoute, costProcessRoute2, param);
                    }
                    continue;
                }
                costProcessRoute = processRouteCost.getCostProcessRoute(processRoute);
                processRouteCost.calcProcessRouteCost(costProcessRoute, resourceIdAndObjMap, outResourceAndObjMap, resourceRateIdAndAttachCostMap, null);
                PlanCostCalcHelper.buildRouterIdResourceMap(processRoute, costProcessRoute, param);
            }
            for (DynamicObject dynamicObject4 : workingPro) {
                logger.info("\u5f53\u524d\u5de5\u5e8f\u8ba1\u5212ID==>{}", (Object)dynamicObject4.getLong("id"));
                costProcessRoute = BomRuleSettingStdCalcHelper.getCostProcessRouteByWork((DynamicObject)dynamicObject4);
                processRouteCost.calcProcessRouteCost(costProcessRoute, resourceIdAndObjMap, outResourceAndObjMap, resourceRateIdAndAttachCostMap, null);
                PlanCostCalcHelper.buildRouterIdResourceMap(dynamicObject4, costProcessRoute, param);
            }
        }
        QFilter queryFilter = new QFilter("router", "in", (Object)param.getProcessIds());
        queryFilter.and("task", "=", (Object)taskId);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"cad_calprocessroutecost", (String)"costtype,router,processseq,operationno,material,auxpty,resource,qty,price,cost,calcbasis,subelement", (QFilter[])new QFilter[]{queryFilter});
        for (DynamicObject dynamicObject : result) {
            long router = dynamicObject.getLong("router");
            long costType = dynamicObject.getLong("costtype");
            ProcessCalcDto processCalcDto = new ProcessCalcDto();
            processCalcDto.setResource(Long.valueOf(dynamicObject.getLong("resource")));
            processCalcDto.setQty(dynamicObject.getBigDecimal("qty"));
            processCalcDto.setPrice(dynamicObject.getBigDecimal("price"));
            processCalcDto.setCost(dynamicObject.getBigDecimal("cost"));
            processCalcDto.setSubElement(Long.valueOf(dynamicObject.getLong("subelement")));
            processCalcDto.setCalType(dynamicObject.getString("calcbasis"));
            processCalcDto.setProcessSeq(dynamicObject.getString("processseq"));
            processCalcDto.setOperationNo(dynamicObject.getString("operationno"));
            String string = router + "@" + costType + "@" + dynamicObject.getLong("material") + "@" + dynamicObject.getLong("auxpty");
            param.getProcessMap().computeIfAbsent(string, r -> new ArrayList()).add(processCalcDto);
        }
        HashMap resultMap = new HashMap(16);
        Map processMap = param.getProcessMap();
        for (Map.Entry entry : processMap.entrySet()) {
            List values = (List)entry.getValue();
            HashMap<String, ProcessCalcDto> map = new HashMap<String, ProcessCalcDto>();
            for (ProcessCalcDto processCalcDto : values) {
                String key = processCalcDto.getResource() + "@" + processCalcDto.getSubElement() + "@" + processCalcDto.getProcessSeq() + "@" + processCalcDto.getOperationNo();
                if (map.get(key) == null) {
                    map.put(key, processCalcDto);
                    continue;
                }
                ProcessCalcDto processCalcDto2 = (ProcessCalcDto)map.get(key);
                processCalcDto2.setCost(processCalcDto2.getCost().add(processCalcDto.getCost()));
                processCalcDto2.setPrice(processCalcDto2.getPrice().add(processCalcDto.getPrice()));
                processCalcDto2.setQty(processCalcDto2.getQty().add(processCalcDto.getQty()));
                map.put(key, processCalcDto2);
            }
            ArrayList list = new ArrayList(16);
            for (Map.Entry stringProcessCalcDtoEntry : map.entrySet()) {
                list.add(stringProcessCalcDtoEntry.getValue());
            }
            resultMap.put(entry.getKey(), list);
        }
        param.setProcessMap(resultMap);
    }

    private static void removeTdProcessSeqData(DynamicObject[] process, Set<Long> ids, String entity, Date calcDate) {
        block8: {
            QFilter filter;
            block7: {
                filter = new QFilter("id", "in", ids);
                if (!"pdm_route".equals(entity)) break block7;
                QFilter typeFilter = new QFilter("entryentity.processseqtype", "in", (Object)new String[]{"A", "B"});
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entity, (String)"processentry.id processentryid", (QFilter[])new QFilter[]{filter, typeFilter});
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)dynamicObjects)) {
                    return;
                }
                Set processEntryIds = DynamicObjectHelper.getIdSet((DynamicObjectCollection)dynamicObjects, (String)"processentryid");
                for (DynamicObject cadRouter : process) {
                    DynamicObjectCollection processEntrys = cadRouter.getDynamicObjectCollection("processentry");
                    if (CadEmptyUtils.isEmpty((DynamicObjectCollection)processEntrys)) continue;
                    Iterator iterator = processEntrys.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject processEntry = (DynamicObject)iterator.next();
                        long id = processEntry.getLong("id");
                        if (!processEntryIds.contains(id)) {
                            iterator.remove();
                            continue;
                        }
                        Date entryValiddate = processEntry.getDate("entryvaliddate");
                        Date entryInvaliddate = processEntry.getDate("entryinvaliddate");
                        if (entryValiddate != null && entryInvaliddate != null && entryValiddate.getTime() <= calcDate.getTime() && entryInvaliddate.getTime() >= calcDate.getTime()) continue;
                        iterator.remove();
                    }
                }
                break block8;
            }
            if (!"sfc_manftech".equals(entity) && !"om_mfttechnics".equals(entity)) break block8;
            QFilter typeFilter = new QFilter("proentryentity.processseqtype", "in", (Object)new String[]{"A", "B"});
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entity, (String)"oprentryentity.id oprentryentityid", (QFilter[])new QFilter[]{filter, typeFilter});
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)dynamicObjects)) {
                return;
            }
            Set processEntryIds = DynamicObjectHelper.getIdSet((DynamicObjectCollection)dynamicObjects, (String)"oprentryentityid");
            for (DynamicObject cadRouter : process) {
                DynamicObjectCollection processEntrys = cadRouter.getDynamicObjectCollection("oprentryentity");
                if (CadEmptyUtils.isEmpty((DynamicObjectCollection)processEntrys)) continue;
                Iterator iterator = processEntrys.iterator();
                while (iterator.hasNext()) {
                    DynamicObject processEntry = (DynamicObject)iterator.next();
                    long id = processEntry.getLong("id");
                    if (processEntryIds.contains(id)) continue;
                    iterator.remove();
                }
            }
        }
    }

    private static void setResourceId(Set<Long> resourceIds, Set<Long> processIds, StandCostCalcParam standCostCalcParam) {
        for (Map.Entry entry : standCostCalcParam.getProOrgCostTypeMap().entrySet()) {
            Long costType = (Long)entry.getValue();
            if (!CadEmptyUtils.isEmpty(resourceIds)) {
                standCostCalcParam.getInSourceObjIds().addAll(PlanCostCalcHelper.getInResourcePriceIds(costType, resourceIds, standCostCalcParam.getCalcDate()));
            }
            if (CadEmptyUtils.isEmpty(processIds)) continue;
            standCostCalcParam.getOutSourceObjIds().addAll(PlanCostCalcHelper.getOutResourcePriceIds(costType, processIds, standCostCalcParam.getCalcDate()));
        }
    }

    private static List<Long> getInResourcePriceIds(Long hsCostType, Set<Long> resourceIds, Date calcDate) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        qFilterList.add(new QFilter("costtype", "=", (Object)hsCostType));
        qFilterList.add(new QFilter("billstatus", "=", (Object)"C"));
        qFilterList.add(new QFilter("resource", "in", resourceIds));
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)calcDate);
        dateFilter.and(new QFilter("expdate", ">", (Object)calcDate));
        qFilterList.add(dateFilter);
        DynamicObjectCollection resourceObjs = StdCalculateHelper.getInResourceObjs((QFilter[])qFilterList.toArray(new QFilter[0]));
        return DynamicObjectHelper.getIdList((DynamicObjectCollection)resourceObjs, (String)"id");
    }

    private static List<Long> getOutResourcePriceIds(Long hsCostType, Set<Long> processIds, Date calcDate) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        qFilterList.add(new QFilter("costtype", "=", (Object)hsCostType));
        qFilterList.add(new QFilter("billstatus", "=", (Object)"C"));
        qFilterList.add(new QFilter("route", "in", processIds));
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)calcDate);
        dateFilter.and(new QFilter("expdate", ">", (Object)calcDate));
        qFilterList.add(dateFilter);
        DynamicObjectCollection resourceObjs = StdCalculateHelper.getOutResourceObjs((QFilter[])qFilterList.toArray(new QFilter[0]));
        return DynamicObjectHelper.getIdList((DynamicObjectCollection)resourceObjs, (String)"id");
    }

    private static void buildRouterIdResourceMap(DynamicObject dynamicObject, CostProcessRouteDyo costProcessRoute, PlanCostCalcParam param) {
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>(10);
        for (CostProcessRouteDyo.processEntryRow processEntryRow2 : costProcessRoute.getProcessEntryRows()) {
            List actEntryRows = processEntryRow2.getActEntryRows();
            for (CostProcessRouteDyo.processEntryRow.ActEntryRow actEntryRow : actEntryRows) {
                BigDecimal qty = actEntryRow.getBaseQty();
                long activityUnit = actEntryRow.getActivityUnit();
                if (activityUnit == 8L) {
                    qty = qty.divide(new BigDecimal("60"), 10, 4);
                }
                if (activityUnit == 10L) {
                    qty = qty.multiply(new BigDecimal("60"));
                }
                map.merge(actEntryRow.getActResource(), qty, (a, b) -> b.add((BigDecimal)a));
            }
        }
        param.getRouterResMap().put(dynamicObject.getLong("id"), map);
    }

    private static void buildOmPrice(PlanCostCalcParam param) {
        if (param.isOmOrder()) {
            DynamicObject[] load;
            QFilter filter = new QFilter("billstatus", "=", (Object)"C");
            filter.and("effectdate", "<=", (Object)new Date());
            filter.and("expdate", ">", (Object)new Date());
            filter.and("costtype", "in", (Object)param.getCostTypes());
            filter.and("material", "in", (Object)param.getMaterial());
            for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"cad_outsourceprice", (String)"material.id as material,costtype.id as costtype,keycol,subelement,price,entryentity.extsubelement,entryentity.amount", (QFilter[])new QFilter[]{filter})) {
                param.getOmPriceMap().put(dynamicObject.getString("material.id") + "@" + dynamicObject.getString("costtype.id") + "@" + dynamicObject.getString("keycol"), dynamicObject);
            }
        }
    }

    private static void buildSubMaterial(PlanCostCalcParam param) {
        DynamicObject dynamicObject2;
        QFilter filter = new QFilter("orderentryid", "in", (Object)param.getEntryIds());
        filter.and("billstatus", "=", (Object)"C");
        String selectField = "orderno,productid,orderentryid.id as orderentryid,stockentry.materialid.masterid as submaterial,stockentry.demandqty qty,stockentry.entryconfiguredcode as configuredcode,0L as tracknumber,stockentry.childauxpropertyid as auxproperty,stockentry.issuemode as issuemode,stockentry.iscannegative as iscannegative";
        if ("om_mftstock".equals(param.getSubStockNum())) {
            selectField = "orderno,productid,orderentryid.id as orderentryid,stockentry.materialid.masterid as submaterial,stockentry.demandqty qty,stockentry.entryconfiguredcode as configuredcode,stockentry.childauxpropertyid as auxproperty,stockentry.issuemode as issuemode,stockentry.iscannegative as iscannegative";
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)param.getSubStockNum(), (String)selectField, (QFilter[])new QFilter[]{filter});
        for (DynamicObject dynamicObject2 : collection) {
            long subMaterial = dynamicObject2.getLong("submaterial");
            if (CadEmptyUtils.isEmpty((Long)subMaterial)) continue;
            param.getSubMaterial().add(subMaterial);
            param.getOrderSumMater().computeIfAbsent(dynamicObject2.getLong("orderentryid"), t -> new ArrayList()).add(dynamicObject2);
        }
        if (!param.getSubMaterial().isEmpty()) {
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_material", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)param.getSubMaterial())});
            HashMap<Long, String> subMaterNameMap = new HashMap<Long, String>(dynamicObjects.size());
            for (DynamicObject dynamicObject3 : dynamicObjects) {
                subMaterNameMap.put(dynamicObject3.getLong("id"), dynamicObject3.getString("name"));
            }
            param.setSubMaterNameMap(subMaterNameMap);
            QFilter costInfoFilter = new QFilter("enable", "=", (Object)"1");
            costInfoFilter.and("effectdate", "<=", (Object)new Date());
            costInfoFilter.and("expdate", ">", (Object)new Date());
            costInfoFilter.and("material.id", "in", (Object)param.getSubMaterial());
            costInfoFilter.and("costtype", "in", (Object)param.getCostTypes());
            DynamicObjectCollection costInfoObj = QueryServiceHelper.query((String)"cad_matcostinfo", (String)"id,keycol,material.id as material,costtype.id as costtype,entryentity.standardcost as stdprice", (QFilter[])new QFilter[]{costInfoFilter});
            for (DynamicObject dynamicObject4 : costInfoObj) {
                String mapKey = dynamicObject4.getString("material") + "@" + dynamicObject4.getString("costtype") + "@" + dynamicObject4.getString("keycol");
                BigDecimal stdPrice = dynamicObject4.getBigDecimal("stdprice");
                param.getStandPriceMap().merge(mapKey, stdPrice, BigDecimal::add);
            }
            for (Long orgId : param.getOrgIds()) {
                if (CadEmptyUtils.isEmpty((Long)orgId)) continue;
                Map matEleMap = ElementHelper.getDefSubEles((Long)orgId, (Set)param.getSubMaterial(), (boolean)false);
                for (Map.Entry entry : matEleMap.entrySet()) {
                    param.getSubMatElementMap().put(orgId + "@" + entry.getKey(), ((Long[])entry.getValue())[1]);
                }
            }
        }
        QFilter qFilter = new QFilter("type", "=", (Object)"001");
        qFilter.and("defaultvalue", "=", (Object)true);
        dynamicObject2 = QueryServiceHelper.queryOne((String)"cad_subelement", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject2 != null) {
            param.setSubElement(Long.valueOf(dynamicObject2.getLong("id")));
        }
    }

    private static void writeBackCalcLog(PlanCostCalcParam param) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"sca_plancostcalclog");
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])param.getLogIds().toArray(), (DynamicObjectType)mainEntityType);
        if (load.length > 0) {
            for (DynamicObject dynamicObject : load) {
                String log;
                dynamicObject.set("status", (Object)"02");
                dynamicObject.set("lastexecdate", (Object)new Date());
                dynamicObject.set("trytimes", (Object)(dynamicObject.getInt("trytimes") + 1));
                if (!param.getAuto().booleanValue()) {
                    dynamicObject.set("operator", (Object)RequestContext.get().getUserId());
                    dynamicObject.set("operdate", (Object)new Date());
                }
                if ((log = (String)param.getEntryLogMap().get(dynamicObject.getLong("orderentryid"))) == null) {
                    dynamicObject.set("execlog", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u5de5\u5355\u5df2\u88ab\u5220\u9664\u6216\u5355\u636e\u72b6\u6001\u53ca\u8ba1\u5212\u72b6\u6001\u4e0d\u7b49\u4e8e\u5df2\u5ba1\u6838\u6216\u5df2\u4e0b\u8fbe\uff0c\u4e0d\u751f\u6210\u8ba1\u5212\u6210\u672c\u8ba1\u7b97\u7ed3\u679c\u5355\u3002", (String)"PlanCostCalcHelper_11", (String)"macc-cad-business", (Object[])new Object[0]));
                    continue;
                }
                if (log.trim().length() == 0) {
                    dynamicObject.set("execlog", (Object)ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)"PlanCostCalcHelper_12", (String)"macc-cad-business", (Object[])new Object[0]));
                    continue;
                }
                dynamicObject.set("execlog", (Object)(log.length() > 2000 ? log.substring(0, 2000) : log));
            }
            logger.info("\u672c\u6b21\u56de\u5199\u8ba1\u5212\u6210\u672c\u8ba1\u7b97\u65e5\u5fd7==>{}\u6761", (Object)load.length);
            SaveServiceHelper.update((DynamicObject[])load);
        }
    }

    private static void writeErrorLog(PlanCostCalcParam param, String errorMsg) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"sca_plancostcalclog");
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])param.getLogIds().toArray(), (DynamicObjectType)mainEntityType);
        if (load.length > 0) {
            for (DynamicObject dynamicObject : load) {
                dynamicObject.set("status", (Object)"03");
                dynamicObject.set("lastexecdate", (Object)new Date());
                dynamicObject.set("trytimes", (Object)(dynamicObject.getInt("trytimes") + 1));
                if (errorMsg == null) {
                    dynamicObject.set("execlog", (Object)"null");
                } else {
                    dynamicObject.set("execlog", (Object)(errorMsg.length() > 2000 ? errorMsg.substring(0, 2000) : errorMsg));
                }
                if (param.getAuto().booleanValue()) continue;
                dynamicObject.set("operator", (Object)RequestContext.get().getUserId());
                dynamicObject.set("operdate", (Object)new Date());
            }
            SaveServiceHelper.update((DynamicObject[])load);
        }
    }

    private static Set<String> getDimensions(String dimension) {
        dimension = dimension.substring(1, dimension.length() - 1);
        String[] split = dimension.split(",");
        HashSet<String> set = new HashSet<String>(split.length + 3);
        for (String item : split) {
            set.add(item);
        }
        return set;
    }
}

